/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.quartz.service;

import cn.sliew.carp.framework.common.dict.schedule.CarpScheduleStatus;
import cn.sliew.carp.module.scheduler.api.scheduler.JobScheduler;
import cn.sliew.carp.module.scheduler.quartz.service.QuartzJobHandler;
import cn.sliew.carp.module.scheduler.quartz.service.QuartzUtil;
import cn.sliew.carp.module.scheduler.quartz.service.listener.QuartzJobListener;
import cn.sliew.carp.module.scheduler.quartz.service.listener.QuartzSchedulerListener;
import cn.sliew.carp.module.scheduler.quartz.service.listener.QuartzTriggerListener;
import cn.sliew.carp.module.scheduler.service.ScheduleJobInstanceService;
import cn.sliew.carp.module.scheduler.service.dto.ScheduleJobConfigDTO;
import cn.sliew.carp.module.scheduler.service.dto.ScheduleJobInstanceDTO;
import cn.sliew.milky.common.exception.Rethrower;
import org.apache.commons.lang3.ClassUtils;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.EverythingMatcher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuartzJobScheduler
implements JobScheduler,
InitializingBean {
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private ScheduleJobInstanceService scheduleJobInstanceService;
    @Autowired
    private QuartzSchedulerListener schedulerListener;
    @Autowired
    private QuartzJobListener jobListener;
    @Autowired
    private QuartzTriggerListener triggerListener;

    public void afterPropertiesSet() throws Exception {
        ListenerManager listenerManager = this.scheduler.getListenerManager();
        listenerManager.addSchedulerListener((SchedulerListener)this.schedulerListener);
        listenerManager.addJobListener((JobListener)this.jobListener, (Matcher)EverythingMatcher.allJobs());
        listenerManager.addTriggerListener((TriggerListener)this.triggerListener, (Matcher)EverythingMatcher.allTriggers());
    }

    public boolean exists(Long jobInstanceId) {
        try {
            ScheduleJobInstanceDTO jobInstanceDTO = this.scheduleJobInstanceService.get(jobInstanceId);
            JobKey jobKey = QuartzUtil.getJobKey(jobInstanceDTO);
            return this.scheduler.checkExists(jobKey);
        }
        catch (SchedulerException e) {
            Rethrower.throwAs((Throwable)e);
            return false;
        }
    }

    public void execute(Long jobInstanceId) {
        try {
            ScheduleJobInstanceDTO jobInstanceDTO = this.scheduleJobInstanceService.get(jobInstanceId);
            JobKey jobKey = QuartzUtil.getJobKey(jobInstanceDTO);
            if (this.scheduler.checkExists(jobKey)) {
                return;
            }
            JobDataMap dataMap = QuartzUtil.buildDataMap(jobInstanceDTO);
            JobDetail job = JobBuilder.newJob((Class)this.findJobHandler(jobInstanceDTO)).withIdentity(jobKey).usingJobData(dataMap).storeDurably().build();
            Trigger trigger = QuartzUtil.getTriggerOnce(jobInstanceDTO);
            this.scheduler.scheduleJob(job, trigger);
            this.updateScheduelStatus(jobInstanceId, CarpScheduleStatus.RUNNING);
        }
        catch (SchedulerException e) {
            Rethrower.throwAs((Throwable)e);
        }
    }

    public void schedule(Long jobInstanceId) {
        try {
            ScheduleJobInstanceDTO jobInstanceDTO = this.scheduleJobInstanceService.get(jobInstanceId);
            JobKey jobKey = QuartzUtil.getJobKey(jobInstanceDTO);
            if (this.scheduler.checkExists(jobKey)) {
                return;
            }
            JobDataMap dataMap = QuartzUtil.buildDataMap(jobInstanceDTO);
            JobDetail job = JobBuilder.newJob((Class)this.findJobHandler(jobInstanceDTO)).withIdentity(jobKey).usingJobData(dataMap).storeDurably().build();
            Trigger trigger = QuartzUtil.getTrigger(jobInstanceDTO);
            this.scheduler.scheduleJob(job, trigger);
            this.updateScheduelStatus(jobInstanceId, CarpScheduleStatus.RUNNING);
        }
        catch (SchedulerException e) {
            Rethrower.throwAs((Throwable)e);
        }
    }

    public void unschedule(Long jobInstanceId) {
        try {
            ScheduleJobInstanceDTO jobInstanceDTO = this.scheduleJobInstanceService.get(jobInstanceId);
            JobKey jobKey = QuartzUtil.getJobKey(jobInstanceDTO);
            if (!this.scheduler.checkExists(jobKey)) {
                return;
            }
            this.scheduler.deleteJob(jobKey);
            this.updateScheduelStatus(jobInstanceId, CarpScheduleStatus.STOP);
        }
        catch (SchedulerException e) {
            Rethrower.throwAs((Throwable)e);
        }
    }

    public void suspend(Long jobInstanceId) {
        try {
            ScheduleJobInstanceDTO jobInstanceDTO = this.scheduleJobInstanceService.get(jobInstanceId);
            JobKey jobKey = QuartzUtil.getJobKey(jobInstanceDTO);
            if (!this.scheduler.checkExists(jobKey)) {
                return;
            }
            this.scheduler.pauseJob(jobKey);
            this.updateScheduelStatus(jobInstanceId, CarpScheduleStatus.STOP);
        }
        catch (SchedulerException e) {
            Rethrower.throwAs((Throwable)e);
        }
    }

    public void resume(Long jobInstanceId) {
        try {
            ScheduleJobInstanceDTO jobInstanceDTO = this.scheduleJobInstanceService.get(jobInstanceId);
            JobKey jobKey = QuartzUtil.getJobKey(jobInstanceDTO);
            if (!this.scheduler.checkExists(jobKey)) {
                return;
            }
            this.scheduler.resumeJob(jobKey);
            this.updateScheduelStatus(jobInstanceId, CarpScheduleStatus.STOP);
        }
        catch (SchedulerException e) {
            Rethrower.throwAs((Throwable)e);
        }
    }

    private void updateScheduelStatus(Long id, CarpScheduleStatus status) {
        this.scheduleJobInstanceService.updateStatus(id, status);
    }

    private Class findJobHandler(ScheduleJobInstanceDTO jobInstanceDTO) {
        ScheduleJobConfigDTO jobConfig = jobInstanceDTO.getJobConfig();
        try {
            switch (jobConfig.getExecuteType()) {
                case NATIVE: {
                    return ClassUtils.getClass((String)jobConfig.getHandler());
                }
                case METHOD: 
                case BEAN: {
                    return QuartzJobHandler.class;
                }
            }
            throw new IllegalArgumentException("unsupported execute type: " + jobConfig.getExecuteType());
        }
        catch (Exception e) {
            Rethrower.throwAs((Throwable)e);
            return null;
        }
    }
}

