/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.response;

import cn.sliew.carp.framework.common.model.ResponseVO;
import cn.sliew.carp.framework.web.response.ApiResponseWrapper;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.springdoc.core.parsers.ReturnTypeParser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={ReturnTypeParser.class})
public class Knife4jApiResponseHandler
implements ReturnTypeParser {
    public Type getReturnType(MethodParameter methodParameter) {
        Type returnType = super.getReturnType(methodParameter);
        if (methodParameter.getMethod().getReturnType().equals(ResponseVO.class)) {
            return returnType;
        }
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)methodParameter.getContainingClass(), ApiResponseWrapper.class) || methodParameter.hasMethodAnnotation(ApiResponseWrapper.class)) {
            if (returnType == Void.TYPE || returnType == Void.class) {
                return TypeUtils.parameterize(ResponseVO.class, (Type[])new Type[]{Void.class});
            }
            return TypeUtils.parameterize(ResponseVO.class, (Type[])new Type[]{returnType});
        }
        return returnType;
    }
}

