/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.tcp.ssl;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.pki.pem.DERPrivateKeyLoader$;
import org.apache.pekko.pki.pem.PEMDecoder$;
import scala.Function0;
import scala.Serializable;
import scala.concurrent.package$;

@InternalApi
public final class PemManagersProvider$ {
    public static PemManagersProvider$ MODULE$;
    private final CertificateFactory certFactory;

    static {
        new PemManagersProvider$();
    }

    @InternalApi
    public KeyManager[] buildKeyManagers(PrivateKey privateKey, X509Certificate cert, Certificate cacert) {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        keyStore.setCertificateEntry("cert", cert);
        keyStore.setCertificateEntry("cacert", cacert);
        keyStore.setKeyEntry("private-key", privateKey, "changeit".toCharArray(), (Certificate[])((Object[])new Certificate[]{cert, cacert}));
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, "changeit".toCharArray());
        return kmf.getKeyManagers();
    }

    @InternalApi
    public TrustManager[] buildTrustManagers(Certificate cacert) {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null);
        trustStore.setCertificateEntry("cacert", cacert);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        return tmf.getTrustManagers();
    }

    @InternalApi
    public PrivateKey loadPrivateKey(String filename) {
        return (PrivateKey)package$.MODULE$.blocking((Function0 & java.io.Serializable & Serializable)() -> {
            byte[] bytes = Files.readAllBytes(new File(filename).toPath());
            String pemData = new String(bytes, StandardCharsets.UTF_8);
            return DERPrivateKeyLoader$.MODULE$.load(PEMDecoder$.MODULE$.decode(pemData));
        });
    }

    private CertificateFactory certFactory() {
        return this.certFactory;
    }

    @InternalApi
    public Certificate loadCertificate(String filename) {
        return (Certificate)package$.MODULE$.blocking((Function0 & java.io.Serializable & Serializable)() -> MODULE$.certFactory().generateCertificate(Files.newInputStream(new File(filename).toPath(), new OpenOption[0])));
    }

    private PemManagersProvider$() {
        MODULE$ = this;
        this.certFactory = CertificateFactory.getInstance("X.509");
    }
}

