/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.statemachine;

import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowInstanceEvent;
import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowInstanceState;
import cn.sliew.carp.module.workflow.api.engine.dispatch.event.WorkflowInstanceStatusEvent;
import cn.sliew.carp.module.workflow.api.engine.dispatch.publisher.WorkflowInstanceEventPublisher;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowInstance;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowInstanceEventDTO;
import com.alibaba.cola.statemachine.Action;
import com.alibaba.cola.statemachine.StateMachine;
import com.alibaba.cola.statemachine.builder.StateMachineBuilder;
import com.alibaba.cola.statemachine.builder.StateMachineBuilderFactory;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowInstanceStateMachine
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceStateMachine.class);
    public static final String CONSUMER_GROUP = "WorkflowInstanceStateMachine";
    public static final String EXECUTOR = "WorkflowInstanceExecute";
    @Autowired
    private WorkflowInstanceEventPublisher publisher;
    private StateMachine<CarpWorkflowInstanceState, CarpWorkflowInstanceEvent, Pair<Long, Throwable>> stateMachine;

    public void afterPropertiesSet() throws Exception {
        StateMachineBuilder builder = StateMachineBuilderFactory.create();
        builder.externalTransition().from((Object)CarpWorkflowInstanceState.PENDING).to((Object)CarpWorkflowInstanceState.RUNNING).on((Object)CarpWorkflowInstanceEvent.COMMAND_DEPLOY).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowInstanceState.PENDING).to((Object)CarpWorkflowInstanceState.SUCCESS).on((Object)CarpWorkflowInstanceEvent.PROCESS_SUCCESS).perform(this.doPerform());
        builder.internalTransition().within((Object)CarpWorkflowInstanceState.RUNNING).on((Object)CarpWorkflowInstanceEvent.PROCESS_TASK_CHANGE).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowInstanceState.RUNNING).to((Object)CarpWorkflowInstanceState.SUCCESS).on((Object)CarpWorkflowInstanceEvent.PROCESS_SUCCESS).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowInstanceState.RUNNING).to((Object)CarpWorkflowInstanceState.FAILURE).on((Object)CarpWorkflowInstanceEvent.PROCESS_FAILURE).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowInstanceState.RUNNING).to((Object)CarpWorkflowInstanceState.SUSPEND).on((Object)CarpWorkflowInstanceEvent.COMMAND_SUSPEND).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowInstanceState.RUNNING).to((Object)CarpWorkflowInstanceState.TERMINATED).on((Object)CarpWorkflowInstanceEvent.COMMAND_SHUTDOWN).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowInstanceState.SUSPEND).to((Object)CarpWorkflowInstanceState.RUNNING).on((Object)CarpWorkflowInstanceEvent.COMMAND_RESUME).perform(this.doPerform());
        builder.externalTransition().from((Object)CarpWorkflowInstanceState.SUSPEND).to((Object)CarpWorkflowInstanceState.TERMINATED).on((Object)CarpWorkflowInstanceEvent.COMMAND_SHUTDOWN).perform(this.doPerform());
        this.stateMachine = builder.build(CONSUMER_GROUP);
    }

    private Action<CarpWorkflowInstanceState, CarpWorkflowInstanceEvent, Pair<Long, Throwable>> doPerform() {
        return (fromState, toState, eventEnum, pair) -> {
            WorkflowInstanceEventDTO eventDTO = new WorkflowInstanceEventDTO((CarpWorkflowInstanceState)fromState, (CarpWorkflowInstanceState)toState, (CarpWorkflowInstanceEvent)eventEnum, (Long)pair.getLeft(), (Throwable)pair.getRight());
            this.publisher.publish((WorkflowInstanceStatusEvent)eventDTO);
        };
    }

    public void deploy(WorkflowInstance instance) {
        this.stateMachine.fireEvent((Object)instance.getStatus(), (Object)CarpWorkflowInstanceEvent.COMMAND_DEPLOY, (Object)Pair.of((Object)instance.getId(), null));
    }

    public void shutdown(WorkflowInstance instance) {
        this.stateMachine.fireEvent((Object)instance.getStatus(), (Object)CarpWorkflowInstanceEvent.COMMAND_SHUTDOWN, (Object)Pair.of((Object)instance.getId(), null));
    }

    public void suspend(WorkflowInstance instance) {
        this.stateMachine.fireEvent((Object)instance.getStatus(), (Object)CarpWorkflowInstanceEvent.COMMAND_SUSPEND, (Object)Pair.of((Object)instance.getId(), null));
    }

    public void resume(WorkflowInstance instance) {
        this.stateMachine.fireEvent((Object)instance.getStatus(), (Object)CarpWorkflowInstanceEvent.COMMAND_RESUME, (Object)Pair.of((Object)instance.getId(), null));
    }

    public void onTaskChange(WorkflowInstance instance) {
        this.stateMachine.fireEvent((Object)instance.getStatus(), (Object)CarpWorkflowInstanceEvent.PROCESS_TASK_CHANGE, (Object)Pair.of((Object)instance.getId(), null));
    }

    public void onSuccess(WorkflowInstance instance) {
        this.stateMachine.fireEvent((Object)instance.getStatus(), (Object)CarpWorkflowInstanceEvent.PROCESS_SUCCESS, (Object)Pair.of((Object)instance.getId(), null));
    }

    public void onFailure(WorkflowInstance instance, Throwable throwable) {
        this.stateMachine.fireEvent((Object)instance.getStatus(), (Object)CarpWorkflowInstanceEvent.PROCESS_FAILURE, (Object)Pair.of((Object)instance.getId(), (Object)throwable));
    }
}

