/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.executor.workflow;

import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowExecuteType;
import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowTaskInstanceStage;
import cn.sliew.carp.framework.dag.algorithm.DAG;
import cn.sliew.carp.framework.dag.algorithm.DagUtil;
import cn.sliew.carp.framework.dag.algorithm.DefaultDagEdge;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowInstance;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowTaskInstance;
import cn.sliew.carp.module.workflow.api.manager.WorkflowTaskInstanceManager;
import cn.sliew.carp.module.workflow.internal.executor.WorkflowInstanceExecutor;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowInstanceExecuteExecutor
implements WorkflowInstanceExecutor {
    @Autowired
    private WorkflowTaskInstanceManager workflowTaskInstanceManager;

    @Override
    public CarpWorkflowExecuteType getExecuteType() {
        return CarpWorkflowExecuteType.EXECUTE;
    }

    @Override
    public void execute(WorkflowInstance instance, DAG<WorkflowTaskInstance> dag) {
        DagUtil.execute(dag, (dag1, node) -> this.checkTask(instance, (DAG<WorkflowTaskInstance>)dag1, (WorkflowTaskInstance)node), (dag1, edge) -> this.checkEdge(instance, dag, (DefaultDagEdge<WorkflowTaskInstance>)edge), this::executeTasks);
    }

    @Override
    public boolean checkEdge(WorkflowInstance instance, DAG<WorkflowTaskInstance> dag, DefaultDagEdge<WorkflowTaskInstance> edge) {
        return ((WorkflowTaskInstance)edge.getSource()).getStatus().isSuccess();
    }

    @Override
    public boolean checkTask(WorkflowInstance instance, DAG<WorkflowTaskInstance> dag, WorkflowTaskInstance task) {
        return task.getStatus() == CarpWorkflowTaskInstanceStage.PENDING;
    }

    @Override
    public void executeTasks(Set<WorkflowTaskInstance> task) {
        task.forEach(taskInstance -> this.workflowTaskInstanceManager.deploy(taskInstance.getId()));
    }
}

