/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.task;

import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowTaskInstanceEvent;
import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowTaskInstanceStage;
import cn.sliew.carp.framework.dag.service.dto.DagStepDTO;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowTaskInstance;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowTaskInstanceEventDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.task.AbstractWorkflowTaskInstanceEventListener;
import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.springframework.stereotype.Component;

@Component
public class WorkflowTaskInstanceFailureEventListener
extends AbstractWorkflowTaskInstanceEventListener {
    public CarpWorkflowTaskInstanceEvent getType() {
        return CarpWorkflowTaskInstanceEvent.PROCESS_FAILURE;
    }

    @Override
    protected CompletableFuture handleEventAsync(WorkflowTaskInstanceEventDTO event) {
        return CompletableFuture.runAsync(new FailureRunner(event.getWorkflowTaskInstanceId(), event.getThrowable())).toCompletableFuture();
    }

    private class FailureRunner
    implements Runnable,
    Serializable {
        private Long workflowTaskInstanceId;
        private Optional<Throwable> throwable;

        public FailureRunner(Long workflowTaskInstanceId, Throwable throwable) {
            this.workflowTaskInstanceId = workflowTaskInstanceId;
            this.throwable = Optional.ofNullable(throwable);
        }

        @Override
        public void run() {
            DagStepDTO dagStepUpdateParam = new DagStepDTO();
            dagStepUpdateParam.setId(this.workflowTaskInstanceId);
            dagStepUpdateParam.setStatus(CarpWorkflowTaskInstanceStage.FAILURE.getValue());
            dagStepUpdateParam.setEndTime(new Date());
            WorkflowTaskInstanceFailureEventListener.this.dagStepService.update(dagStepUpdateParam);
            WorkflowTaskInstance taskInstance = WorkflowTaskInstanceFailureEventListener.this.workflowInstanceService.getTask(this.workflowTaskInstanceId);
            WorkflowTaskInstanceFailureEventListener.this.workflowInstanceStateMachine.onTaskChange(WorkflowTaskInstanceFailureEventListener.this.workflowInstanceService.get(taskInstance.getWorkflowInstanceId()));
        }
    }
}

