/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.task;

import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowTaskInstanceEvent;
import cn.sliew.carp.framework.dag.service.dto.DagStepDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowTaskInstanceEventDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.task.AbstractWorkflowTaskInstanceEventListener;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.springframework.stereotype.Component;

@Component
public class WorkflowTaskInstanceDeployEventListener
extends AbstractWorkflowTaskInstanceEventListener {
    public CarpWorkflowTaskInstanceEvent getType() {
        return CarpWorkflowTaskInstanceEvent.COMMAND_DEPLOY;
    }

    @Override
    protected CompletableFuture handleEventAsync(WorkflowTaskInstanceEventDTO event) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.run(event)).toCompletableFuture();
        future.whenCompleteAsync((unused, throwable) -> {
            if (throwable != null) {
                this.onFailure(event.getWorkflowTaskInstanceId(), (Throwable)throwable);
            }
        });
        return future;
    }

    private void run(WorkflowTaskInstanceEventDTO event) {
        DagStepDTO dagStepUpdateParam = new DagStepDTO();
        dagStepUpdateParam.setId(event.getWorkflowTaskInstanceId());
        dagStepUpdateParam.setStatus(event.getNextState().getValue());
        dagStepUpdateParam.setStartTime(new Date());
        this.dagStepService.update(dagStepUpdateParam);
        this.stateMachine.onSuccess(this.workflowInstanceService.getTask(event.getWorkflowTaskInstanceId()));
    }
}

