/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.engine.dispatch;

import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowTaskInstanceEvent;
import cn.sliew.carp.framework.common.serder.SerDer;
import cn.sliew.carp.framework.common.serder.jdk.JdkSerDerFactory;
import cn.sliew.carp.module.queue.api.Message;
import cn.sliew.carp.module.queue.api.MessageHandler;
import cn.sliew.carp.module.queue.api.MessageListener;
import cn.sliew.carp.module.workflow.api.engine.dispatch.WorkflowTaskInstanceEventDispatcher;
import cn.sliew.carp.module.workflow.api.engine.dispatch.event.WorkflowTaskInstanceStatusEvent;
import cn.sliew.carp.module.workflow.api.engine.dispatch.handler.WorkflowTaskInstanceEventHandler;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowTaskInstanceEventDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.CollectionUtils;

@MessageListener(topic="TOPIC_CARP_INTERNAL_WORKFLOW_TASK_INSTANCE_EVENT", consumerGroup="WorkflowInstanceStateMachine")
public class InternalWorkflowTaskInstanceEventDispatcher
implements WorkflowTaskInstanceEventDispatcher,
MessageHandler,
InitializingBean,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalWorkflowTaskInstanceEventDispatcher.class);
    public static final String TOPIC = "TOPIC_CARP_INTERNAL_WORKFLOW_TASK_INSTANCE_EVENT";
    @Autowired
    private List<WorkflowTaskInstanceEventHandler> handlers;
    private Map<CarpWorkflowTaskInstanceEvent, WorkflowTaskInstanceEventHandler> registry = new HashMap<CarpWorkflowTaskInstanceEvent, WorkflowTaskInstanceEventHandler>();
    private ThreadPoolTaskExecutor taskExecutor;

    public void afterPropertiesSet() throws Exception {
        if (!CollectionUtils.isEmpty(this.handlers)) {
            this.handlers.stream().forEach(handler -> this.registry.put(handler.getType(), (WorkflowTaskInstanceEventHandler)handler));
        }
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setMaxPoolSize(5);
        executor.setCorePoolSize(1);
        executor.setThreadNamePrefix("workflow-task-instance-thread-pool-");
        executor.initialize();
        this.taskExecutor = executor;
    }

    public void destroy() throws Exception {
        if (this.taskExecutor != null) {
            this.taskExecutor.shutdown();
        }
    }

    public void handler(Message message) throws Exception {
        SerDer serDer;
        WorkflowTaskInstanceEventDTO eventDTO;
        if (message.getBody() != null && Objects.nonNull(eventDTO = (WorkflowTaskInstanceEventDTO)(serDer = JdkSerDerFactory.INSTANCE.getInstance()).deserialize(message.getBody(), WorkflowTaskInstanceEventDTO.class))) {
            this.dispatch(eventDTO);
        }
    }

    public void dispatch(WorkflowTaskInstanceStatusEvent event) {
        if (!this.registry.containsKey(event.getEvent())) {
            throw new RuntimeException("unknown workflow task instance event: " + event.getEvent().getLabel() + "[" + event.getEvent().getValue() + "]");
        }
        WorkflowTaskInstanceEventHandler handler = this.registry.get(event.getEvent());
        CompletableFuture.runAsync(() -> handler.handle(event), (Executor)this.taskExecutor).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                log.error("workflow task instance event dispatch failed", throwable);
            }
        });
    }
}

