/*
 * Decompiled with CFR 0.152.
 */
package cn.slibs.spring.http;

import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestHelper {
    private final RestTemplate restTemplate;

    RestHelper(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public static RestHelper build(RestTemplate restTemplate) {
        return new RestHelper(restTemplate);
    }

    public <REQ, RES> RES postForEntity(String url, REQ req, HttpHeaders headers, Class<RES> resClass) {
        HttpEntity formEntity = new HttpEntity(req, (MultiValueMap)headers);
        return (RES)this.restTemplate.postForEntity(url, (Object)formEntity, resClass, new Object[0]).getBody();
    }

    public <REQ, RES> RES postForEntity(String url, REQ req, Class<RES> resClass) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/json; charset=UTF-8"));
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return this.postForEntity(url, req, headers, resClass);
    }

    public <REQ> String postForString(String url, REQ req) {
        return this.postForEntity(url, req, String.class);
    }

    public <RES> RES getForEntity(String url, HttpHeaders headers, Class<RES> resClass) {
        HttpEntity formEntity = new HttpEntity(null, (MultiValueMap)headers);
        return (RES)this.restTemplate.exchange(url, HttpMethod.GET, formEntity, resClass, new Object[0]).getBody();
    }

    public <RES> RES getForEntity(String url, Class<RES> resClass) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return this.getForEntity(url, headers, resClass);
    }

    public String getForString(String url) {
        return this.getForEntity(url, new HttpHeaders(), String.class);
    }

    public <REQ, RES> RES postForEntity(String url, REQ req, HttpHeaders headers, ParameterizedTypeReference<RES> responseType) {
        HttpEntity formEntity = new HttpEntity(req, (MultiValueMap)headers);
        return (RES)this.restTemplate.exchange(url, HttpMethod.POST, formEntity, responseType, new Object[0]).getBody();
    }

    public <REQ, RES> RES postForEntity(String url, REQ req, ParameterizedTypeReference<RES> responseType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/json; charset=UTF-8"));
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return this.postForEntity(url, req, headers, responseType);
    }

    public <RES> RES getForEntity(String url, HttpHeaders headers, ParameterizedTypeReference<RES> responseType) {
        HttpEntity formEntity = new HttpEntity(null, (MultiValueMap)headers);
        return (RES)this.restTemplate.exchange(url, HttpMethod.GET, formEntity, responseType, new Object[0]).getBody();
    }

    public <RES> RES getForEntity(String url, ParameterizedTypeReference<RES> responseType) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return this.getForEntity(url, headers, responseType);
    }

    public static <REQ, RES> RES postForEntity(RestTemplate restTemplate, String url, REQ req, HttpHeaders headers, Class<RES> resClass) {
        HttpEntity formEntity = new HttpEntity(req, (MultiValueMap)headers);
        return (RES)restTemplate.postForEntity(url, (Object)formEntity, resClass, new Object[0]).getBody();
    }

    public static <REQ, RES> RES postForEntity(RestTemplate restTemplate, String url, REQ req, Class<RES> resClass) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/json; charset=UTF-8"));
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return RestHelper.postForEntity(restTemplate, url, req, headers, resClass);
    }

    public static <REQ> String postForString(RestTemplate restTemplate, String url, REQ req) {
        return RestHelper.postForEntity(restTemplate, url, req, String.class);
    }

    public static <RES> RES getForEntity(RestTemplate restTemplate, String url, HttpHeaders headers, Class<RES> resClass) {
        HttpEntity formEntity = new HttpEntity(null, (MultiValueMap)headers);
        return (RES)restTemplate.exchange(url, HttpMethod.GET, formEntity, resClass, new Object[0]).getBody();
    }

    public static <RES> RES getForEntity(RestTemplate restTemplate, String url, Class<RES> resClass) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return RestHelper.getForEntity(restTemplate, url, headers, resClass);
    }

    public static String getForString(RestTemplate restTemplate, String url) {
        return RestHelper.getForEntity(restTemplate, url, new HttpHeaders(), String.class);
    }

    public static <REQ, RES> RES postForEntity(RestTemplate restTemplate, String url, REQ req, HttpHeaders headers, ParameterizedTypeReference<RES> responseType) {
        HttpEntity formEntity = new HttpEntity(req, (MultiValueMap)headers);
        return (RES)restTemplate.exchange(url, HttpMethod.POST, formEntity, responseType, new Object[0]).getBody();
    }

    public static <REQ, RES> RES postForEntity(RestTemplate restTemplate, String url, REQ req, ParameterizedTypeReference<RES> responseType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/json; charset=UTF-8"));
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return RestHelper.postForEntity(restTemplate, url, req, headers, responseType);
    }

    public static <RES> RES getForEntity(RestTemplate restTemplate, String url, HttpHeaders headers, ParameterizedTypeReference<RES> responseType) {
        HttpEntity formEntity = new HttpEntity(null, (MultiValueMap)headers);
        return (RES)restTemplate.exchange(url, HttpMethod.GET, formEntity, responseType, new Object[0]).getBody();
    }

    public static <RES> RES getForEntity(RestTemplate restTemplate, String url, ParameterizedTypeReference<RES> responseType) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return RestHelper.getForEntity(restTemplate, url, headers, responseType);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

