/*
 * Decompiled with CFR 0.152.
 */
package cn.slibs.spring.dao;

import com.iofairy.falcon.iterable.CollectionKit;
import com.iofairy.lambda.RT2;
import com.iofairy.tcf.Close;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;

public class MybatisHelper {
    public static int defaultBatchSize = 1000;
    private int batchSize;
    private SqlSessionTemplate sqlSessionTemplate;

    MybatisHelper() {
    }

    public static MybatisHelper build(SqlSessionTemplate sqlSessionTemplate) {
        return MybatisHelper.build(defaultBatchSize, sqlSessionTemplate);
    }

    public static MybatisHelper build(int batchSize, SqlSessionTemplate sqlSessionTemplate) {
        return new MybatisHelper().setBatchSize(batchSize).setSqlSessionTemplate(sqlSessionTemplate);
    }

    public <MAPPER, MODEL> long batchUpdate(Class<MAPPER> mapperClass, Collection<MODEL> models, int batchSize, RT2<MAPPER, MODEL, Integer, Exception> updateAction) {
        return MybatisHelper.batchUpdate(this.sqlSessionTemplate, mapperClass, models, batchSize, updateAction);
    }

    public <MAPPER, MODEL> long batchUpdate(Class<MAPPER> mapperClass, Collection<MODEL> models, RT2<MAPPER, MODEL, Integer, Exception> updateAction) {
        return MybatisHelper.batchUpdate(this.sqlSessionTemplate, mapperClass, models, this.batchSize, updateAction);
    }

    public static <MAPPER, MODEL> long batchUpdate(SqlSessionTemplate sqlSessionTemplate, Class<MAPPER> mapperClass, Collection<MODEL> models, int batchSize, RT2<MAPPER, MODEL, Integer, Exception> updateAction) {
        long sumUpdateCount = 0L;
        List modelLists = CollectionKit.divide(new ArrayList<MODEL>(models), (int)batchSize);
        for (List modelList : modelLists) {
            sumUpdateCount += MybatisHelper._batchUpdate(sqlSessionTemplate, mapperClass, modelList, updateAction);
        }
        return sumUpdateCount;
    }

    public static <MAPPER, MODEL> long batchUpdate(SqlSessionTemplate sqlSessionTemplate, Class<MAPPER> mapperClass, Collection<MODEL> models, RT2<MAPPER, MODEL, Integer, Exception> updateAction) {
        return MybatisHelper.batchUpdate(sqlSessionTemplate, mapperClass, models, defaultBatchSize, updateAction);
    }

    private static <MAPPER, MODEL> long _batchUpdate(SqlSessionTemplate sqlSessionTemplate, Class<MAPPER> mapperClass, List<MODEL> models, RT2<MAPPER, MODEL, Integer, Exception> updateAction) {
        SqlSession sqlSession = null;
        try {
            sqlSession = sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
            Object mapper = sqlSession.getMapper(mapperClass);
            for (MODEL model : models) {
                updateAction.$(mapper, model);
            }
            sqlSession.commit();
            sqlSession.clearCache();
        }
        catch (Exception e) {
            try {
                if (sqlSession != null) {
                    sqlSession.rollback();
                }
                throw new RuntimeException("[" + mapperClass.getSimpleName() + "]\u6279\u91cf\u66f4\u65b0\uff08\u6216\u63d2\u5165\uff09\u5f02\u5e38\uff01", e);
            }
            catch (Throwable throwable) {
                Close.close(sqlSession);
                throw throwable;
            }
        }
        Close.close((AutoCloseable)sqlSession);
        return models.size();
    }

    public String toString() {
        return "MybatisHelper{batchSize=" + this.batchSize + '}';
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public SqlSessionTemplate getSqlSessionTemplate() {
        return this.sqlSessionTemplate;
    }

    public MybatisHelper setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public MybatisHelper setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
        return this;
    }
}

