/*
 * Decompiled with CFR 0.152.
 */
package cn.sleepybear.cacher.cache;

import cn.sleepybear.cacher.cache.ExpireWayEnum;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class CacheObject<T>
implements Serializable {
    private static final long serialVersionUID = -935036406020467353L;
    private T obj;
    private long createTime;
    private long accessTime;
    private long updateTime;
    private Long expireTime;
    private ExpireWayEnum expireWayEnum;
    private final AtomicInteger accessCount = new AtomicInteger(0);
    private final AtomicInteger updateCount = new AtomicInteger(0);

    public CacheObject(T obj) {
        this(obj, null);
    }

    public CacheObject(T obj, Long expireTime) {
        this(obj, expireTime, ExpireWayEnum.AFTER_CREATE);
    }

    public CacheObject(T obj, Long expireTime, ExpireWayEnum expireWayEnum) {
        this.obj = obj;
        this.expireTime = expireTime;
        this.expireWayEnum = expireWayEnum;
        this.initTime(3);
    }

    private void initTime(int t) {
        long now = System.currentTimeMillis();
        switch (t) {
            case 3: {
                this.createTime = now;
            }
            case 2: {
                this.updateTime = now;
            }
            case 1: {
                this.accessTime = now;
            }
        }
    }

    private void increaseCount(int t) {
        switch (t) {
            case 2: {
                this.accessCount.incrementAndGet();
            }
            case 1: {
                this.updateCount.incrementAndGet();
            }
        }
    }

    public boolean isExpire() {
        return this.isExpire(null, true);
    }

    public boolean isExpire(ExpireWayEnum expireWayEnum, boolean keepOldExpireWay) {
        if (this.expireTime == null) {
            return false;
        }
        if (expireWayEnum == null || keepOldExpireWay) {
            expireWayEnum = this.expireWayEnum;
        }
        if (expireWayEnum == null) {
            expireWayEnum = ExpireWayEnum.AFTER_CREATE;
            this.expireWayEnum = ExpireWayEnum.AFTER_CREATE;
        }
        long l = this.expireTime;
        return l + (switch (expireWayEnum) {
            default -> throw new IncompatibleClassChangeError();
            case ExpireWayEnum.AFTER_UPDATE -> this.updateTime;
            case ExpireWayEnum.AFTER_ACCESS -> this.accessTime;
            case ExpireWayEnum.AFTER_CREATE -> this.createTime;
        }) <= System.currentTimeMillis();
    }

    public Long getExpireAt() {
        if (this.expireTime == null) {
            return null;
        }
        long l = this.expireTime;
        return l + (switch (this.expireWayEnum) {
            default -> throw new IncompatibleClassChangeError();
            case ExpireWayEnum.AFTER_CREATE -> this.createTime;
            case ExpireWayEnum.AFTER_ACCESS -> this.accessTime;
            case ExpireWayEnum.AFTER_UPDATE -> this.updateTime;
        });
    }

    public T getObj() {
        this.initTime(1);
        this.increaseCount(1);
        return this.getObjPure();
    }

    public T getObjPure() {
        return this.obj;
    }

    public CacheObject<T> getCacheObject() {
        this.initTime(1);
        this.increaseCount(1);
        return this;
    }

    public void setObj(T obj, Long expireTime, ExpireWayEnum expireWayEnum) {
        this.obj = obj;
        if (expireTime != null) {
            this.expireTime = expireTime;
        }
        if (expireWayEnum != null) {
            this.expireWayEnum = expireWayEnum;
        }
        this.initTime(2);
        this.increaseCount(2);
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public Long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Long expireTime) {
        this.expireTime = expireTime;
    }

    public ExpireWayEnum getExpireWayEnum() {
        return this.expireWayEnum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheObject that = (CacheObject)o;
        return Objects.equals(this.obj, that.obj);
    }

    public int hashCode() {
        return this.obj != null ? this.obj.hashCode() : 0;
    }
}

