/*
 * Decompiled with CFR 0.152.
 */
package cn.sleepybear.cacher;

import cn.sleepybear.cacher.CacherBuilder;
import cn.sleepybear.cacher.cache.CacheObject;
import cn.sleepybear.cacher.cache.ExpireWayEnum;
import cn.sleepybear.cacher.loader.CacherValueLoader;
import cn.sleepybear.cacher.loader.ExpireAction;
import cn.sleepybear.cacher.loader.ExpireTimeLoader;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cacher<K, V>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Cacher.class);
    private static final long serialVersionUID = -8803248750867836882L;
    private K nullKey;
    private final Map<K, CacheObject<V>> MAP;
    private ScheduledExecutorService scheduledExecutorService;
    private ExpireWayEnum expireWayEnum;
    private boolean keepOldExpireWay;
    private int corePoolSize;
    private String scheduleName;
    private long initialDelay;
    private long delay;
    private TimeUnit timeUnit;
    private boolean fixRate;
    private boolean showExpireTimeLog;
    private boolean showRemoveInfoLog;
    private boolean showLoadInfoLog;
    private CacherValueLoader<K, V> cacherValueLoader;
    private ExpireTimeLoader<K> expireTimeLoader;
    private ExpireAction<K, CacheObject<V>> expireAction;

    public Cacher(ExpireWayEnum expireWayEnum, boolean keepOldExpireWay, int corePoolSize, String scheduleName, long initialDelay, long delay, TimeUnit timeUnit, boolean fixRate, int initialCapacity, float loadFactor, K nullKey, boolean showExpireTimeLog, boolean showRemoveInfoLog, boolean showLoadInfoLog, CacherValueLoader<K, V> cacherValueLoader, ExpireTimeLoader<K> expireTimeLoader, ExpireAction<K, CacheObject<V>> expireAction) {
        this.expireWayEnum = expireWayEnum;
        this.keepOldExpireWay = keepOldExpireWay;
        this.showExpireTimeLog = showExpireTimeLog;
        this.showRemoveInfoLog = showRemoveInfoLog;
        this.showLoadInfoLog = showLoadInfoLog;
        this.cacherValueLoader = cacherValueLoader;
        this.expireTimeLoader = expireTimeLoader;
        this.expireAction = expireAction;
        this.nullKey = nullKey;
        this.MAP = new ConcurrentHashMap<K, CacheObject<V>>(initialCapacity, loadFactor);
        this.resetExpireSchedule(corePoolSize, scheduleName, initialDelay, delay, timeUnit, fixRate);
    }

    public Cacher(CacherBuilder<K, V> c) {
        this(c.expireWayEnum, c.keepOldExpireWay, c.corePoolSize, c.scheduleName, c.initialDelay, c.delay, c.timeUnit, c.fixRate, c.initialCapacity, c.loadFactor, c.nullKey, c.showExpireTimeLog, c.showRemoveInfoLog, c.showLoadInfoLog, c.cacherValueLoader, c.expireTimeLoader, c.expireAction);
    }

    public void put(K key, V value) {
        if (key == null && this.nullKey != null) {
            key = this.nullKey;
        }
        this.put(key, value, null, this.expireWayEnum);
    }

    public void put(K key, V value, Long expireTime) {
        this.put(key, value, expireTime, this.expireWayEnum);
    }

    public void put(K key, V value, Long expireTime, ExpireWayEnum expireWayEnum) {
        this.put(key, new CacheObject<V>(value, expireTime, expireWayEnum));
    }

    public void put(K key, CacheObject<V> cacheObject) {
        if (key == null) {
            this.MAP.put(this.nullKey, cacheObject);
        } else {
            this.MAP.put(key, cacheObject);
        }
    }

    public void set(K key, V value) {
        this.set(key, value, null);
    }

    public void set(K key, V value, Long expireTime) {
        this.set(key, value, expireTime, this.expireWayEnum);
    }

    public void set(K key, V value, Long expireTime, ExpireWayEnum expireWayEnum) {
        CacheObject<V> cacheObject = this.getCacheObjectPure(key);
        if (cacheObject == null) {
            this.put(key, value, expireTime, expireWayEnum);
        } else {
            cacheObject.setObj(value, expireTime, expireWayEnum);
        }
    }

    public V get(K key) {
        CacheObject<V> cacheObject = this.getCacheObject(key);
        if (cacheObject == null) {
            return null;
        }
        return cacheObject.getObjPure();
    }

    public V getIfAbsent(K key, V absentValue) {
        V v = this.get(key);
        return v == null ? absentValue : v;
    }

    public CacheObject<V> getCacheObject(K key) {
        CacheObject<V> cacheObjectPure = this.getCacheObjectPure(key);
        return cacheObjectPure == null ? null : cacheObjectPure.getCacheObject();
    }

    public CacheObject<V> getCacheObjectPure(K key) {
        CacheObject<V> load;
        boolean expire;
        CacheObject<V> cacheObject;
        if (key == null && this.nullKey != null) {
            key = this.nullKey;
        }
        if ((cacheObject = this.MAP.get(key)) != null && !(expire = cacheObject.isExpire(this.expireWayEnum, this.keepOldExpireWay))) {
            return cacheObject;
        }
        if (cacheObject != null) {
            this.removeReturnCacheObject(key, true);
            if (this.showRemoveInfoLog) {
                log.info("[{}] expire: key = {}, value = {}", new Object[]{this.scheduleName, key, cacheObject.getObjPure().toString()});
            }
        }
        if ((load = this.load(key)) == null) {
            return null;
        }
        this.put(key, load);
        return load;
    }

    public void resetExpireSchedule() {
        this.resetExpireSchedule(this.corePoolSize, this.scheduleName, this.initialDelay, this.delay, this.timeUnit, this.fixRate);
    }

    public void resetExpireSchedule(int corePoolSize, String scheduleName, long initialDelay, long delay, TimeUnit timeUnit, boolean fixRate) {
        this.corePoolSize = corePoolSize;
        this.scheduleName = scheduleName;
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.timeUnit = timeUnit;
        this.fixRate = fixRate;
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(corePoolSize, r -> new Thread(r, scheduleName));
        if (fixRate) {
            this.scheduledExecutorService.scheduleAtFixedRate(this::expire, initialDelay, delay, timeUnit);
        } else {
            this.scheduledExecutorService.scheduleWithFixedDelay(this::expire, initialDelay, delay, timeUnit);
        }
    }

    public void shutdownExpireSchedule() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }

    public void shutdownExpireScheduleNow() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
    }

    public void expire() {
        if (this.showExpireTimeLog) {
            log.info("[" + this.scheduleName + "] begin clear expired...");
        }
        for (K key : this.MAP.keySet()) {
            this.getCacheObjectPure(key);
        }
    }

    public V remove(K key) {
        return this.remove(key, false);
    }

    public V remove(K key, boolean useExpireAction) {
        CacheObject<V> cacheObject = this.removeReturnCacheObject(key, useExpireAction);
        return cacheObject == null ? null : (V)cacheObject.getObj();
    }

    public CacheObject<V> removeReturnCacheObject(K key, boolean useExpireAction) {
        CacheObject<V> removed = this.MAP.remove(key);
        if (removed != null && this.expireAction != null) {
            this.expireAction.expireAction(key, removed, useExpireAction);
        }
        return removed;
    }

    private CacheObject<V> load(K key) {
        Long expireTime;
        if (this.cacherValueLoader == null) {
            return null;
        }
        V value = this.cacherValueLoader.load(key);
        if (value == null) {
            if (this.showLoadInfoLog) {
                log.info("[{}] load no value, key = {}", (Object)this.scheduleName, key);
            }
            return null;
        }
        Long l = expireTime = this.expireTimeLoader == null ? null : this.expireTimeLoader.getLoadExpireTime(key);
        if (this.showLoadInfoLog) {
            log.info("[{}] load key = {}, expireTime = {}, value = {}", new Object[]{this.scheduleName, key, expireTime, value});
        }
        return new CacheObject<V>(value, expireTime, this.expireWayEnum);
    }

    public void printAllValues() {
        this.printAllValues(System.out::println, ",");
    }

    public void printAllValues(Consumer<String> fun, String split) {
        Set<Map.Entry<K, CacheObject<V>>> entries = this.entrySet();
        StringBuilder info = new StringBuilder();
        for (Map.Entry<K, CacheObject<V>> kv : entries) {
            CacheObject<V> cacheObject = kv.getValue();
            info.append("{key=").append(kv.getKey()).append(", value=").append(cacheObject.getObjPure());
            if (cacheObject.isExpire(this.expireWayEnum, this.keepOldExpireWay)) {
                info.append(", expire");
            }
            info.append("}").append(split);
        }
        fun.accept(info.toString());
    }

    public int size() {
        return this.MAP.size();
    }

    public void clear() {
        this.MAP.clear();
    }

    public Set<K> keySet() {
        return this.MAP.keySet();
    }

    public Set<Map.Entry<K, CacheObject<V>>> entrySet() {
        return this.MAP.entrySet();
    }

    public ExpireWayEnum getExpireWayEnum() {
        return this.expireWayEnum;
    }

    public void setExpireWayEnum(ExpireWayEnum expireWayEnum) {
        this.expireWayEnum = expireWayEnum;
    }

    public boolean isKeepOldExpireWay() {
        return this.keepOldExpireWay;
    }

    public void switchToOldExpireWay() {
        this.keepOldExpireWay = true;
    }

    public void switchToSameExpireWay() {
        this.keepOldExpireWay = false;
    }

    public K getNullKey() {
        return this.nullKey;
    }

    public void setNullKey(K nullKey) {
        this.nullKey = nullKey;
    }

    public boolean isShowExpireTimeLog() {
        return this.showExpireTimeLog;
    }

    public void setShowExpireTimeLog(boolean showExpireTimeLog) {
        this.showExpireTimeLog = showExpireTimeLog;
    }

    public boolean isShowRemoveInfoLog() {
        return this.showRemoveInfoLog;
    }

    public void setShowRemoveInfoLog(boolean showRemoveInfoLog) {
        this.showRemoveInfoLog = showRemoveInfoLog;
    }

    public boolean isShowLoadInfoLog() {
        return this.showLoadInfoLog;
    }

    public void setShowLoadInfoLog(boolean showLoadInfoLog) {
        this.showLoadInfoLog = showLoadInfoLog;
    }

    public CacherValueLoader<K, V> getCacherValueLoader() {
        return this.cacherValueLoader;
    }

    public void setCacherValueLoader(CacherValueLoader<K, V> cacherValueLoader) {
        this.cacherValueLoader = cacherValueLoader;
    }

    public ExpireTimeLoader<K> getExpireTimeLoader() {
        return this.expireTimeLoader;
    }

    public void setExpireTimeLoader(ExpireTimeLoader<K> expireTimeLoader) {
        this.expireTimeLoader = expireTimeLoader;
    }

    public void setLoader(Long loadExpireTime, CacherValueLoader<K, V> cacherValueLoader) {
        this.setLoader((K k) -> loadExpireTime, cacherValueLoader);
    }

    public void setLoader(ExpireTimeLoader<K> expireTimeLoader, CacherValueLoader<K, V> cacherValueLoader) {
        this.expireTimeLoader = expireTimeLoader;
        this.cacherValueLoader = cacherValueLoader;
    }

    public void setLoader(ExpireTimeLoader<K> expireTimeLoader, CacherValueLoader<K, V> cacherValueLoader, ExpireAction<K, CacheObject<V>> expireAction) {
        this.expireTimeLoader = expireTimeLoader;
        this.cacherValueLoader = cacherValueLoader;
        this.expireAction = expireAction;
    }

    public ExpireAction<K, CacheObject<V>> getExpireAction() {
        return this.expireAction;
    }

    public void setExpireAction(ExpireAction<K, CacheObject<V>> expireAction) {
        this.expireAction = expireAction;
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    private static String getRandomStr(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int random = (int)(Math.random() * 62.0);
            if (random < 10) {
                sb.append(random);
                continue;
            }
            if (random < 36) {
                sb.append((char)(random + 55));
                continue;
            }
            sb.append((char)(random + 61));
        }
        return sb.toString();
    }
}

