package cn.skylarkai.license;

import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.prefs.Preferences;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;

/**
 * License verify
 *
 * @author chuhl
 * @since 1.0.0
 */
public class LicenseVerify {
    private static final Logger logger = LoggerFactory.getLogger(LicenseVerify.class);

    /**
     * װLicense֤
     * @author chuhl
     * @since 1.0.0
     * @param param LicenseVerifyParam
     * @return  result  LicenseContent
     */
    public synchronized LicenseContent install(LicenseVerifyParam param){
        LicenseContent result = null;
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        //1. װ֤
        try{
            LicenseManager licenseManager = LicenseManagerHolder.getInstance(initLicenseParam(param));
            licenseManager.uninstall();

            result = licenseManager.install(new File(param.getLicensePath()));
            logger.info(MessageFormat.format("֤鰲װɹ֤Чڣ{0} - {1}",format.format(result.getNotBefore()),format.format(result.getNotAfter())));
        }catch (Exception e){
            logger.error("֤鰲װʧܣ"+ e.getMessage());
        }

        return result;
    }

    /**
     * УLicense֤
     * @author chuhl
     * @since 1.0.0
     * @return boolean
     */
    public boolean verify(){
        LicenseManager licenseManager = LicenseManagerHolder.getInstance(null);
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        //2. У֤
        try {
            LicenseContent licenseContent = licenseManager.verify();
            logger.info(MessageFormat.format("֤У֤ͨЧڣ{0} - {1}",format.format(licenseContent.getNotBefore()),format.format(licenseContent.getNotAfter())));
            return true;
        }catch (Exception e){
            logger.error("֤Уʧܣ"+ e.getMessage());
            return false;
        }
    }
    /**
     * УLicense֤
     * @author chuhl
     * @param  param  LicenseVerifyParam
     * @since 1.0.0
     * @return boolean
     */
    public boolean verify(LicenseVerifyParam param){
        LicenseManager licenseManager = LicenseManagerHolder.getInstance(initLicenseParam(param));
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        //2. У֤
        try {
            LicenseContent licenseContent = licenseManager.verify();
            if(licenseContent != null) {
                logger.info( MessageFormat.format( "֤У֤ͨЧڣ{0} - {1}", format.format( licenseContent.getNotBefore() ), format.format( licenseContent.getNotAfter() ) ) );
                return true;
            }else {
                logger.error( "֤УʧܣЧ֤飡");
                return false;
            }
        }catch (Exception e){
            logger.error( "֤Уʧܣ"+ e.getMessage());
            return false;
        }
    }
    /**
     * init license param
     * @author chuhl
     * @since 1.0.0
     * @param param LicenseУҪĲ
     * @return de.schlichtherle.license.LicenseParam
     */
    private LicenseParam initLicenseParam(LicenseVerifyParam param){
        Preferences preferences = Preferences.userNodeForPackage(LicenseVerify.class);

        CipherParam cipherParam = new DefaultCipherParam(param.getStorePass());

        KeyStoreParam publicStoreParam = new CustomKeyStoreParam(LicenseVerify.class
                ,param.getPublicKeysStorePath()
                ,param.getPublicAlias()
                ,param.getStorePass()
                ,null);

        return new DefaultLicenseParam(param.getSubject()
                ,preferences
                ,publicStoreParam
                ,cipherParam);
    }

}
