package cn.skylarkai.license;

import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;

import cn.skylarkai.license.common.LicenseCheckModel;
import de.schlichtherle.license.NoLicenseInstalledException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.xml.GenericCertificate;

/**
 * ԶLicenseManager,ӶķӲϢЧ
 *
 * @author chuhl
 * @since 1.0.0
 */
public class CustomLicenseManager extends LicenseManager{
    private static final Logger logger = LoggerFactory.getLogger(CustomLicenseManager.class);

    //XML
    private static final String XML_CHARSET = "UTF-8";
    //ĬBUFSIZE
    private static final int DEFAULT_BUFSIZE = 10 * 1024;

    public CustomLicenseManager() {

    }

    public CustomLicenseManager(LicenseParam param) {
        super(param);
    }

    /**
     * дcreate
     * @author chuhl
     * @since 1.0.0
     * @param content  content
     * @param notary  notary
     * @return byte[]
     * @throws Exception 
     */
    @Override
    protected synchronized byte[] create(
            LicenseContent content,
            LicenseNotary notary)
            throws Exception {
        initialize(content);
        this.validateCreate(content);
        final GenericCertificate certificate = notary.sign(content);
        return getPrivacyGuard().cert2key(certificate);
    }

    /**
     * дinstall
     * @author chuhl
     * @since 1.0.0
     * @param key key
     * @param notary  notary
     * @return de.schlichtherle.license.LicenseContent
     * @throws Exception 
     */
    @Override
    protected synchronized LicenseContent install(
            final byte[] key,
            final LicenseNotary notary)
            throws Exception {
        final GenericCertificate certificate = getPrivacyGuard().key2cert(key);

        notary.verify(certificate);
        final LicenseContent content = (LicenseContent)this.load(certificate.getEncoded());
        this.validate(content);
        setLicenseKey(key);
        setCertificate(certificate);

        return content;
    }

    /**
     * дverify
     * @author chuhl
     * @since 1.0.0
     * @param notary  notary
     * @return de.schlichtherle.license.LicenseContent
     * @throws Exception 
     */
    @Override
    protected synchronized LicenseContent verify(final LicenseNotary notary)
            throws Exception {

        final byte[] key = getLicenseKey();
        if (null == key){
            return null;
        }

        GenericCertificate certificate = getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        final LicenseContent content = (LicenseContent)this.load(certificate.getEncoded());
        this.validate(content);
        setCertificate(certificate);

        return content;
    }

    /**
     * У֤ĲϢ
     * @author chuhl
     * @since 1.0.0
     * @param content ֤
     * @throws LicenseContentException 
     */
    protected synchronized void validateCreate(final LicenseContent content)
            throws LicenseContentException {
        final LicenseParam param = getLicenseParam();

        final Date now = new Date();
        final Date notBefore = content.getNotBefore();
        final Date notAfter = content.getNotAfter();
        if (null != notAfter && now.after(notAfter)){
            throw new LicenseContentException("֤ʧЧʱ䲻ڵǰʱ");
        }
        if (null != notBefore && null != notAfter && notAfter.before(notBefore)){
            throw new LicenseContentException("֤Чʱ䲻֤ʧЧʱ");
        }
        final String consumerType = content.getConsumerType();
        if (null == consumerType){
            throw new LicenseContentException("ûͲΪ");
        }
    }


    /**
     * дvalidate
     * @author chuhl
     * @since 1.0.0
     * @param content LicenseContent
     * @throws LicenseContentException 
     */
    @Override
    protected synchronized void validate(final LicenseContent content)
            throws LicenseContentException {
        //1. ȵøvalidate
        super.validate(content);

        //2. ȻУԶLicense
        //LicenseпɱĲϢ
        LicenseCheckModel expectedCheckModel = (LicenseCheckModel) content.getExtra();
        //ǰʵĲϢ
        LicenseCheckModel serverCheckModel = getServerInfos();

        if(expectedCheckModel != null && serverCheckModel != null){
            //УIPַ
            if(!checkIpAddress(expectedCheckModel.getIpAddress(),serverCheckModel.getIpAddress())){
                throw new LicenseContentException("ǰIPûȨΧ");
            }

            //УMacַ
            if(!checkIpAddress(expectedCheckModel.getMacAddress(),serverCheckModel.getMacAddress())){
                throw new LicenseContentException("ǰMacûȨΧ");
            }

            //Ук
            if(!checkSerial(expectedCheckModel.getMainBoardSerial(),serverCheckModel.getMainBoardSerial())){
                throw new LicenseContentException("ǰкûȨΧ");
            }

            //УCPUк
            if(!checkSerial(expectedCheckModel.getCpuSerial(),serverCheckModel.getCpuSerial())){
                throw new LicenseContentException("ǰCPUкûȨΧ");
            }
        }else{
            throw new LicenseContentException("ȡӲϢ");
        }
    }


    /**
     * дXMLDecoderXML
     * @author chuhl
     * @since 1.0.0
     * @param encoded XMLַ
     * @return java.lang.Object
     */
    private Object load(String encoded){
        BufferedInputStream inputStream = null;
        XMLDecoder decoder = null;
        try {
            inputStream = new BufferedInputStream(new ByteArrayInputStream(encoded.getBytes(XML_CHARSET)));

            decoder = new XMLDecoder(new BufferedInputStream(inputStream, DEFAULT_BUFSIZE),null,null);

            return decoder.readObject();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } finally {
            try {
                if(decoder != null){
                    decoder.close();
                }
                if(inputStream != null){
                    inputStream.close();
                }
            } catch (Exception e) {
                logger.error("XMLDecoderXMLʧ",e);
            }
        }

        return null;
    }

    /**
     * ȡǰҪУLicense
     * @author chuhl
     * @since 1.0.0
     * @return demo.LicenseCheckModel
     */
    private LicenseCheckModel getServerInfos(){

        String osName = System.getProperty("os.name").toLowerCase();
        AbstractServerInfos abstractServerInfos = null;

        if (osName.startsWith("windows")) {
            abstractServerInfos = new WindowsServerInfos();
        } else if (osName.startsWith("linux")) {
            abstractServerInfos = new LinuxServerInfos();
        }else{
            abstractServerInfos = new LinuxServerInfos();
        }

        return abstractServerInfos.getServerInfos();
    }

    /**
     * У鵱ǰIP/MacַǷڿɱIPΧ<br/>
     * IPڿɱIP/MacַΧڣ򷵻true
     * @author chuhl
     * @param  expectedList expectedList
     * @param  serverList serverList
     * @since 1.0.0
     * @return boolean
     */
    private boolean checkIpAddress(List<String> expectedList,List<String> serverList){
        if(expectedList != null && expectedList.size() > 0){
            if(serverList != null && serverList.size() > 0){
                for(String expected : expectedList){
                    if(serverList.contains(expected.trim())){
                        return true;
                    }
                }
            }

            return false;
        }else {
            return true;
        }
    }

    /**
     * У鵱ǰӲ塢CPUȣкǷڿΧ
     * @author chuhl
     * @since 1.0.0
     * @param expectedSerial expectedSerial
     * @param serverSerial serverSerial
     * @return boolean
     */
    private boolean checkSerial(String expectedSerial,String serverSerial){
        if(StringUtils.isNotBlank(expectedSerial)){
            if(StringUtils.isNotBlank(serverSerial)){
                if(expectedSerial.equals(serverSerial)){
                    return true;
                }
            }

            return false;
        }else{
            return true;
        }
    }

}
