package cn.skylarkai.license;

import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * LicenseAdapter
 *
 * @author chuhl
 */
@Configuration
public class LicenseAdapter extends WebMvcConfigurerAdapter {

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor( new LicenseCheckInterceptor() ).addPathPatterns( "/**" ).excludePathPatterns( "/license/getServerInfos" );
        super.addInterceptors(registry);
    }
}
