package cn.skylarkai.license;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import cn.skylarkai.license.common.LicenseCheckModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get ip ,mac,cpu-no ,motherboard-no
 *
 * @author chuhl
 * @since 1.0.0
 */
public abstract class AbstractServerInfos {

    private static final Logger logger = LoggerFactory.getLogger(AbstractServerInfos.class);

    /**
     * ȡӲϢ
     * @author chuhl
     * @since 1.0.0
     * @return demo.LicenseCheckModel
     */
    public LicenseCheckModel getServerInfos(){
        LicenseCheckModel result = new LicenseCheckModel();

        try {
            result.setIpAddress(this.getIpAddress());
            result.setMacAddress(this.getMacAddress());
            result.setCpuSerial(this.getCPUSerial());
            result.setMainBoardSerial(this.getMainBoardSerial());
        }catch (Exception e){
            logger.error("get infomation fail!",e);
        }

        return result;
    }

    /**
     * ȡIPַ
     * @author chuhl
     * @since 1.0.0
     * @return java.util.List
     * @throws Exception 
     */
    protected abstract List<String> getIpAddress() throws Exception;

    /**
     * ȡMacַ
     * @author chuhl
     * @since 1.0.0
     * @return java.util.List
     * @throws Exception 
     */
    protected abstract List<String> getMacAddress() throws Exception;

    /**
     * ȡCPUк
     * @author chuhl
     * @since 1.0.0
     * @return java.lang.String
     * @throws Exception 
     */
    protected abstract String getCPUSerial() throws Exception;

    /**
     * ȡк
     * @author chuhl
     * @since 1.0.0
     * @return java.lang.String
     * @throws Exception 
     */
    protected abstract String getMainBoardSerial() throws Exception;

    /**
     * ȡǰзInetAddress
     * @author chuhl
     * @since 1.0.0
     * @return java.util.List
     * @throws Exception 
     */
    protected List<InetAddress> getLocalAllInetAddress() throws Exception {
        List<InetAddress> result = new ArrayList<>(4);

        for (Enumeration networkInterfaces = NetworkInterface.getNetworkInterfaces(); networkInterfaces.hasMoreElements(); ) {
            NetworkInterface iface = (NetworkInterface) networkInterfaces.nextElement();

            for (Enumeration inetAddresses = iface.getInetAddresses(); inetAddresses.hasMoreElements(); ) {
                InetAddress inetAddr = (InetAddress) inetAddresses.nextElement();

                if(!inetAddr.isLoopbackAddress()
                        && !inetAddr.isLinkLocalAddress() && !inetAddr.isMulticastAddress()){
                    result.add(inetAddr);
                }
            }
        }

        return result;
    }

    /**
     * ȡĳӿڵMacַ
     * @author chuhl
     * @since 1.0.0
     * @param inetAddr inetAddr
     * @return void
     */
    protected String getMacByInetAddress(InetAddress inetAddr){
        try {
            byte[] mac = NetworkInterface.getByInetAddress(inetAddr).getHardwareAddress();
            StringBuffer stringBuffer = new StringBuffer();

            for(int i=0;i<mac.length;i++){
                if(i != 0) {
                    stringBuffer.append("-");
                }

                //ʮbyteתΪַ
                String temp = Integer.toHexString(mac[i] & 0xff);
                if(temp.length() == 1){
                    stringBuffer.append("0" + temp);
                }else{
                    stringBuffer.append(temp);
                }
            }

            return stringBuffer.toString().toUpperCase();
        } catch (SocketException e) {
            e.printStackTrace();
        }

        return null;
    }

}
