package cn.skylarkai.license;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import sun.misc.BASE64Decoder;

/**
 * LicenseFilter
 *
 * @author chuhl
 */
@Component
public class LicenseFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {

        LicenseVerify licenseVerify = new LicenseVerify();
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String requestURI =request.getRequestURI();
        if(!requestURI.contains( "/license/getServerInfos" )) {
            LicenseVerifyParam param = new LicenseVerifyParam();
            param.setSubject( new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_SUBJECT )));
            param.setLicensePath( new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_PATH )) );
            param.setPublicAlias( new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_PUBLIC_ALIAS ))  );
            param.setPublicKeysStorePath( new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_PUBLIC_KEY_STORE_PATH )));
            param.setStorePass( new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_STORE_PASS )) );
            //У֤ǷЧ
            boolean verifyResult = licenseVerify.verify( param );

            if (verifyResult) {
                filterChain.doFilter( servletRequest, servletResponse );
            } else {
                response.setCharacterEncoding( "utf-8" );
                Map<String, String> result = new HashMap<>( 1 );
                result.put( "result", "֤Ч˲ǷȡȨ֤飡" );
                response.getWriter().write( JSON.toJSONString( result ) );
            }
        }else{
            filterChain.doFilter( servletRequest, servletResponse );
        }
    }

    @Override
    public void destroy() {

    }
}
