package cn.skylarkai.license;

import java.io.File;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import de.schlichtherle.license.LicenseContent;
import sun.misc.BASE64Decoder;

/**
 * LicenseConfig
 *
 * @author chuhl
 */
@Component
@Order(value = Ordered.HIGHEST_PRECEDENCE)
public class LicenseConfig implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseConfig.class);
    @Override
    public void run(String... args) throws Exception {

        if (StringUtils.isNotBlank( new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_PATH ))) ) {
            LOGGER.info( "++++++++ ʼװ֤ ++++++++" );
            LicenseVerifyParam param = new LicenseVerifyParam();
            param.setSubject( new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_SUBJECT )) );
            param.setPublicAlias( new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_PUBLIC_ALIAS )) );
            param.setStorePass(new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_STORE_PASS )) );
            File file = new File(new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_PATH )) );
            if(file.exists()) {
                param.setLicensePath(new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_PATH )));
                File storeFile = new File(new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_PUBLIC_KEY_STORE_PATH )));
                if(storeFile.exists()) {
                    param.setPublicKeysStorePath(new String((new BASE64Decoder()).decodeBuffer(LicenseConstants.LICENSE_PUBLIC_KEY_STORE_PATH )) );
                    LicenseVerify licenseVerify = new LicenseVerify();
                    //װ֤
                    LicenseContent result = licenseVerify.install( param );
                    if (result != null) {
                        LOGGER.info( "++++++++ ֤鰲װ ++++++++" );
                    }
                }else{
                    LOGGER.info( "++++++++ Կļ ++++++++" );
                }
            }else{
                LOGGER.info( "++++++++ ֤ļ ++++++++" );
            }
        }else{
            LOGGER.info( "++++++++ ֤ô ++++++++" );
        }
    }
}
