/*
 * Decompiled with CFR 0.152.
 */
package cn.skylarkai.erqicos;

import cn.skylarkai.erqicos.common.ErqiClientConfig;
import cn.skylarkai.erqicos.common.ErqiDelFileRequest;
import cn.skylarkai.erqicos.common.ErqiGetFileInputStreamRequest;
import cn.skylarkai.erqicos.common.ErqiListFolderRequest;
import cn.skylarkai.erqicos.common.ErqiMoveFileRequest;
import cn.skylarkai.erqicos.common.ErqiStatFileRequest;
import cn.skylarkai.erqicos.common.ErqiUploadFileRequest;
import cn.skylarkai.erqicos.common.ReturnMap;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PutObjectResult;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.meta.OverWrite;
import com.qcloud.cos.request.DelFileRequest;
import com.qcloud.cos.request.GetFileInputStreamRequest;
import com.qcloud.cos.request.ListFolderRequest;
import com.qcloud.cos.request.MoveFileRequest;
import com.qcloud.cos.request.StatFileRequest;
import com.qcloud.cos.request.UploadFileRequest;
import com.qcloud.cos.sign.Credentials;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.Result;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class ErqiClient {
    private ErqiClientConfig erqiClientConfig;
    private COSClient cosClient;
    private OSSClient ossClient;
    private MinioClient minioClient;

    public ErqiClient(ErqiClientConfig erqiClientConfig) {
        this.erqiClientConfig = erqiClientConfig;
        switch (erqiClientConfig.getCosType()) {
            case 1: {
                break;
            }
            case 2: {
                this.ossClient = new OSSClient(erqiClientConfig.getEndpoint(), erqiClientConfig.getAccessKey(), erqiClientConfig.getSecretKey());
                break;
            }
            case 3: {
                Credentials credentials = new Credentials(erqiClientConfig.getAppid(), erqiClientConfig.getAccessKey(), erqiClientConfig.getSecretKey());
                ClientConfig clientConfig = new ClientConfig();
                clientConfig.setRegion(erqiClientConfig.getRegion());
                this.cosClient = new COSClient(clientConfig, credentials);
                break;
            }
            default: {
                try {
                    this.minioClient = new MinioClient(erqiClientConfig.getEndpoint(), erqiClientConfig.getAccessKey(), erqiClientConfig.getSecretKey(), erqiClientConfig.getRegion());
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean checkBucket(String bucketName) {
        switch (this.erqiClientConfig.getCosType()) {
            case 1: {
                return false;
            }
            case 2: {
                return this.ossClient.doesBucketExist(bucketName);
            }
            case 3: {
                return true;
            }
        }
        boolean ret = false;
        try {
            ret = this.minioClient.bucketExists(bucketName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public boolean makeBucket(String bucketName) {
        switch (this.erqiClientConfig.getCosType()) {
            case 1: {
                return true;
            }
            case 2: {
                Bucket bucket = this.ossClient.createBucket(bucketName);
                return bucket != null;
            }
            case 3: {
                return true;
            }
        }
        try {
            this.minioClient.makeBucket(bucketName);
            StringBuilder builder = new StringBuilder();
            builder.append("{\n");
            builder.append("    \"Statement\": [\n");
            builder.append("        {\n");
            builder.append("            \"Action\": [\n");
            builder.append("                \"s3:GetBucketLocation\",\n");
            builder.append("                \"s3:ListBucket\",\n");
            builder.append("                \"s3:ListBucketMultipartUploads\"\n");
            builder.append("            ],\n");
            builder.append("            \"Effect\": \"Allow\",\n");
            builder.append("            \"Principal\": \"*\",\n");
            builder.append("            \"Resource\": \"arn:aws:s3:::" + bucketName + "\"\n");
            builder.append("        },\n");
            builder.append("        {\n");
            builder.append("            \"Action\": [\n");
            builder.append("                \"s3:AbortMultipartUpload\",\n");
            builder.append("                \"s3:DeleteObject\",\n");
            builder.append("                \"s3:ListMultipartUploadParts\",\n");
            builder.append("                \"s3:PutObject\",\n");
            builder.append("                \"s3:GetObject\"\n");
            builder.append("            ],\n");
            builder.append("            \"Effect\": \"Allow\",\n");
            builder.append("            \"Principal\": \"*\",\n");
            builder.append("            \"Resource\": \"arn:aws:s3:::" + bucketName + "/*\"\n");
            builder.append("        }\n");
            builder.append("    ],\n");
            builder.append("    \"Version\": \"2012-10-17\"\n");
            builder.append("}\n");
            this.minioClient.setBucketPolicy(bucketName, builder.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String uploadFile(ErqiUploadFileRequest erqiUploadFileRequest) {
        ReturnMap returnMap = new ReturnMap();
        switch (this.erqiClientConfig.getCosType()) {
            case 1: {
                break;
            }
            case 2: {
                PutObjectResult result;
                if (erqiUploadFileRequest.getLocalPath() == null) {
                    ByteArrayOutputStream bas = new ByteArrayOutputStream();
                    try {
                        bas.write(erqiUploadFileRequest.getContentBufer());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(bas.toByteArray());
                    result = this.ossClient.putObject(erqiUploadFileRequest.getBucketName(), erqiUploadFileRequest.getCosPath(), (InputStream)inputStream);
                } else {
                    result = this.ossClient.putObject(erqiUploadFileRequest.getBucketName(), erqiUploadFileRequest.getCosPath(), new File(erqiUploadFileRequest.getLocalPath()));
                }
                if (result.getETag() != null) {
                    OSSObject ossObject = this.ossClient.getObject(erqiUploadFileRequest.getBucketName(), erqiUploadFileRequest.getCosPath());
                    ResponseMessage responseMessage = ossObject.getResponse();
                    if (responseMessage.isSuccessful()) {
                        returnMap.setFlg(0);
                        returnMap.setMessage("SUCCESS");
                        HashMap<String, String> mapdata = new HashMap<String, String>();
                        mapdata.put("source_url", responseMessage.getUri());
                        returnMap.setData(JSON.toJSONString(mapdata));
                        break;
                    }
                    returnMap.setFlg(1);
                    returnMap.setMessage("FAILURE");
                    break;
                }
                returnMap.setFlg(1);
                returnMap.setMessage("FAILURE");
                break;
            }
            case 3: {
                UploadFileRequest request = erqiUploadFileRequest.getLocalPath() == null ? new UploadFileRequest(erqiUploadFileRequest.getBucketName(), erqiUploadFileRequest.getCosPath(), erqiUploadFileRequest.getContentBufer()) : new UploadFileRequest(erqiUploadFileRequest.getBucketName(), erqiUploadFileRequest.getCosPath(), erqiUploadFileRequest.getLocalPath());
                String uploadFileRet = this.cosClient.uploadFile(request);
                JSONObject jsonObject = JSON.parseObject((String)uploadFileRet);
                if (jsonObject.get((Object)"code").toString().equals("0")) {
                    returnMap.setFlg(0);
                    returnMap.setMessage(jsonObject.getString("message"));
                    JSONObject data = JSONObject.parseObject((String)jsonObject.getString("data"));
                    HashMap<String, String> mapdata = new HashMap<String, String>();
                    mapdata.put("source_url", data.getString("source_url"));
                    returnMap.setData(JSON.toJSONString(mapdata));
                    break;
                }
                returnMap.setFlg(1);
                returnMap.setMessage(jsonObject.getString("message"));
                break;
            }
            default: {
                try {
                    if (erqiUploadFileRequest.getLocalPath() == null) {
                        ByteArrayOutputStream bas = new ByteArrayOutputStream();
                        try {
                            bas.write(erqiUploadFileRequest.getContentBufer());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(bas.toByteArray());
                        this.minioClient.putObject(erqiUploadFileRequest.getBucketName(), erqiUploadFileRequest.getCosPath(), (InputStream)inputStream, "application/octet-stream");
                    } else {
                        this.minioClient.putObject(erqiUploadFileRequest.getBucketName(), erqiUploadFileRequest.getCosPath(), erqiUploadFileRequest.getLocalPath(), "application/octet-stream");
                    }
                    String url = this.minioClient.getObjectUrl(erqiUploadFileRequest.getBucketName(), erqiUploadFileRequest.getCosPath());
                    if (url != null) {
                        returnMap.setFlg(0);
                        returnMap.setMessage("SUCCESS");
                        HashMap<String, String> mapdata = new HashMap<String, String>();
                        mapdata.put("source_url", url);
                        returnMap.setData(JSON.toJSONString(mapdata));
                        break;
                    }
                    returnMap.setFlg(1);
                    returnMap.setMessage("FAILURE");
                    break;
                }
                catch (Exception e) {
                    returnMap.setFlg(1);
                    returnMap.setMessage("FAILURE");
                }
            }
        }
        return returnMap.ReturnMap();
    }

    public String delFile(ErqiDelFileRequest erqiDelFileRequest) {
        ReturnMap returnMap = new ReturnMap();
        switch (this.erqiClientConfig.getCosType()) {
            case 1: {
                break;
            }
            case 2: {
                DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(erqiDelFileRequest.getBucketName());
                deleteObjectsRequest.setKey(erqiDelFileRequest.getCosPath());
                DeleteObjectsResult deleteObjectsResult = this.ossClient.deleteObjects(deleteObjectsRequest);
                ResponseMessage responseMessage = deleteObjectsResult.getResponse();
                if (responseMessage.isSuccessful()) {
                    returnMap.setFlg(0);
                    returnMap.setMessage("SUCCESS");
                    break;
                }
                returnMap.setFlg(1);
                returnMap.setMessage("FAILURE");
                break;
            }
            case 3: {
                DelFileRequest cosDelFileRequest = new DelFileRequest(erqiDelFileRequest.getBucketName(), erqiDelFileRequest.getCosPath());
                String retStr = this.cosClient.delFile(cosDelFileRequest);
                JSONObject jsonObject = JSON.parseObject((String)retStr);
                if (jsonObject.get((Object)"code").toString().equals("0")) {
                    returnMap.setFlg(0);
                    returnMap.setMessage(jsonObject.getString("message"));
                    break;
                }
                returnMap.setFlg(1);
                returnMap.setMessage(jsonObject.getString("message"));
                break;
            }
            default: {
                try {
                    this.minioClient.removeObject(erqiDelFileRequest.getBucketName(), erqiDelFileRequest.getCosPath());
                    returnMap.setFlg(0);
                    returnMap.setMessage("SUCCESS");
                    break;
                }
                catch (Exception ex) {
                    returnMap.setFlg(1);
                    returnMap.setMessage("FAILURE");
                }
            }
        }
        return returnMap.ReturnMap();
    }

    public String moveFile(ErqiMoveFileRequest erqiMoveFileRequest) {
        ReturnMap returnMap = new ReturnMap();
        switch (this.erqiClientConfig.getCosType()) {
            case 1: {
                break;
            }
            case 2: {
                CopyObjectRequest copyObjectRequest = new CopyObjectRequest(erqiMoveFileRequest.getBucketName(), erqiMoveFileRequest.getCosPath(), erqiMoveFileRequest.getBucketName(), erqiMoveFileRequest.getDstCosPath());
                CopyObjectResult copyObjectResult = this.ossClient.copyObject(copyObjectRequest);
                ResponseMessage responseMessageq = copyObjectResult.getResponse();
                if (responseMessageq.isSuccessful()) {
                    DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(erqiMoveFileRequest.getBucketName());
                    deleteObjectsRequest.setKey(erqiMoveFileRequest.getCosPath());
                    DeleteObjectsResult deleteObjectsResult = this.ossClient.deleteObjects(deleteObjectsRequest);
                    ResponseMessage responseMessageM = deleteObjectsResult.getResponse();
                    if (responseMessageM.isSuccessful()) {
                        returnMap.setFlg(0);
                        returnMap.setMessage("SUCCESS");
                        break;
                    }
                    returnMap.setFlg(1);
                    returnMap.setMessage("FAILURE");
                    break;
                }
                returnMap.setFlg(1);
                returnMap.setMessage("FAILURE");
                break;
            }
            case 3: {
                MoveFileRequest cosMoveFileRequest = new MoveFileRequest(erqiMoveFileRequest.getBucketName(), erqiMoveFileRequest.getCosPath(), erqiMoveFileRequest.getDstCosPath());
                cosMoveFileRequest.setOverWrite(OverWrite.OVER_WRITE);
                String moveRetStr = this.cosClient.moveFile(cosMoveFileRequest);
                JSONObject jsonObject = JSON.parseObject((String)moveRetStr);
                if (jsonObject.get((Object)"code").toString().equals("0")) {
                    returnMap.setFlg(0);
                    returnMap.setMessage(jsonObject.getString("message"));
                    break;
                }
                returnMap.setFlg(1);
                returnMap.setMessage(jsonObject.getString("message"));
                break;
            }
            default: {
                try {
                    this.minioClient.copyObject(erqiMoveFileRequest.getBucketName(), erqiMoveFileRequest.getCosPath(), erqiMoveFileRequest.getBucketName(), erqiMoveFileRequest.getDstCosPath());
                    ErqiDelFileRequest erqiDelFileRequest = new ErqiDelFileRequest(erqiMoveFileRequest.getBucketName(), erqiMoveFileRequest.getCosPath());
                    String moveDelRetStr = this.delFile(erqiDelFileRequest);
                    JSONObject jsonObjectRet = JSON.parseObject((String)moveDelRetStr);
                    if (jsonObjectRet.get((Object)"code").toString().equals("0")) {
                        returnMap.setFlg(0);
                        returnMap.setMessage("SUCCESS");
                        break;
                    }
                    returnMap.setFlg(1);
                    returnMap.setMessage("FAILURE");
                    break;
                }
                catch (Exception ex) {
                    returnMap.setFlg(1);
                    returnMap.setMessage("FAILURE");
                }
            }
        }
        return returnMap.ReturnMap();
    }

    public String statFile(ErqiStatFileRequest erqiStatFileRequest) {
        ReturnMap returnMap = new ReturnMap();
        switch (this.erqiClientConfig.getCosType()) {
            case 1: {
                break;
            }
            case 2: {
                OSSObject ossObject = this.ossClient.getObject(erqiStatFileRequest.getBucketName(), erqiStatFileRequest.getCosPath());
                if (ossObject.getResponse().isSuccessful()) {
                    returnMap.setFlg(0);
                    returnMap.setMessage("SUCCESS");
                    HashMap<String, String> mapdata = new HashMap<String, String>();
                    mapdata.put("source_url", ossObject.getResponse().getUri());
                    returnMap.setData(JSON.toJSONString(mapdata));
                    break;
                }
                returnMap.setFlg(1);
                returnMap.setMessage("FAILURE");
                break;
            }
            case 3: {
                StatFileRequest cosStatFileRequest = new StatFileRequest(erqiStatFileRequest.getBucketName(), erqiStatFileRequest.getCosPath());
                String statFileRestStr = this.cosClient.statFile(cosStatFileRequest);
                JSONObject jsonObjectStatRet = JSON.parseObject((String)statFileRestStr);
                if (jsonObjectStatRet.get((Object)"code").toString().equals("0")) {
                    returnMap.setFlg(0);
                    returnMap.setMessage("SUCCESS");
                    JSONObject data = JSONObject.parseObject((String)jsonObjectStatRet.getString("data"));
                    HashMap<String, String> mapdata = new HashMap<String, String>();
                    mapdata.put("source_url", data.getString("source_url"));
                    returnMap.setData(JSON.toJSONString(mapdata));
                    break;
                }
                returnMap.setFlg(1);
                returnMap.setMessage("FAILURE");
                break;
            }
            default: {
                try {
                    ObjectStat objectStat = this.minioClient.statObject(erqiStatFileRequest.getBucketName(), erqiStatFileRequest.getCosPath());
                    if (objectStat.etag() != null) {
                        String url = this.minioClient.getObjectUrl(erqiStatFileRequest.getBucketName(), erqiStatFileRequest.getCosPath());
                        returnMap.setFlg(0);
                        returnMap.setMessage("SUCCESS");
                        HashMap<String, String> mapdata = new HashMap<String, String>();
                        mapdata.put("source_url", url);
                        returnMap.setData(JSON.toJSONString(mapdata));
                        break;
                    }
                    returnMap.setFlg(1);
                    returnMap.setMessage("FAILURE");
                    break;
                }
                catch (Exception ex) {
                    returnMap.setFlg(1);
                    returnMap.setMessage("FAILURE");
                }
            }
        }
        return returnMap.ReturnMap();
    }

    public InputStream getFileInputStream(ErqiGetFileInputStreamRequest erqiGetFileInputStreamRequest) {
        switch (this.erqiClientConfig.getCosType()) {
            case 1: {
                break;
            }
            case 2: {
                OSSObject ossObject = this.ossClient.getObject(erqiGetFileInputStreamRequest.getBucketName(), erqiGetFileInputStreamRequest.getCosPath());
                return ossObject.getObjectContent();
            }
            case 3: {
                GetFileInputStreamRequest cosGetFileInputStreamRequest = new GetFileInputStreamRequest(erqiGetFileInputStreamRequest.getBucketName(), erqiGetFileInputStreamRequest.getCosPath());
                try {
                    cosGetFileInputStreamRequest.setUseCDN(false);
                    return this.cosClient.getFileInputStream(cosGetFileInputStreamRequest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            default: {
                try {
                    return this.minioClient.getObject(erqiGetFileInputStreamRequest.getBucketName(), erqiGetFileInputStreamRequest.getCosPath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public String listFolder(ErqiListFolderRequest erqiListFolderRequest) {
        ReturnMap returnMap = new ReturnMap();
        switch (this.erqiClientConfig.getCosType()) {
            case 1: {
                break;
            }
            case 2: {
                ObjectListing objectListing = this.ossClient.listObjects(erqiListFolderRequest.getBucketName(), erqiListFolderRequest.getCosPath());
                List ossObjectSummaries = objectListing.getObjectSummaries();
                if (ossObjectSummaries.size() > 0) {
                    returnMap.setFlg(0);
                    returnMap.setMessage("SUCCESS");
                    JSONArray jsonArray = new JSONArray();
                    for (OSSObjectSummary ossObjectSummary : ossObjectSummaries) {
                        HashMap<String, Object> tmpMap = new HashMap<String, Object>();
                        tmpMap.put("source_url", this.ossClient.getEndpoint() + "/" + ossObjectSummary.getKey());
                        tmpMap.put("name", ossObjectSummary.getKey().substring(ossObjectSummary.getKey().lastIndexOf("/") + 1));
                        tmpMap.put("filesize", ossObjectSummary.getSize());
                        tmpMap.put("mtime", ossObjectSummary.getLastModified());
                        jsonArray.add(tmpMap);
                    }
                    HashMap<String, JSONArray> mapdata = new HashMap<String, JSONArray>();
                    mapdata.put("infos", jsonArray);
                    returnMap.setData(JSON.toJSONString(mapdata));
                    break;
                }
                returnMap.setFlg(1);
                returnMap.setMessage("FAILURE");
                break;
            }
            case 3: {
                ListFolderRequest cosListFolderRequest = new ListFolderRequest(erqiListFolderRequest.getBucketName(), "/" + erqiListFolderRequest.getCosPath());
                String listFolderRetStr = this.cosClient.listFolder(cosListFolderRequest);
                JSONObject jsonObjectStatRet = JSON.parseObject((String)listFolderRetStr);
                if (jsonObjectStatRet.get((Object)"code").toString().equals("0")) {
                    returnMap.setFlg(0);
                    returnMap.setMessage("SUCCESS");
                    returnMap.setData(jsonObjectStatRet.getString("data"));
                    break;
                }
                returnMap.setFlg(1);
                returnMap.setMessage("FAILURE");
                break;
            }
            default: {
                try {
                    Iterable resultIterable = this.minioClient.listObjects(erqiListFolderRequest.getBucketName(), erqiListFolderRequest.getCosPath());
                    if (resultIterable.iterator().hasNext()) {
                        returnMap.setFlg(0);
                        returnMap.setMessage("SUCCESS");
                        JSONArray jsonArray = new JSONArray();
                        for (Result result : resultIterable) {
                            String url = this.minioClient.getObjectUrl(erqiListFolderRequest.getBucketName(), ((Item)result.get()).objectName());
                            HashMap<String, Object> tmpMap = new HashMap<String, Object>();
                            tmpMap.put("source_url", url);
                            tmpMap.put("name", ((Item)result.get()).objectName().substring(((Item)result.get()).objectName().lastIndexOf("/") + 1));
                            tmpMap.put("filesize", ((Item)result.get()).objectSize());
                            tmpMap.put("mtime", ((Item)result.get()).lastModified().getTime());
                            jsonArray.add(tmpMap);
                        }
                        HashMap<String, JSONArray> mapdata = new HashMap<String, JSONArray>();
                        mapdata.put("infos", jsonArray);
                        returnMap.setData(JSON.toJSONString(mapdata));
                        break;
                    }
                    returnMap.setFlg(1);
                    returnMap.setMessage("FAILURE");
                    break;
                }
                catch (Exception e) {
                    returnMap.setFlg(1);
                    returnMap.setMessage("FAILURE");
                }
            }
        }
        return returnMap.ReturnMap();
    }

    public void shutdown() {
        switch (this.erqiClientConfig.getCosType()) {
            case 1: {
                break;
            }
            case 2: {
                this.ossClient.shutdown();
                break;
            }
            case 3: {
                this.cosClient.shutdown();
                break;
            }
        }
    }
}

