/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.config;

import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SwaggerConfig {
    public static final Info INFO = new Info().title("GB28181 Docking Platform API").description("Matrix API description").version("2.0");
    private static final License LICENSE = new License().name("Apache 2.0").url("http://www.apache.org/licenses/LICENSE-2.0.html");

    public static GroupedOpenApi api(String group, String path) {
        return GroupedOpenApi.builder().group(group).pathsToMatch(new String[]{path + "/**"}).addOpenApiCustomizer(openApi -> openApi.info(INFO)).addOpenApiCustomizer(SwaggerConfig.authOpenApiDocs()).build();
    }

    private static OpenApiCustomizer authOpenApiDocs() {
        return openApi -> {
            openApi.addSecurityItem(new SecurityRequirement().addList("token"));
            openApi.getComponents().addSecuritySchemes("token", new SecurityScheme().type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER).name("token"));
        };
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwaggerConfig)) {
            return false;
        }
        SwaggerConfig other = (SwaggerConfig)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SwaggerConfig;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "SwaggerConfig()";
    }

    static {
        INFO.license(LICENSE);
    }
}

