/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.api.play;

import cn.skcks.docking.gb28181.annotation.web.JsonMapping;
import cn.skcks.docking.gb28181.annotation.web.methods.GetJson;
import cn.skcks.docking.gb28181.api.play.dto.RealTimePlayDTO;
import cn.skcks.docking.gb28181.api.play.dto.RealTimeStopDTO;
import cn.skcks.docking.gb28181.api.play.dto.RecordPlayDTO;
import cn.skcks.docking.gb28181.api.play.dto.RecordStopDTO;
import cn.skcks.docking.gb28181.common.json.JsonResponse;
import cn.skcks.docking.gb28181.config.SwaggerConfig;
import cn.skcks.docking.gb28181.service.play.PlayService;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springdoc.core.annotations.ParameterObject;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.context.annotation.Bean;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="\u64ad\u653e")
@RestController
@JsonMapping(value={"/api/device/play"})
public class PlayController {
    private final PlayService playService;

    @Bean
    public GroupedOpenApi playApi() {
        return SwaggerConfig.api("Play", "/api/device/play");
    }

    @GetJson(value={"/realTimePlay"})
    public DeferredResult<JsonResponse<String>> realTimePlay(@ParameterObject @Validated RealTimePlayDTO dto) {
        return this.playService.realTimePlay(dto.getDeviceId(), dto.getChannelId(), dto.getTimeout());
    }

    @GetJson(value={"/realtimeStop"})
    public JsonResponse<Void> realTimeStop(@ParameterObject @Validated RealTimeStopDTO dto) {
        return this.playService.realTimeStop(dto.getDeviceId(), dto.getChannelId());
    }

    @GetJson(value={"/recordPlay"})
    public DeferredResult<JsonResponse<String>> recordPlay(@ParameterObject @Validated RecordPlayDTO dto) {
        return this.playService.recordPlay(dto.getDeviceId(), dto.getChannelId(), dto.getStartTime(), dto.getEndTime(), dto.getTimeout());
    }

    @GetJson(value={"/recordStop"})
    public JsonResponse<Void> recordStop(@ParameterObject @Validated RecordStopDTO dto) {
        return this.playService.recordStop(dto.getDeviceId(), dto.getChannelId(), dto.getStartTime(), dto.getEndTime());
    }

    public PlayController(PlayService playService) {
        this.playService = playService;
    }
}

