/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.advice;

import cn.skcks.docking.gb28181.common.json.JsonResponse;
import jakarta.validation.ConstraintViolationException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;

@RestControllerAdvice
public class ExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAdvice.class);

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public JsonResponse<String> missingServletRequestParameterException(MissingServletRequestParameterException e) {
        return JsonResponse.error((String)e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public JsonResponse<String> httpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        return JsonResponse.error((String)e.getMessage());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public JsonResponse<String> unsupportedMediaTypeException(Exception e) {
        e.printStackTrace();
        return JsonResponse.error((String)e.getMessage());
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public JsonResponse<String> httpMediaTypeNotAcceptableException(HttpMediaTypeNotAcceptableException e) {
        return JsonResponse.error((String)e.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public JsonResponse<String> runtimeException(RuntimeException e) {
        e.printStackTrace();
        return JsonResponse.error((String)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public JsonResponse<String> handleValidationBindException(BindException e) {
        return JsonResponse.error((String)Objects.requireNonNull(e.getBindingResult().getFieldError()).getDefaultMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public JsonResponse<String> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        return JsonResponse.error((String)Objects.requireNonNull(e.getBindingResult().getFieldError()).getDefaultMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public JsonResponse<String> handleConstraintViolationException(ConstraintViolationException e) {
        return JsonResponse.error((String)Objects.requireNonNull(e.getMessage()));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public JsonResponse<String> handleHttpMessageNotReadableException(HttpMessageNotReadableException e) {
        log.warn("{}", (Object)e.getMessage());
        return JsonResponse.error((String)"\u53c2\u6570\u5f02\u5e38");
    }

    @ExceptionHandler(value={AsyncRequestTimeoutException.class})
    public JsonResponse<String> exception(AsyncRequestTimeoutException e) {
        e.printStackTrace();
        return JsonResponse.error((String)"\u8bf7\u6c42\u8d85\u65f6");
    }

    @ExceptionHandler(value={Exception.class})
    public JsonResponse<String> exception(Exception e) {
        e.printStackTrace();
        return JsonResponse.error((String)e.getMessage());
    }
}

