/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.jdbc.builders.schema.ddl;

import cn.sj1.tinydb.jdbc.builders.schema.ColumnDefinition;
import cn.sj1.tinydb.jdbc.builders.schema.ColumnList;
import cn.sj1.tinydb.jdbc.builders.schema.SqlHelper;
import cn.sj1.tinydb.jdbc.builders.schema.db.JdbcDababaseMetadata;
import cn.sj1.tinydb.jdbc.builders.schema.ddl.AlterTable;
import cn.sj1.tinydb.jdbc.builders.schema.ddl.AlterTableColumnCommand;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSchemaMerge {
    static Logger logger = LoggerFactory.getLogger(DBSchemaMerge.class);
    private static DBSchemaMerge schemaMerge = new DBSchemaMerge("H2 JDBC Driver");
    SqlHelper sqlHelper;

    public static boolean mergeColumns(Connection conn, String tableName, ColumnList columnsExpected) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        DBSchemaMerge.schemaMerge.sqlHelper = SqlHelper.get(metaData.getDriverName(), metaData.getDriverMajorVersion(), metaData.getDriverMinorVersion());
        return schemaMerge.mergeTable(conn, tableName, columnsExpected);
    }

    public boolean merge(Connection conn, String tableName, ColumnList columnsExpected) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        DBSchemaMerge.schemaMerge.sqlHelper = SqlHelper.get(metaData.getDriverName(), metaData.getDriverMajorVersion(), metaData.getDriverMinorVersion());
        return schemaMerge.mergeTable(conn, tableName, columnsExpected);
    }

    public static boolean mergeColumnsRight(Connection conn, String tableName, ColumnList columnsExpected) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        DBSchemaMerge.schemaMerge.sqlHelper = SqlHelper.get(metaData.getDriverName(), metaData.getDriverMajorVersion(), metaData.getDriverMinorVersion());
        return schemaMerge.mergeTableRight(conn, tableName, columnsExpected);
    }

    public boolean mergeRight(Connection conn, String tableName, ColumnList columnsExpected) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        DBSchemaMerge.schemaMerge.sqlHelper = SqlHelper.get(metaData.getDriverName(), metaData.getDriverMajorVersion(), metaData.getDriverMinorVersion());
        return schemaMerge.mergeTableRight(conn, tableName, columnsExpected);
    }

    public DBSchemaMerge(String driverName) {
        this.sqlHelper = SqlHelper.get(driverName, 0, 0);
    }

    public DBSchemaMerge(Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        this.sqlHelper = SqlHelper.get(metaData.getDriverName(), metaData.getDriverMajorVersion(), metaData.getDriverMinorVersion());
    }

    boolean mergeTable(Connection conn, String tableName, ColumnList columnsExpected) throws SQLException {
        ColumnList columnsActual = JdbcDababaseMetadata.getColumns(conn, tableName);
        if (columnsActual.size() == 0) {
            Statement statement = conn.createStatement();
            this.createTable(tableName, columnsExpected);
            statement.executeBatch();
            return false;
        }
        List<AlterTableColumnCommand> commandBus = this.compare(columnsExpected, columnsActual, true);
        logger.info("commandBus {}", commandBus);
        Statement statement = conn.createStatement();
        this.prepareMerge(statement, tableName, commandBus);
        statement.executeBatch();
        statement.close();
        columnsActual = JdbcDababaseMetadata.getColumns(conn, tableName);
        commandBus = this.compare(columnsExpected, columnsActual, true);
        if (commandBus.size() > 0) {
            logger.debug("error {} {}", new Object[]{commandBus, columnsExpected, columnsActual});
        }
        assert (commandBus.size() == 0);
        return true;
    }

    boolean mergeTableRight(Connection conn, String tableName, ColumnList columnsExpected) throws SQLException {
        ColumnList columnsActual = JdbcDababaseMetadata.getColumns(conn, tableName);
        if (columnsActual.size() == 0) {
            String sql = this.createTable(tableName, columnsExpected);
            try {
                Statement statement = conn.createStatement();
                statement.addBatch(sql);
                statement.executeBatch();
            }
            catch (SQLException e) {
                logger.debug("throw exception for sql: {}", (Object)sql);
                throw e;
            }
            return false;
        }
        List<AlterTableColumnCommand> commandBus = this.compare(columnsExpected, columnsActual, false);
        logger.info("commandBus {}", commandBus);
        Statement statement = conn.createStatement();
        this.prepareMerge(statement, tableName, commandBus);
        statement.executeBatch();
        statement.close();
        columnsActual = JdbcDababaseMetadata.getColumns(conn, tableName);
        commandBus = this.compare(columnsExpected, columnsActual, false);
        if (commandBus.size() > 0) {
            logger.debug("{}", (Object)columnsExpected, (Object)columnsActual);
        }
        assert (commandBus.size() == 0);
        return true;
    }

    String createTable(String tableName, ColumnList columnsExpected) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(tableName).append(" (");
        for (ColumnDefinition columnDefinition : columnsExpected) {
            sb.append(columnDefinition.getName()).append(" ").append(this.sqlHelper.toTypeSQL(columnDefinition)).append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ')');
        } else {
            sb.append(')');
        }
        return sb.toString();
    }

    void prepareMerge(Statement statement, String tableName, List<AlterTableColumnCommand> commandBus) throws SQLException {
        for (AlterTableColumnCommand command : commandBus) {
            this.prepareMerge(statement, tableName, command);
        }
    }

    void prepareMerge(Statement statement, String tableName, AlterTableColumnCommand command) throws SQLException {
        String sql = this.sqlHelper.toSql(tableName, command);
        statement.addBatch(sql);
    }

    List<AlterTableColumnCommand> compare(ColumnList columnsExpected, ColumnList columnsActual, boolean dropUnused) throws SQLException {
        ArrayList<AlterTableColumnCommand> commandBus = new ArrayList<AlterTableColumnCommand>();
        for (ColumnDefinition exptected : columnsExpected) {
            String expectedRemarks;
            String actualRemarks;
            ColumnDefinition actual = (ColumnDefinition)columnsActual.get(exptected.getColumnName());
            if (actual == null) {
                commandBus.add(new AlterTable.AddColumnCommand(exptected));
                continue;
            }
            if (this.compareType(exptected, actual)) {
                commandBus.add(new AlterTable.ChangeColumnTypeCommand(exptected));
            } else if (actual.getAutoIncrment() != exptected.getAutoIncrment()) {
                commandBus.add(new AlterTable.ChangeColumnTypeCommand(exptected));
            } else if (!(this.sqlHelper.ignoreSize(exptected.getDataType()) || exptected.getColumnSize() <= actual.getColumnSize() && exptected.getDecimalDigits() <= actual.getDecimalDigits())) {
                commandBus.add(new AlterTable.ChangeColumnTypeCommand(exptected));
            }
            if (exptected.getNullable() != actual.getNullable()) {
                commandBus.add(new AlterTable.AlterColumnNullableCommand(exptected));
            }
            if ((actualRemarks = actual.getRemarks()) != null && actualRemarks.isEmpty()) {
                actualRemarks = null;
            }
            if ((expectedRemarks = exptected.getRemarks()) != null && expectedRemarks.isEmpty()) {
                expectedRemarks = null;
            }
            if (actualRemarks == expectedRemarks || Objects.equals(expectedRemarks, actualRemarks)) continue;
            commandBus.add(new AlterTable.AlterColumnRemarksCommand(exptected));
        }
        if (dropUnused) {
            for (ColumnDefinition actual : columnsActual) {
                ColumnDefinition exptected = (ColumnDefinition)columnsExpected.get(actual.getName());
                if (exptected != null) continue;
                commandBus.add(new AlterTable.DropColumnCommand(actual));
            }
        }
        return commandBus;
    }

    private boolean compareType(ColumnDefinition exptected, ColumnDefinition actual) {
        JDBCType actualDataType = actual.getDataType();
        JDBCType expectedDataType = exptected.getDataType();
        if (actualDataType == JDBCType.DECIMAL) {
            actualDataType = JDBCType.NUMERIC;
        }
        if (expectedDataType == JDBCType.DECIMAL) {
            expectedDataType = JDBCType.NUMERIC;
        }
        if (actualDataType == JDBCType.BOOLEAN) {
            actualDataType = JDBCType.BIT;
        }
        if (expectedDataType == JDBCType.BOOLEAN) {
            expectedDataType = JDBCType.BIT;
        }
        return actualDataType != expectedDataType;
    }

    public ColumnList getColumns(Connection conn, String tableName) throws SQLException {
        return JdbcDababaseMetadata.getColumns(conn, tableName);
    }
}

