/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.jdbc.builders.schema;

import cn.sj1.tinydb.jdbc.builders.schema.ColumnDefinition;
import cn.sj1.tinydb.jdbc.builders.schema.H2SQLHelper;
import cn.sj1.tinydb.jdbc.builders.schema.MysqlSQLHelper;
import cn.sj1.tinydb.jdbc.builders.schema.PostgresqlSQLHelper;
import cn.sj1.tinydb.jdbc.builders.schema.ddl.AlterTableColumnCommand;
import java.sql.JDBCType;

public interface SqlHelper {
    public static final String POSTGRE_SQL_JDBC_DRIVER = "PostgreSQL JDBC Driver";
    public static final String H2_JDBC_DRIVER = "H2 JDBC Driver";
    public static final String MYSQL_JDBC_DRIVER = "MySQL Connector/J";

    public static SqlHelper get(String driverName, int majorVersion, int minorVersion) {
        if (driverName.equals(H2_JDBC_DRIVER)) {
            return new H2SQLHelper();
        }
        if (driverName.equals(POSTGRE_SQL_JDBC_DRIVER)) {
            return new PostgresqlSQLHelper();
        }
        if (driverName.equals(MYSQL_JDBC_DRIVER)) {
            return new MysqlSQLHelper();
        }
        throw new UnsupportedOperationException(String.join((CharSequence)" ", driverName, String.valueOf(majorVersion), String.valueOf(minorVersion)));
    }

    public String toTypeSQL(ColumnDefinition var1);

    public String typeDefinition(JDBCType var1, int var2, int var3);

    public String toSql(String var1, AlterTableColumnCommand var2);

    public boolean ignoreSize(String var1);

    public boolean ignoreSize(JDBCType var1);
}

