/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.jdbc.builders.schema;

import cn.sj1.tinydb.jdbc.builders.schema.ColumnDefinition;
import cn.sj1.tinydb.jdbc.builders.schema.JDBC;
import cn.sj1.tinydb.jdbc.builders.schema.SqlHelper;
import cn.sj1.tinydb.jdbc.builders.schema.ddl.AlterTable;
import cn.sj1.tinydb.jdbc.builders.schema.ddl.AlterTableColumnCommand;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class PostgresqlSQLHelper
implements SqlHelper {
    public static EnumMap<JDBCType, JDBC.ColumnType> mapJDBCType2RealColumnTypeName = new EnumMap(JDBCType.class);
    static Map<String, WithSize> withSizes;

    public static void regestJDBCType2RealColumnTypeName(JDBCType jdbctype, String columnType) {
        mapJDBCType2RealColumnTypeName.put(jdbctype, JDBC.ColumnType.valueOf(columnType));
    }

    @Override
    public String toSql(String tableName, AlterTableColumnCommand command) {
        String sql = null;
        if (command instanceof AlterTable.ChangeColumnTypeCommand) {
            ColumnDefinition column = command.getColumn();
            sql = String.format("ALTER TABLE %s ALTER COLUMN %s TYPE %s", tableName, column.getName(), this.makeColumnType(column));
        } else if (command instanceof AlterTable.AddColumnCommand) {
            ColumnDefinition column = command.getColumn();
            sql = String.format("ALTER TABLE %s ADD COLUMN %s %s", tableName, column.getName(), this.makeColumnType(column));
        } else if (command instanceof AlterTable.DropColumnCommand) {
            sql = String.format("ALTER TABLE %s DROP COLUMN %s", tableName, command.getColumn().getName());
        } else if (command instanceof AlterTable.AlterColumnNullableCommand) {
            sql = command.getColumn().getNullable() == 0 ? String.format("ALTER TABLE %s ALTER COLUMN %s SET NOT NULL", tableName, command.getColumn().getName()) : String.format("ALTER TABLE %s ALTER COLUMN %s DROP NOT NULL", tableName, command.getColumn().getName());
        } else if (command instanceof AlterTable.AlterColumnRemarksCommand) {
            sql = String.format("COMMENT ON COLUMN %s.%s IS '%s';", tableName, command.getColumn().getName(), command.getColumn().getRemarks().replaceAll("'", "''"));
        }
        return sql;
    }

    private Object makeColumnType(ColumnDefinition column) {
        return this.typeDefinition(column.getDataType(), column.getColumnSize(), column.getDecimalDigits());
    }

    @Override
    public boolean ignoreSize(JDBCType dataType) {
        return this.ignoreSize(PostgresqlSQLHelper.mapJDBCType2RealColumnTypeName.get((Object)dataType).name);
    }

    @Override
    public boolean ignoreSize(String dataType) {
        return withSizes.get(dataType) == WithSize.WithNothing;
    }

    @Override
    public String typeDefinition(JDBCType dataType, int columnSize, int decimalDigits) {
        JDBC.ColumnType columnType = mapJDBCType2RealColumnTypeName.get(dataType);
        String definition = !this.ignoreSize(columnType.name) ? columnType.name + this.size(columnSize, decimalDigits) : columnType.name;
        return definition;
    }

    String size(int precision, int scale) {
        if (precision > 0 && scale > 0) {
            return "(" + precision + "," + scale + ")";
        }
        if (precision > 0) {
            return "(" + precision + ")";
        }
        return "";
    }

    @Override
    public String toTypeSQL(ColumnDefinition columnDefinition) {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add(this.typeDefinition(columnDefinition.dataType, columnDefinition.columnSize, columnDefinition.decimalDigits));
        if (columnDefinition.unsigned) {
            sql.add("UNSIGNED");
        }
        if ("YES".equals(columnDefinition.autoIncrment)) {
            sql.add("PRIMARY KEY");
            sql.add("AUTO_INCREMENT");
        }
        if (!columnDefinition.primarykey && columnDefinition.nullable == 0) {
            sql.add("NOT NULL");
        }
        if (columnDefinition.defaultValue != null) {
            sql.add("DEFAULT '" + columnDefinition.defaultValue.replaceAll("'", "''") + "'");
        }
        return String.join((CharSequence)" ", sql);
    }

    static {
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.CHAR, "CHAR(1)");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.VARCHAR, "VARCHAR(256)");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.LONGVARCHAR, "LONGVARCHAR");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.NUMERIC, "NUMERIC(15,6)");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.DECIMAL, "DECIMAL(15,6)");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.BIT, "BIT");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.BOOLEAN, "BOOLEAN");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.TINYINT, "TINYINT(3)");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.SMALLINT, "SMALLINT(5)");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.INTEGER, "INTEGER(10)");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.BIGINT, "BIGINT(19)");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.REAL, "REAL(7)");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.FLOAT, "FLOAT(7)");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.DOUBLE, "DOUBLE(17)");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.BINARY, "BINARY");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.VARBINARY, "VARBINARY");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.LONGVARBINARY, "LONGVARBINARY");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.DATE, "DATE");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.TIME, "TIME");
        PostgresqlSQLHelper.regestJDBCType2RealColumnTypeName(JDBCType.TIMESTAMP, "TIMESTAMP");
        withSizes = new HashMap<String, WithSize>();
        withSizes.put("BIGINT", WithSize.WithNothing);
        withSizes.put("BINARY", WithSize.WithSize);
        withSizes.put("BIT", WithSize.WithSize);
        withSizes.put("BOOLEAN", WithSize.WithNothing);
        withSizes.put("DATE", WithSize.WithNothing);
        withSizes.put("DOUBLE", WithSize.WithNothing);
        withSizes.put("FLOAT", WithSize.WithNothing);
        withSizes.put("INTEGER", WithSize.WithNothing);
        withSizes.put("LONGVARBINARY", WithSize.WithSize);
        withSizes.put("LONGVARCHAR", WithSize.WithSize);
        withSizes.put("DECIMAL", WithSize.WithPercise);
        withSizes.put("NUMERIC", WithSize.WithPercise);
        withSizes.put("REAL", WithSize.WithNothing);
        withSizes.put("SMALLINT", WithSize.WithNothing);
        withSizes.put("TIME", WithSize.WithNothing);
        withSizes.put("TIMESTAMP", WithSize.WithNothing);
        withSizes.put("TINYINT", WithSize.WithNothing);
        withSizes.put("VARBINARY", WithSize.WithSize);
        withSizes.put("VARCHAR", WithSize.WithSize);
    }

    static enum WithSize {
        WithSize,
        WithPercise,
        WithNothing;

    }
}

