/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.jdbc.builders.schema;

import cn.sj1.tinydb.jdbc.builders.schema.ColumnList;
import cn.sj1.tinydb.jdbc.builders.schema.ddl.DBSchemaMerge;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class JDBC {
    private static EnumMap<JDBCType, String> mapJDBCType2JavaClazz = new EnumMap(JDBCType.class);
    private static Map<String, JDBCType> mapJavaClass2JDBCType = new HashMap<String, JDBCType>();
    public static EnumMap<JDBCType, ColumnType> mapJDBCType2RealColumnTypeName;
    private static Map<String, JdbcMapping> mapJavaClazz2JdbcMapping;
    static Map<String, String> sqlMaps;

    public static Timestamp timestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static JDBCType jdbcType(String clazz) {
        return mapJavaClass2JDBCType.get(clazz);
    }

    public static JDBCType jdbcType(Class<?> clazz) {
        return mapJavaClass2JDBCType.get(clazz.getName());
    }

    public static JdbcMapping map(Class<?> pojoClazz) {
        return mapJavaClazz2JdbcMapping.get(pojoClazz.getName());
    }

    @Deprecated
    public static String typeDefinition(JDBCType dataType, int columnSize, int decimalDigits) {
        ColumnType columnType = mapJDBCType2RealColumnTypeName.get(dataType);
        String definition = !JDBC.ignoreSize(dataType) ? columnType.name + JDBC.size(columnSize, decimalDigits) : columnType.name;
        return definition;
    }

    @Deprecated
    static String size(int precision, int scale) {
        if (precision > 0 && scale > 0) {
            return "(" + precision + "," + scale + ")";
        }
        if (precision > 0) {
            return "(" + precision + ")";
        }
        return "";
    }

    public static boolean ignoreSize(JDBCType dataType) {
        return dataType == JDBCType.DATE || dataType == JDBCType.BIGINT || dataType == JDBCType.TIME || dataType == JDBCType.TIMESTAMP || dataType == JDBCType.TIME_WITH_TIMEZONE || dataType == JDBCType.TIMESTAMP_WITH_TIMEZONE || dataType == JDBCType.BOOLEAN;
    }

    public static void regestJDBCType2RealColumnTypeName(JDBCType jdbctype, String columnType) {
        mapJDBCType2RealColumnTypeName.put(jdbctype, ColumnType.valueOf(columnType));
    }

    static void rigester(Class<?> clazz, JdbcMapping jdbctype) {
        mapJavaClazz2JdbcMapping.put(clazz.getName(), jdbctype);
    }

    static void rigester(String clazz, JdbcMapping jdbctype) {
        mapJavaClazz2JdbcMapping.put(clazz, jdbctype);
    }

    public static void registerSQL(String key, String fommatter) {
        sqlMaps.put(key, fommatter);
    }

    public static String getSql(String key) {
        return sqlMaps.get(key);
    }

    public static String sql(String key, Object ... objects) {
        return String.format(sqlMaps.get(key), objects);
    }

    public static boolean mergeIfExists(Connection conn, String tableName, ColumnList columnsExpected) {
        try {
            return new DBSchemaMerge(conn).merge(conn, tableName, columnsExpected);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapJDBCType2JavaClazz.put(JDBCType.CHAR, "java.lang.String");
        mapJDBCType2JavaClazz.put(JDBCType.VARCHAR, "java.lang.String");
        mapJDBCType2JavaClazz.put(JDBCType.LONGVARCHAR, "java.lang.String");
        mapJDBCType2JavaClazz.put(JDBCType.NUMERIC, "java.math.BigDecimal");
        mapJDBCType2JavaClazz.put(JDBCType.DECIMAL, "java.math.BigDecimal");
        mapJDBCType2JavaClazz.put(JDBCType.BOOLEAN, "boolean");
        mapJDBCType2JavaClazz.put(JDBCType.BIT, "boolean");
        mapJDBCType2JavaClazz.put(JDBCType.TINYINT, "byte");
        mapJDBCType2JavaClazz.put(JDBCType.SMALLINT, "short");
        mapJDBCType2JavaClazz.put(JDBCType.INTEGER, "int");
        mapJDBCType2JavaClazz.put(JDBCType.BIGINT, "long");
        mapJDBCType2JavaClazz.put(JDBCType.REAL, "float");
        mapJDBCType2JavaClazz.put(JDBCType.FLOAT, "double");
        mapJDBCType2JavaClazz.put(JDBCType.DOUBLE, "double");
        mapJDBCType2JavaClazz.put(JDBCType.BINARY, "bytes");
        mapJDBCType2JavaClazz.put(JDBCType.VARBINARY, "bytes");
        mapJDBCType2JavaClazz.put(JDBCType.LONGVARBINARY, "bytes");
        mapJDBCType2JavaClazz.put(JDBCType.DATE, "java.sql.Date");
        mapJDBCType2JavaClazz.put(JDBCType.TIME, "java.sql.Time");
        mapJDBCType2JavaClazz.put(JDBCType.TIMESTAMP, "java.sql.Timestamp");
        mapJavaClass2JDBCType.put("java.lang.String", JDBCType.VARCHAR);
        mapJavaClass2JDBCType.put("java.math.BigDecimal", JDBCType.DECIMAL);
        mapJavaClass2JDBCType.put("boolean", JDBCType.BOOLEAN);
        mapJavaClass2JDBCType.put("char", JDBCType.CHAR);
        mapJavaClass2JDBCType.put("byte", JDBCType.TINYINT);
        mapJavaClass2JDBCType.put("short", JDBCType.SMALLINT);
        mapJavaClass2JDBCType.put("int", JDBCType.INTEGER);
        mapJavaClass2JDBCType.put("long", JDBCType.BIGINT);
        mapJavaClass2JDBCType.put("float", JDBCType.REAL);
        mapJavaClass2JDBCType.put("double", JDBCType.DOUBLE);
        mapJavaClass2JDBCType.put("bytes", JDBCType.BINARY);
        mapJavaClass2JDBCType.put("java.sql.Date", JDBCType.DATE);
        mapJavaClass2JDBCType.put("java.sql.Time", JDBCType.TIME);
        mapJavaClass2JDBCType.put("java.sql.Timestamp", JDBCType.TIMESTAMP);
        mapJavaClass2JDBCType.put("java.lang.Boolean", JDBCType.BOOLEAN);
        mapJavaClass2JDBCType.put("java.lang.Character", JDBCType.VARCHAR);
        mapJavaClass2JDBCType.put("java.lang.Byte", JDBCType.TINYINT);
        mapJavaClass2JDBCType.put("java.lang.Short", JDBCType.SMALLINT);
        mapJavaClass2JDBCType.put("java.lang.Integer", JDBCType.INTEGER);
        mapJavaClass2JDBCType.put("java.lang.Long", JDBCType.BIGINT);
        mapJavaClass2JDBCType.put("java.lang.Float", JDBCType.REAL);
        mapJavaClass2JDBCType.put("java.lang.Double", JDBCType.DOUBLE);
        mapJavaClass2JDBCType.put("java.lang.Date", JDBCType.DATE);
        mapJDBCType2RealColumnTypeName = new EnumMap(JDBCType.class);
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.CHAR, "CHAR(1)");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.VARCHAR, "VARCHAR(256)");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.LONGVARCHAR, "LONGVARCHAR");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.NUMERIC, "NUMERIC(15,6)");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.DECIMAL, "DECIMAL(15,6)");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.BIT, "BIT");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.BOOLEAN, "BOOLEAN");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.TINYINT, "TINYINT(3)");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.SMALLINT, "SMALLINT(5)");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.INTEGER, "INTEGER(10)");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.BIGINT, "BIGINT(19)");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.REAL, "REAL(7)");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.FLOAT, "FLOAT(7)");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.DOUBLE, "DOUBLE(17)");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.BINARY, "BINARY");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.VARBINARY, "VARBINARY");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.LONGVARBINARY, "LONGVARBINARY");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.DATE, "DATE");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.TIME, "TIME");
        JDBC.regestJDBCType2RealColumnTypeName(JDBCType.TIMESTAMP, "TIMESTAMP");
        mapJavaClazz2JdbcMapping = new HashMap<String, JdbcMapping>();
        JDBC.rigester(String.class, new JdbcMapping("String", "getString", "setString", String.class));
        JDBC.rigester(Boolean.TYPE, new JdbcMapping("boolean", "getBoolean", "setBoolean", Boolean.TYPE));
        JDBC.rigester(Character.TYPE, new JdbcMapping("String", "getString", "setString", String.class));
        JDBC.rigester(Byte.TYPE, new JdbcMapping("byte", "getByte", "setByte", Byte.TYPE));
        JDBC.rigester(Short.TYPE, new JdbcMapping("short", "getShort", "setShort", Short.TYPE));
        JDBC.rigester(Integer.TYPE, new JdbcMapping("int", "getInt", "setInt", Integer.TYPE));
        JDBC.rigester(Long.TYPE, new JdbcMapping("long", "getLong", "setLong", Long.TYPE));
        JDBC.rigester(Float.TYPE, new JdbcMapping("float", "getFloat", "setFloat", Float.TYPE));
        JDBC.rigester(Double.TYPE, new JdbcMapping("double", "getDouble", "setDouble", Double.TYPE));
        JDBC.rigester("bytes", new JdbcMapping("bytes", "getBytes", "setBytes", byte[].class));
        JDBC.rigester(Date.class, new JdbcMapping("java.sql.Date", "getDate", "setDate", Date.class));
        JDBC.rigester(Time.class, new JdbcMapping("Time", "getTime", "setTime", Time.class));
        JDBC.rigester(Timestamp.class, new JdbcMapping("Timestamp", "getTimestamp", "setTimestamp", Timestamp.class));
        JDBC.rigester(BigDecimal.class, new JdbcMapping("java.math.BigDecimal", "getBigDecimal", "setBigDecimal", BigDecimal.class));
        JDBC.rigester(String.class, new JdbcMapping("String", "getString", "setString", String.class));
        JDBC.rigester(Character.class, new JdbcMapping("String", "getString", "setString", String.class));
        JDBC.rigester(Boolean.class, new JdbcMapping("boolean", "getBoolean", "setBoolean", Boolean.TYPE));
        JDBC.rigester(Byte.class, new JdbcMapping("byte", "getByte", "setByte", Byte.TYPE));
        JDBC.rigester(Short.class, new JdbcMapping("short", "getShort", "setShort", Short.TYPE));
        JDBC.rigester(Integer.class, new JdbcMapping("int", "getInt", "setInt", Integer.TYPE));
        JDBC.rigester(Long.class, new JdbcMapping("long", "getLong", "setLong", Long.TYPE));
        JDBC.rigester(Float.class, new JdbcMapping("float", "getFloat", "setFloat", Float.TYPE));
        JDBC.rigester(Double.class, new JdbcMapping("double", "getDouble", "setDouble", Double.TYPE));
        sqlMaps = new HashMap<String, String>();
        JDBC.registerSQL("ALTER TABLE ${tablename} ADD COLUMN ${columnname} ${columndefinition}", "ALTER TABLE %1$s ADD COLUMN %2$s  TYPE %3$s");
        JDBC.registerSQL("ALTER TABLE ${tablename} ALTER COLUMN ${columnname} ${columndefinition}", "ALTER TABLE %1$s ALTER COLUMN %2$s TYPE %3$s");
        JDBC.registerSQL("ALTER TABLE ${tablename} ALTER COLUMN ${oldname} RENAME TO ${newname}", "ALTER TABLE %1$s ALTER COLUMN %2$s RENAME TO %3$s");
        JDBC.registerSQL("ALTER TABLE ${tablename} ALTER COLUMN ${oldname} SET ${nullable}", "ALTER TABLE %1$s ALTER COLUMN %2$s SET %3$s");
        JDBC.registerSQL("ALTER TABLE ${tablename} ALTER COLUMN ${columnname} REMARKS ${remarks}", "COMMENT ON COLUMN %1$s.%2$s IS '%3$s'");
        JDBC.registerSQL("ALTER TABLE ${tablename} ADD PRIMARY KEY ${columnname}", "ALTER TABLE %1$s ADD PRIMARY KEY (%2$s)");
        JDBC.registerSQL("ALTER TABLE ${tablename} DROP COLUMN ${columnname}", "ALTER TABLE %1$s DROP COLUMN %2$s");
        JDBC.registerSQL("CREATE TABLE ${tablename}(${columndefinitions}))", "CREATE TABLE %1$s(%2$s)");
        JDBC.registerSQL("CREATE TABLE ${tablename}(${columndefinitions},PRIMARY KEY(${keys}))", "CREATE TABLE %1$s(%2$s,PRIMARY KEY(%3$s))");
        JDBC.registerSQL("SELECT ${columns} FROM ${tablename}", "SELECT %1$s FROM %2$s");
        JDBC.registerSQL("SELECT ${columns} FROM ${tablename} WHERE ${causes}", "SELECT %1$s FROM %2$s WHERE %3$s");
        JDBC.registerSQL("INSERT INTO ${tablename}(${columns}) VALUES(${values})", "INSERT INTO %1$s(%2$s) VALUES(%3$s)");
        JDBC.registerSQL("UPDATE ${tablename} SET ${setvalues} WHERE ${causes}", "UPDATE %1$s SET %2$s WHERE %3$s");
        JDBC.registerSQL("DELETE ${tablename} WHERE ${causes}", "DELETE %1$s WHERE %2$s");
    }

    public static class JdbcMapping {
        public String typename;
        public String getname;
        public String setName;
        public Class<?> jdbcClazz;

        public JdbcMapping(String typename, String getname, String setname, Class<?> getclazz) {
            this.typename = typename;
            this.getname = getname;
            this.setName = setname;
            this.jdbcClazz = getclazz;
        }
    }

    static class ColumnType {
        final String name;
        final int size;
        final int digit;

        public ColumnType(String name, int size, int digit) {
            this.name = name;
            this.size = size;
            this.digit = digit;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ColumnDefault [name=");
            builder.append(this.name);
            builder.append(", size=");
            builder.append(this.size);
            builder.append(", digit=");
            builder.append(this.digit);
            builder.append("]");
            return builder.toString();
        }

        static ColumnType valueOf(String define) {
            int digit;
            int size;
            String name;
            int begin = define.indexOf(40);
            if (begin > 0) {
                name = define.substring(0, begin);
                int com = define.indexOf(44, begin);
                if (com > 0) {
                    size = Integer.parseInt(define.substring(begin + 1, com));
                    digit = Integer.parseInt(define.substring(com + 1, define.length() - 1));
                } else {
                    size = Integer.parseInt(define.substring(begin + 1, define.length() - 1));
                    digit = 0;
                }
            } else {
                name = define;
                size = 0;
                digit = 0;
            }
            return new ColumnType(name, size, digit);
        }
    }
}

