/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.jdbc.builders.schema;

import cn.sj1.tinydb.dbal.jdbc.builders.schema.Column;
import cn.sj1.tinydb.jdbc.builders.schema.JDBC;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColumnDefinition
implements Column {
    private static final String YES = "YES";
    private static final String NO = "NO";
    static EnumMap<JDBCType, WithSize> withSizes = new EnumMap(JDBCType.class);
    static Pattern CONST_PATTERN;
    String columnName;
    JDBCType dataType;
    String typeName;
    int columnSize;
    int decimalDigits;
    int nullable = 1;
    String remarks = "";
    String defaultValue;
    int charOctetLength;
    int ordinalPosition;
    short sourceDataType;
    String autoIncrment = "NO";
    boolean unsigned = false;
    boolean primarykey = false;

    public static ColumnDefinition BIGINT(String name) {
        return new ColumnDefinition(name, JDBCType.BIGINT);
    }

    public static ColumnDefinition BINARY(String name) {
        return new ColumnDefinition(name, JDBCType.BINARY);
    }

    public static ColumnDefinition BIT(String name) {
        return new ColumnDefinition(name, JDBCType.BIT);
    }

    public static ColumnDefinition BOOLEAN(String name) {
        return new ColumnDefinition(name, JDBCType.BOOLEAN);
    }

    public static ColumnDefinition CHAR(String name) {
        return new ColumnDefinition(name, JDBCType.CHAR);
    }

    public static ColumnDefinition Column(JDBCType type, String name) {
        return new ColumnDefinition(name, type);
    }

    public static ColumnDefinition DATE(String name) {
        return new ColumnDefinition(name, JDBCType.DATE);
    }

    public static ColumnDefinition DECIMAL(String name) {
        return new ColumnDefinition(name, JDBCType.DECIMAL);
    }

    public static ColumnDefinition DOUBLE(String name) {
        return new ColumnDefinition(name, JDBCType.DOUBLE);
    }

    public static ColumnDefinition FLOAT(String name) {
        return new ColumnDefinition(name, JDBCType.FLOAT);
    }

    public static ColumnDefinition IDENTITY(String name) {
        return new ColumnDefinition(name, JDBCType.BIGINT).primarykey();
    }

    public static boolean ignoreSize(JDBCType dataType) {
        return withSizes.get(dataType) == WithSize.WithNothing;
    }

    public static ColumnDefinition INTEGER(String name) {
        return new ColumnDefinition(name, JDBCType.INTEGER);
    }

    public static ColumnDefinition LONGVARBINARY(String name) {
        return new ColumnDefinition(name, JDBCType.LONGVARBINARY);
    }

    public static ColumnDefinition LONGVARCHAR(String name) {
        return new ColumnDefinition(name, JDBCType.LONGVARCHAR);
    }

    public static ColumnDefinition NUMERIC(String name) {
        return new ColumnDefinition(name, JDBCType.NUMERIC);
    }

    public static ColumnDefinition REAL(String name) {
        return new ColumnDefinition(name, JDBCType.REAL);
    }

    private static String size(int precision, int scale) {
        if (precision > 0 && scale > 0) {
            return "(" + precision + "," + scale + ")";
        }
        if (precision > 0) {
            return "(" + precision + ")";
        }
        return "";
    }

    public static ColumnDefinition SMALLINT(String name) {
        return new ColumnDefinition(name, JDBCType.SMALLINT);
    }

    public static ColumnDefinition TIME(String name) {
        return new ColumnDefinition(name, JDBCType.TIME);
    }

    public static ColumnDefinition TIMESTAMP(String name) {
        return new ColumnDefinition(name, JDBCType.TIMESTAMP);
    }

    public static ColumnDefinition TINYINT(String name) {
        return new ColumnDefinition(name, JDBCType.TINYINT);
    }

    public static ColumnDefinition valueOf(String sql) {
        Matcher matcher = CONST_PATTERN.matcher(sql);
        ColumnDefinition column = null;
        if (matcher.find()) {
            String remark;
            String defaultValue;
            String nullable;
            String autoIncrement;
            String primaryKey;
            String digit;
            String size;
            int j = 1;
            String name = matcher.group(j++);
            String type = matcher.group(j++);
            column = ColumnDefinition.Column(JDBCType.valueOf(type), name);
            if ((size = matcher.group(j++)) != null) {
                column.size(Integer.parseInt(size));
            }
            if ((digit = matcher.group(j++)) != null) {
                column.digits(Integer.parseInt(digit));
            }
            if ((primaryKey = matcher.group(j++)) != null && "PRIMARY KEY".equals(primaryKey)) {
                column.primarykey();
            }
            if ((autoIncrement = matcher.group(j++)) != null && "AUTO_INCREMENT".equals(autoIncrement)) {
                column.autoIncrement();
            }
            if ((nullable = matcher.group(j++)) != null) {
                if ("NOT NULL".endsWith(nullable)) {
                    column.required();
                } else if ("NULL".endsWith(nullable)) {
                    column.required(false);
                }
            }
            if ((defaultValue = matcher.group(j++)) != null) {
                column.defaultValue(defaultValue.replaceAll("''", "'"));
            }
            if ((remark = matcher.group(j++)) != null) {
                column.remarks(remark.replaceAll("''", "'"));
            }
        }
        return column;
    }

    public static ColumnDefinition VARBINARY(String name) {
        return new ColumnDefinition(name, JDBCType.VARBINARY);
    }

    public static ColumnDefinition VARCHAR(String name) {
        return new ColumnDefinition(name, JDBCType.VARCHAR, 256);
    }

    public static ColumnDefinition VARCHAR(String name, int length) {
        return new ColumnDefinition(name, JDBCType.VARCHAR, length);
    }

    public ColumnDefinition(String name, JDBCType datatype) {
        this.columnName = name;
        this.dataType = datatype;
        JDBC.ColumnType columnType = JDBC.mapJDBCType2RealColumnTypeName.get(this.dataType);
        this.columnSize = columnType.size;
        this.decimalDigits = columnType.digit;
    }

    public ColumnDefinition(String name, JDBCType datatype, int size) {
        this.columnName = name;
        this.dataType = datatype;
        this.columnSize = size;
        this.decimalDigits = 0;
    }

    public ColumnDefinition(String columnName, JDBCType dataType, String typeName, int columnSize, int decimalDigits, int nullable, String remarks, String defaultValue, int charOctetLength, int ordinalPosition, short sourceDataType, String autoIncrment) {
        this.columnName = columnName;
        this.dataType = dataType;
        this.typeName = typeName;
        this.columnSize = columnSize;
        this.decimalDigits = decimalDigits;
        this.nullable = nullable;
        this.remarks = remarks;
        this.defaultValue = defaultValue;
        this.charOctetLength = charOctetLength;
        this.ordinalPosition = ordinalPosition;
        this.sourceDataType = sourceDataType;
        this.autoIncrment = YES.equals(autoIncrment) ? YES : NO;
    }

    public ColumnDefinition primarykey() {
        this.primarykey = true;
        return this;
    }

    public ColumnDefinition autoIncrement() {
        this.primarykey();
        this.autoIncrment = YES;
        return this;
    }

    public ColumnDefinition remarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    public ColumnDefinition required() {
        this.nullable = 0;
        return this;
    }

    public ColumnDefinition required(boolean required) {
        this.nullable = required ? 0 : 1;
        return this;
    }

    public ColumnDefinition size(int size) {
        this.columnSize = size;
        return this;
    }

    public ColumnDefinition unsigned() {
        this.unsigned = true;
        return this;
    }

    public ColumnDefinition digits(int digits) {
        this.decimalDigits = digits;
        return this;
    }

    public ColumnDefinition defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String getAutoIncrment() {
        return this.autoIncrment;
    }

    public int getCharOctetLength() {
        return this.charOctetLength;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public JDBCType getDataType() {
        return this.dataType;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    public int getNullable() {
        return this.primarykey ? 0 : this.nullable;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public short getSourceDataType() {
        return this.sourceDataType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isPrimarykey() {
        return this.primarykey;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    @Override
    public String toDemoSQL() {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add(this.columnName);
        sql.add(JDBC.typeDefinition(this.dataType, this.columnSize, this.decimalDigits));
        if (this.unsigned) {
            sql.add("UNSIGNED");
        }
        if (YES.equals(this.autoIncrment)) {
            sql.add("PRIMARY KEY");
            sql.add("AUTO_INCREMENT");
        }
        if (!this.primarykey && this.nullable == 0) {
            sql.add("NOT NULL");
        }
        if (this.defaultValue != null) {
            sql.add("DEFAULT '" + this.defaultValue.replaceAll("'", "''") + "'");
        }
        return String.join((CharSequence)" ", sql);
    }

    public String toString() {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add(this.columnName);
        String definition = !ColumnDefinition.ignoreSize(this.dataType) ? this.dataType.getName() + ColumnDefinition.size(this.columnSize, this.decimalDigits) : this.dataType.getName();
        sql.add(definition);
        if (this.primarykey) {
            sql.add("PRIMARY KEY");
            if (YES.equals(this.autoIncrment)) {
                sql.add("AUTO_INCREMENT");
            }
        } else if (this.nullable == 0) {
            sql.add("NOT NULL");
        }
        if (this.defaultValue != null) {
            sql.add("DEFAULT '" + this.defaultValue.replace("'", "''") + "'");
        }
        if (this.remarks != null && !this.remarks.isEmpty()) {
            sql.add("REMARKS '" + this.remarks.replace("'", "''") + "'");
        }
        return String.join((CharSequence)" ", sql);
    }

    static {
        withSizes.put(JDBCType.BIGINT, WithSize.WithNothing);
        withSizes.put(JDBCType.BINARY, WithSize.WithSize);
        withSizes.put(JDBCType.BIT, WithSize.WithSize);
        withSizes.put(JDBCType.BOOLEAN, WithSize.WithNothing);
        withSizes.put(JDBCType.DATE, WithSize.WithNothing);
        withSizes.put(JDBCType.DOUBLE, WithSize.WithNothing);
        withSizes.put(JDBCType.FLOAT, WithSize.WithNothing);
        withSizes.put(JDBCType.INTEGER, WithSize.WithNothing);
        withSizes.put(JDBCType.LONGVARBINARY, WithSize.WithSize);
        withSizes.put(JDBCType.LONGVARCHAR, WithSize.WithSize);
        withSizes.put(JDBCType.DECIMAL, WithSize.WithPercise);
        withSizes.put(JDBCType.NUMERIC, WithSize.WithPercise);
        withSizes.put(JDBCType.REAL, WithSize.WithNothing);
        withSizes.put(JDBCType.SMALLINT, WithSize.WithNothing);
        withSizes.put(JDBCType.TIME, WithSize.WithNothing);
        withSizes.put(JDBCType.TIMESTAMP, WithSize.WithNothing);
        withSizes.put(JDBCType.TINYINT, WithSize.WithNothing);
        withSizes.put(JDBCType.VARBINARY, WithSize.WithSize);
        withSizes.put(JDBCType.VARCHAR, WithSize.WithSize);
        CONST_PATTERN = Pattern.compile("([\\w\\d]+) (\\w+)(?:\\((\\d*)(?:,(\\d*))?\\))?(?: (PRIMARY KEY))?(?: (AUTO_INCREMENT))?(?: ((?:NOT )?NULL))?(?: DEFAULT \\'([^\\']+(?:(?:\\'\\')[^\\']*)*)\\')?(?: REMARKS \\'([^\\']+(?:(?:\\'\\')[^\\']*)*)\\')?");
    }

    static enum WithSize {
        WithSize,
        WithPercise,
        WithNothing;

    }
}

