/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.statements;

import cn.sj1.tinydb.dbal.jdbc.QueryParameters;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.Update;
import cn.sj1.tinydb.dbal.jdbc.statements.SQLError;
import cn.sj1.tinydb.dbal.jdbc.statements.SQLStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class UpdateStatement
extends SQLStatement {
    private final Update update;

    public UpdateStatement(Connection connection, String table) {
        super(connection);
        this.update = Update.table(table);
    }

    public UpdateStatement columns(String ... columns) {
        this.update.columns(columns);
        return this;
    }

    public UpdateStatement where(String clause) {
        this.update.where(clause);
        return this;
    }

    public void execute(Object ... parameters) {
        try (PreparedStatement statement = this.connection.prepareStatement(this.update.toDemoSQL());){
            QueryParameters.bind(statement, parameters);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw SQLError.producedBy(this.update, parameters, e);
        }
    }
}

