/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.statements;

import cn.sj1.tinydb.dbal.jdbc.QueryParameters;
import cn.sj1.tinydb.dbal.jdbc.RowMapper;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.Select;
import cn.sj1.tinydb.dbal.jdbc.statements.Criteria;
import cn.sj1.tinydb.dbal.jdbc.statements.Hydrator;
import cn.sj1.tinydb.dbal.jdbc.statements.SQLError;
import cn.sj1.tinydb.dbal.jdbc.statements.SQLStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SelectStatement<T>
extends SQLStatement {
    private final Select select;
    private final RowMapper<T> mapper;

    public SelectStatement(Connection connection, String table, RowMapper<T> mapper) {
        super(connection);
        this.select = Select.all().from(table);
        this.mapper = mapper;
    }

    public SelectStatement(SelectStatement<T> statement) {
        this(statement.connection, new Select(statement.select), statement.mapper);
    }

    private SelectStatement(Connection connection, Select select, RowMapper<T> mapper) {
        super(connection);
        this.select = select;
        this.mapper = mapper;
    }

    public SelectStatement<T> select(String ... columns) {
        this.select.addColumns(columns);
        return this;
    }

    public SelectStatement<T> count() {
        this.select.count();
        return this;
    }

    public SelectStatement<T> addAlias(String alias) {
        this.select.addTableAlias(alias);
        return this;
    }

    public SelectStatement<T> matching(Criteria criteria) {
        criteria.applyTo(this.select);
        return this;
    }

    public SelectStatement<T> where(String clause) {
        this.select.where(clause);
        return this;
    }

    public SelectStatement<T> whereIn(String column, String[] values) {
        this.select.where(column, values.length);
        return this;
    }

    public SelectStatement<T> offset(int offset) {
        this.select.offset(offset);
        return this;
    }

    public SelectStatement<T> limit(int limit) {
        this.select.limit(limit);
        return this;
    }

    public SelectStatement<T> join(String table, String on) {
        this.select.join(table, on);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Hydrator<T> execute(Object ... parameters) {
        try (PreparedStatement statement = this.connection.prepareStatement(this.select.toDemoSQL());){
            QueryParameters.bind(statement, parameters);
            ResultSet resultSet = statement.executeQuery();
            Hydrator<T> hydrator = new Hydrator<T>(resultSet, this.mapper);
            return hydrator;
        }
        catch (SQLException e) {
            throw SQLError.producedBy(this.select, parameters, e);
        }
    }
}

