/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.statements;

import cn.sj1.tinydb.dbal.jdbc.QueryParameters;
import cn.sj1.tinydb.dbal.jdbc.RowMapper;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.Insert;
import cn.sj1.tinydb.dbal.jdbc.statements.Hydrator;
import cn.sj1.tinydb.dbal.jdbc.statements.SQLError;
import cn.sj1.tinydb.dbal.jdbc.statements.SQLStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class InsertStatement<T>
extends SQLStatement {
    private Insert insert;
    private final RowMapper<T> mapper;

    public InsertStatement(Connection connection, String table, RowMapper<T> mapper) {
        super(connection);
        this.insert = Insert.into(table);
        this.mapper = mapper;
    }

    public InsertStatement<T> columns(String ... columns) {
        this.insert.columns(columns);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Hydrator<T> execute(Object ... parameters) {
        try (PreparedStatement statement = this.connection.prepareStatement(this.insert.toDemoSQL(), 1);){
            QueryParameters.bind(statement, parameters);
            statement.executeUpdate();
            ResultSet key = statement.getGeneratedKeys();
            key.next();
            Hydrator<T> hydrator = new Hydrator<T>(key.getLong(1), parameters, this.mapper);
            return hydrator;
        }
        catch (SQLException e) {
            throw SQLError.producedBy(this.insert, parameters, e);
        }
    }
}

