/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.statements;

import cn.sj1.tinydb.dbal.jdbc.RowMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Hydrator<T> {
    private List<List<Object>> rows;
    private RowMapper<T> mapper;

    private Hydrator(List<List<Object>> rows, RowMapper<T> mapper) {
        this.rows = rows;
        this.mapper = mapper;
    }

    Hydrator(ResultSet resultSet, RowMapper<T> mapper) throws SQLException {
        this(Hydrator.populateValues(resultSet), mapper);
    }

    Hydrator(long id, Object[] insertedValues, RowMapper<T> mapper) {
        this.mapper = mapper;
        this.rows = new ArrayList<List<Object>>();
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(id);
        row.addAll(Arrays.asList(insertedValues));
        this.rows.add(row);
    }

    public T fetch() {
        if (this.rows.isEmpty()) {
            return null;
        }
        return this.mapper.mapRow(this.rows.get(0));
    }

    public List<T> fetchAll() {
        ArrayList entities = new ArrayList();
        this.rows.forEach(row -> entities.add(this.mapper.mapRow((List<Object>)row)));
        return entities;
    }

    public long fetchLong() {
        return (Long)this.rows.get(0).get(0);
    }

    private static List<List<Object>> populateValues(ResultSet resultSet) throws SQLException {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        int columnCount = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 1; i <= columnCount; ++i) {
                row.add(resultSet.getObject(i));
            }
            rows.add(row);
        }
        return rows;
    }
}

