/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.builders.schema;

import cn.sj1.tinydb.dbal.jdbc.builders.HasSQLRepresentation;
import cn.sj1.tinydb.dbal.jdbc.builders.schema.Column;
import cn.sj1.tinydb.dbal.jdbc.builders.schema.ForeignKey;
import cn.sj1.tinydb.dbal.jdbc.builders.schema.PrimaryKey;
import cn.sj1.tinydb.jdbc.builders.schema.ColumnDefinition;
import java.util.ArrayList;
import java.util.List;

public class Table
implements HasSQLRepresentation {
    private final String name;
    private List<Column> columns;
    private PrimaryKey primaryKey;
    private List<ForeignKey> foreignKeys;
    private boolean ifNotExists = false;

    Table(String name) {
        this.name = name;
        this.columns = new ArrayList<Column>();
        this.foreignKeys = new ArrayList<ForeignKey>();
    }

    public ColumnDefinition string(String name) {
        return this.string(name, 256);
    }

    public ColumnDefinition string(String name, int length) {
        ColumnDefinition column = ColumnDefinition.VARCHAR(name, length);
        this.columns.add(column);
        return column;
    }

    public ColumnDefinition integer(String name) {
        ColumnDefinition column = ColumnDefinition.INTEGER(name);
        this.columns.add(column);
        return column;
    }

    public ColumnDefinition increments(String name) {
        ColumnDefinition id = ColumnDefinition.INTEGER(name).autoIncrement().unsigned().required();
        this.primaryKey = new PrimaryKey(id);
        this.columns.add(id);
        return id;
    }

    public ForeignKey foreign(Column column) {
        ForeignKey foreignKey = new ForeignKey(column);
        this.foreignKeys.add(foreignKey);
        return foreignKey;
    }

    public PrimaryKey primary(Column ... columns) {
        this.primaryKey = PrimaryKey.composed(columns);
        return this.primaryKey;
    }

    public Table ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    @Override
    public String toDemoSQL() {
        this.assertPrimaryKeyIsPresent();
        return String.format("CREATE TABLE %s %s (%s %s %s) ENGINE = InnoDB DEFAULT CHARACTER SET = utf8;", this.ifNotExistsSQL(), this.name, this.columnDefinitions(), this.primaryKey.toDemoSQL(), this.foreignKeysSQL()).replaceAll("( )+", " ");
    }

    private String ifNotExistsSQL() {
        return this.ifNotExists ? "IF NOT EXISTS" : "";
    }

    private void assertPrimaryKeyIsPresent() {
        if (this.primaryKey == null) {
            throw new IllegalStateException("Cannot create table without a primary key");
        }
    }

    private String foreignKeysSQL() {
        StringBuilder sql = new StringBuilder();
        this.foreignKeys.forEach(foreignKey -> sql.append(", ").append(foreignKey.toDemoSQL()));
        return sql.toString();
    }

    private String columnDefinitions() {
        StringBuilder definition = new StringBuilder();
        this.columns.forEach(column -> definition.append(column.toDemoSQL()).append(", "));
        return definition.toString().trim();
    }
}

