/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.builders.schema;

import cn.sj1.tinydb.dbal.jdbc.builders.HasSQLRepresentation;
import cn.sj1.tinydb.dbal.jdbc.builders.schema.Column;

public class ForeignKey
implements HasSQLRepresentation {
    private final Column column;
    private String foreignKeyName;
    private String table;

    ForeignKey(Column column) {
        this.column = column;
    }

    public ForeignKey references(String name) {
        this.foreignKeyName = name;
        return this;
    }

    public ForeignKey on(String table) {
        this.table = table;
        return this;
    }

    @Override
    public String toDemoSQL() {
        this.assertReferenceIsSet();
        return String.format("FOREIGN KEY (%s) REFERENCES %s(%s)", this.column.getName(), this.table, this.foreignKeyName);
    }

    private void assertReferenceIsSet() {
        if (this.table == null) {
            throw new IllegalStateException("Cannot determine to which table this key refers to");
        }
        if (this.foreignKeyName == null) {
            throw new IllegalStateException("Cannot determine to which column this key refers to");
        }
    }
}

