/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.builders.queries;

import cn.sj1.tinydb.dbal.jdbc.builders.HasSQLRepresentation;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.ParameterPlaceholders;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.WhereExpression;
import java.util.ArrayList;
import java.util.List;

class Where
implements HasSQLRepresentation {
    private final List<WhereExpression> expressions = new ArrayList<WhereExpression>();

    private Where() {
    }

    public static Where empty() {
        return new Where();
    }

    public Where and(String expression) {
        this.addWhere(expression, WhereExpression.Operator.AND);
        return this;
    }

    public Where and(String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            this.and(String.format("%s = ?", columns[i]));
        }
        return this;
    }

    public Where and(String column, int parametersCount) {
        this.addWhere(this.whereInToSQL(column, parametersCount), WhereExpression.Operator.AND);
        return this;
    }

    public Where or(String expression) {
        this.addWhere(expression, WhereExpression.Operator.OR);
        return this;
    }

    public Where or(String column, int parametersCount) {
        this.addWhere(this.whereInToSQL(column, parametersCount), WhereExpression.Operator.OR);
        return this;
    }

    private String whereInToSQL(String column, int parametersCount) {
        return String.format("%s IN %s", column, ParameterPlaceholders.generate(parametersCount));
    }

    private void addWhere(String expression, WhereExpression.Operator operator) {
        if (this.isEmpty()) {
            operator = null;
        }
        this.expressions.add(WhereExpression.with(expression, operator));
    }

    @Override
    public String toDemoSQL() {
        if (this.isEmpty()) {
            return "";
        }
        return String.format("WHERE %s", this.appendExpressions());
    }

    private String appendExpressions() {
        StringBuilder where = new StringBuilder();
        this.expressions.forEach(expression -> where.append(expression.toDemoSQL()).append(" "));
        return where.toString().replaceAll(" $", "");
    }

    private boolean isEmpty() {
        return this.expressions.size() == 0;
    }
}

