/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.builders.queries;

import cn.sj1.tinydb.dbal.jdbc.builders.HasSQLRepresentation;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.Where;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Update
implements HasSQLRepresentation {
    private String table;
    private List<String> columns;
    private Where where;

    private Update(String table) {
        this.table = table;
        this.columns = new ArrayList<String>();
        this.where = Where.empty();
    }

    public Update columns(String ... columns) {
        Collections.addAll(this.columns, columns);
        return this;
    }

    public Update where(String expression) {
        this.where.and(expression);
        return this;
    }

    public Update where(String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            this.where.and(String.format("%s = ?", columns[i]));
        }
        return this;
    }

    public Update orWhere(String expression) {
        this.where.or(expression);
        return this;
    }

    public static Update table(String table) {
        return new Update(table);
    }

    @Override
    public String toDemoSQL() {
        this.assertNonEmptyColumns();
        return String.format("UPDATE %s SET %s %s", this.table, this.columnsToSQL(), this.where.toDemoSQL()).trim();
    }

    private void assertNonEmptyColumns() {
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("Cannot determine what columns to update");
        }
    }

    private String columnsToSQL() {
        return String.join((CharSequence)", ", (CharSequence[])this.columns.stream().map(column -> column + " = ?").toArray(String[]::new));
    }
}

