/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.builders.queries;

import cn.sj1.tinydb.CommonSQLConditionVisitor;
import cn.sj1.tinydb.Condition;
import cn.sj1.tinydb.OrderBy;
import cn.sj1.tinydb.dbal.jdbc.builders.HasSQLRepresentation;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.Columns;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.From;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.Join;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.Rows;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.Where;
import cn.sj1.tinydb.dbal.jdbc.builders.schema.Column;
import cn.sj1.tinydb.jdbc.builders.schema.ColumnList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Select
implements HasSQLRepresentation {
    private Map<String, HasSQLRepresentation> parts = new HashMap<String, HasSQLRepresentation>();

    public Select(Columns columns) {
        this.parts.put("from", From.empty());
        this.parts.put("columns", columns);
        this.parts.put("where", Where.empty());
        this.parts.put("orderby", OrderBy.empty());
        this.parts.put("join", Join.empty());
        this.parts.put("rows", Rows.all());
    }

    public Select(Select select) {
        this.parts.put("from", new From((From)select.parts.get("from")));
        this.parts.put("columns", new Columns((Columns)select.parts.get("columns")));
        this.parts.put("where", select.parts.get("where"));
        this.parts.put("orderby", OrderBy.empty());
        this.parts.put("join", select.parts.get("join"));
        this.parts.put("rows", select.parts.get("rows"));
    }

    public static Select all() {
        return new Select(Columns.all());
    }

    public static Select columns(String columns) {
        return new Select(Columns.empty().add(columns.split(",")));
    }

    public static Select columns(String ... columns) {
        return new Select(Columns.empty().add(columns));
    }

    public static <T extends Column> Select columns(List<T> columns) {
        return Select.columns(ColumnList.namesOf(columns));
    }

    public Select where(String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            ((Where)this.parts.get("where")).and(String.format("%s = ?", columns[i]));
        }
        return this;
    }

    public Select where(Condition condition) {
        CommonSQLConditionVisitor conditionVisitorImpl = new CommonSQLConditionVisitor();
        condition.accept(conditionVisitorImpl);
        String where = conditionVisitorImpl.toString();
        if (where.length() > 0) {
            ((Where)this.parts.get("where")).and(where);
        }
        return this;
    }

    public Select orderby(OrderBy orderby) {
        this.parts.put("orderby", orderby);
        return this;
    }

    public Select from(String table) {
        ((From)this.parts.get("from")).table(table);
        return this;
    }

    public Select from(String table, String alias) {
        ((From)this.parts.get("from")).tableWithAlias(table, alias);
        return this;
    }

    public Select addTableAlias(String alias) {
        ((From)this.parts.get("from")).addAlias(alias);
        return this;
    }

    public Select addColumns(String ... columns) {
        ((Columns)this.parts.get("columns")).add(columns);
        return this;
    }

    public Select replaceColumns(String ... columns) {
        ((Columns)this.parts.get("columns")).clear().add(columns);
        return this;
    }

    public Select count() {
        ((Rows)this.parts.get("rows")).clear();
        ((Columns)this.parts.get("columns")).count();
        return this;
    }

    public Select countDistinct(String column) {
        ((Rows)this.parts.get("rows")).clear();
        ((Columns)this.parts.get("columns")).countDistinct(column);
        return this;
    }

    public Select where(String expression) {
        ((Where)this.parts.get("where")).and(expression);
        return this;
    }

    public Select where(String column, int parametersCount) {
        ((Where)this.parts.get("where")).and(column, parametersCount);
        return this;
    }

    public Select orWhere(String expression) {
        ((Where)this.parts.get("where")).or(expression);
        return this;
    }

    public Select orWhere(String column, int parametersCount) {
        ((Where)this.parts.get("where")).or(column, parametersCount);
        return this;
    }

    public Select join(String table, String on) {
        ((Join)this.parts.get("join")).inner(table, on);
        return this;
    }

    public Select outerJoin(String table, String on) {
        ((Join)this.parts.get("join")).outer(table, on);
        return this;
    }

    public Select max(int max) {
        ((Rows)this.parts.get("rows")).max(max);
        return this;
    }

    public Select limit(int limit) {
        ((Rows)this.parts.get("rows")).countTo(limit);
        return this;
    }

    public Select offset(int offset) {
        ((Rows)this.parts.get("rows")).startingAt(offset);
        return this;
    }

    @Override
    public String toDemoSQL() {
        return String.format("SELECT %s FROM %s %s %s %s %s", this.parts.get("columns").toDemoSQL(), this.parts.get("from").toDemoSQL(), this.parts.get("join").toDemoSQL(), this.parts.get("where").toDemoSQL(), this.parts.get("orderby").toDemoSQL(), this.parts.get("rows").toDemoSQL()).trim().replaceAll("( )+", " ");
    }
}

