/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.builders.queries;

import cn.sj1.tinydb.dbal.jdbc.builders.HasSQLRepresentation;

class Rows
implements HasSQLRepresentation {
    private int limit;
    private int offset;

    private Rows() {
        this.clear();
    }

    static Rows all() {
        return new Rows();
    }

    void clear() {
        this.limit = -1;
        this.offset = -1;
    }

    void max(int max) {
        this.assertValueIsNotNegative("max", max);
        this.limit = max - this.offset + 1;
    }

    void countTo(int limit) {
        this.assertValueIsNotNegative("limit", limit);
        this.limit = limit;
    }

    void startingAt(int offset) {
        this.assertValueIsNotNegative("offset", offset);
        this.offset = offset;
    }

    private void assertValueIsNotNegative(String label, int value) {
        if (value >= 0) {
            return;
        }
        throw new IllegalArgumentException(String.format("%s cannot be negative", label));
    }

    @Override
    public String toDemoSQL() {
        return String.format("%s %s", this.limitToSQL(), this.offsetToSQL()).trim();
    }

    private String offsetToSQL() {
        if (this.offset < 0 || this.limit == 0) {
            return "";
        }
        return String.format("OFFSET %d", this.offset);
    }

    private String limitToSQL() {
        if (this.limit <= 0) {
            return "";
        }
        return String.format("LIMIT %d", this.limit);
    }
}

