/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.builders.queries;

import cn.sj1.tinydb.dbal.jdbc.builders.HasSQLRepresentation;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.Columns;
import cn.sj1.tinydb.dbal.jdbc.builders.queries.ParameterPlaceholders;

public class Insert
implements HasSQLRepresentation {
    private String table;
    private int valuesCount;
    private Columns columns;

    private Insert(String table) {
        this.table = table;
        this.columns = Columns.empty();
    }

    public static Insert into(String table) {
        return new Insert(table);
    }

    public Insert values(int valuesCount) {
        this.valuesCount = valuesCount;
        return this;
    }

    public Insert columns(String ... columns) {
        this.columns.add(columns);
        return this;
    }

    @Override
    public String toDemoSQL() {
        this.assertValuesArePresent();
        this.assertColumnsAndValuesMatch();
        return String.format("INSERT INTO %s %s %s", this.table, this.columnsToString(), this.valuesToString()).replaceAll("( )+", " ");
    }

    private void assertColumnsAndValuesMatch() {
        if (this.columns.size() > 0 && this.valuesCount() != this.columns.size()) {
            throw new IllegalStateException("Columns and values count do not match");
        }
    }

    private void assertValuesArePresent() {
        if (this.valuesCount() == 0) {
            throw new IllegalStateException("Cannot build INSERT without values");
        }
    }

    private String columnsToString() {
        if (this.columns.size() == 0) {
            return "";
        }
        return "(" + this.columns.toDemoSQL() + ")";
    }

    private String valuesToString() {
        return "VALUES " + ParameterPlaceholders.generate(this.valuesCount());
    }

    private int valuesCount() {
        if (this.valuesCount == 0) {
            this.valuesCount = this.columns.size();
        }
        return this.valuesCount;
    }
}

