/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.builders.queries;

import cn.sj1.tinydb.dbal.jdbc.builders.HasSQLRepresentation;

class From
implements HasSQLRepresentation {
    private String table;
    private String alias;

    private From(String table, String alias) {
        this.assertValidTableName(table);
        this.table = table;
        this.alias = alias;
    }

    private void assertValidTableName(String table) {
        if (table == null && this.alias == null) {
            return;
        }
        if (table != null && table.trim().length() > 0 && table.indexOf(32) == -1) {
            return;
        }
        throw new IllegalArgumentException("Invalid table name given");
    }

    From(From from) {
        this.table = from.table;
        this.alias = from.alias;
    }

    static From empty() {
        return new From(null, null);
    }

    From table(String table) {
        this.assertValidTableName(table);
        this.table = table;
        return this;
    }

    From tableWithAlias(String table, String alias) {
        this.table = table;
        this.alias = alias;
        return this;
    }

    void addAlias(String alias) {
        this.alias = alias;
    }

    String alias() {
        if (this.alias == null) {
            return Character.toString(this.table.charAt(0)).toLowerCase();
        }
        return this.alias;
    }

    @Override
    public String toDemoSQL() {
        return this.table + (this.alias == null ? "" : " " + this.alias);
    }
}

