/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc.builders.queries;

import cn.sj1.tinydb.dbal.jdbc.builders.HasSQLRepresentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class Columns
implements HasSQLRepresentation {
    private static final String ALL = "*";
    private List<String> columns;

    private Columns() {
        this.columns = new ArrayList<String>();
    }

    Columns(Columns columns) {
        this.columns = new ArrayList<String>(columns.columns);
    }

    public static Columns empty() {
        return new Columns();
    }

    public static Columns all() {
        return new Columns().add(ALL);
    }

    public Columns add(String ... columns) {
        Collections.addAll(this.columns, columns);
        return this;
    }

    public void count() {
        this.clear().add(String.format("COUNT(%s)", ALL));
    }

    public void countDistinct(String column) {
        this.clear().add(String.format("COUNT(DISTINCT %s)", column));
    }

    int size() {
        return this.columns.size();
    }

    Columns clear() {
        this.columns.clear();
        return this;
    }

    @Override
    public String toDemoSQL() {
        if (this.columns.isEmpty()) {
            this.columns.add(ALL);
        }
        return String.join((CharSequence)", ", this.columns.toArray(new String[0]));
    }
}

