/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.dbal.jdbc;

import cn.sj1.tinydb.dbal.jdbc.QueryParameters;
import cn.sj1.tinydb.dbal.jdbc.RowMapper;
import cn.sj1.tinydb.dbal.jdbc.builders.HasSQLRepresentation;
import cn.sj1.tinydb.dbal.jdbc.statements.InsertStatement;
import cn.sj1.tinydb.dbal.jdbc.statements.SQLError;
import cn.sj1.tinydb.dbal.jdbc.statements.SelectStatement;
import cn.sj1.tinydb.dbal.jdbc.statements.UpdateStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class Table<T> {
    private final Connection connection;

    public Table(Connection connection) {
        this.connection = connection;
    }

    protected InsertStatement<T> createInsert(String ... columns) {
        return new InsertStatement<T>(this.connection, this.table(), this.mapper()).columns(columns);
    }

    protected UpdateStatement createUpdate(String ... columns) {
        return new UpdateStatement(this.connection, this.table()).columns(columns);
    }

    protected SelectStatement<T> select(String ... columns) {
        return new SelectStatement<T>(this.connection, this.table(), this.mapper()).select(columns);
    }

    protected void executeUpdate(HasSQLRepresentation insertOrUpdate, Object ... parameters) {
        try (PreparedStatement statement = this.connection.prepareStatement(insertOrUpdate.toDemoSQL());){
            QueryParameters.bind(statement, parameters);
            statement.execute();
        }
        catch (SQLException e) {
            throw SQLError.producedBy(insertOrUpdate, parameters, e);
        }
    }

    protected abstract String table();

    protected abstract RowMapper<T> mapper();
}

