/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb.commons.list;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ListMap<K, T>
implements Iterable<T> {
    Stack<T> stack = new Stack();
    Map<K, T> maps = new HashMap<K, T>();
    protected Function<T, K> keyFunction;

    public ListMap(Function<T, K> keyFunction) {
        this.keyFunction = keyFunction;
    }

    public void push(T value) {
        K key = this.keyFunction.apply(value);
        if (this.maps.containsKey(key)) {
            for (int i = 0; i < this.stack.size(); ++i) {
                if (!key.equals(this.keyFunction.apply(this.stack.get(i)))) continue;
                this.stack.set(i, value);
                break;
            }
        } else {
            this.stack.push(value);
        }
        this.maps.put(this.keyFunction.apply(value), value);
    }

    public void push(List<T> values) {
        for (T t : values) {
            this.push(t);
        }
    }

    public T get(int index) {
        return (T)this.stack.get(index);
    }

    public T get(String name) {
        return this.maps.get(name);
    }

    public void remove(String name) {
        for (int i = 0; i < this.stack.size(); ++i) {
            if (!name.equals(this.keyFunction.apply(this.stack.get(i)))) continue;
            this.stack.remove(i);
            break;
        }
        this.maps.remove(name);
    }

    public boolean containsKey(String name) {
        return this.maps.containsKey(name);
    }

    public int size() {
        return this.stack.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.stack.iterator();
    }

    public List<T> list() {
        return this.stack;
    }

    public ListMap<K, T> filter(Predicate<? super T> predicate) {
        ListMap newlist = new ListMap(this.keyFunction);
        for (Object v : this.stack) {
            if (!predicate.test(v)) continue;
            newlist.push(v);
        }
        return newlist;
    }

    public boolean allMatch(Predicate<? super T> predicate) {
        return this.list().stream().allMatch(predicate);
    }

    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.list().stream().anyMatch(predicate);
    }

    public <R> List<R> map(Function<? super T, ? extends R> mapper) {
        return this.list().stream().map(mapper).collect(Collectors.toList());
    }

    public void foreach(Consumer<? super T> action) {
        this.list().stream().forEach(action);
    }

    public String toString() {
        return this.stack.toString();
    }
}

