/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb;

import cn.sj1.tinydb.CommonSQLConditionVisitor;
import cn.sj1.tinydb.Condition;
import cn.sj1.tinydb.ConditionBuilder;
import cn.sj1.tinydb.ConditionBuilderImpl;
import cn.sj1.tinydb.ConditionOp;
import cn.sj1.tinydb.LogicalConditionExpression;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

class WhereBuilder
implements ConditionBuilder<WhereBuilder> {
    ConditionBuilderImpl lastConditionBuilder = null;
    Condition lastCondition = null;

    WhereBuilder() {
    }

    public static WhereBuilder empty() {
        return new WhereBuilder();
    }

    public String toString() {
        CommonSQLConditionVisitor conditionVisitorImpl = new CommonSQLConditionVisitor();
        this.lastCondition.accept(conditionVisitorImpl);
        return conditionVisitorImpl.toString();
    }

    public ConditionBuilder<WhereBuilder> name(String name) {
        this.lastConditionBuilder = new ConditionBuilderImpl(name);
        return this;
    }

    public ConditionBuilder<WhereBuilder> and(String name) {
        this.lastConditionBuilder = new ConditionBuilderImpl(name);
        return this;
    }

    public WhereBuilder and(Condition right) {
        this.lastCondition = new LogicalConditionExpression(this.lastCondition, ConditionOp.AND, right);
        return this;
    }

    public WhereBuilder or(Condition right) {
        this.lastCondition = new LogicalConditionExpression(this.lastCondition, ConditionOp.OR, right);
        return this;
    }

    @Override
    public WhereBuilder condition(ConditionOp type) {
        this.lastCondition = this.lastConditionBuilder.condition(type);
        return this;
    }

    @Override
    public WhereBuilder condition(ConditionOp type, String value) {
        this.lastCondition = this.lastConditionBuilder.condition(type, value);
        return this;
    }

    @Override
    public WhereBuilder condition(ConditionOp type, int value) {
        this.lastCondition = this.lastConditionBuilder.condition(type, value);
        return this;
    }

    @Override
    public WhereBuilder condition(ConditionOp type, long value) {
        this.lastCondition = this.lastConditionBuilder.condition(type, value);
        return this;
    }

    @Override
    public WhereBuilder condition(ConditionOp type, Date value) {
        this.lastCondition = this.lastConditionBuilder.condition(type, value);
        return this;
    }

    @Override
    public WhereBuilder condition(ConditionOp type, Time value) {
        this.lastCondition = this.lastConditionBuilder.condition(type, value);
        return this;
    }

    @Override
    public WhereBuilder condition(ConditionOp type, Timestamp value) {
        this.lastCondition = this.lastConditionBuilder.condition(type, value);
        return this;
    }

    @Override
    public WhereBuilder conditionComplex(ConditionOp type, String ... value) {
        this.lastCondition = this.lastConditionBuilder.conditionComplex(type, value);
        return this;
    }

    @Override
    public WhereBuilder conditionComplex(ConditionOp type, int ... value) {
        this.lastCondition = this.lastConditionBuilder.conditionComplex(type, value);
        return this;
    }

    @Override
    public WhereBuilder conditionComplex(ConditionOp type, long ... value) {
        this.lastCondition = this.lastConditionBuilder.conditionComplex(type, value);
        return this;
    }

    @Override
    public WhereBuilder conditionComplex(ConditionOp type, Date ... value) {
        this.lastCondition = this.lastConditionBuilder.conditionComplex(type, value);
        return this;
    }

    @Override
    public WhereBuilder conditionComplex(ConditionOp type, Time ... value) {
        this.lastCondition = this.lastConditionBuilder.conditionComplex(type, value);
        return this;
    }

    @Override
    public WhereBuilder conditionComplex(ConditionOp type, Timestamp ... value) {
        this.lastCondition = this.lastConditionBuilder.conditionComplex(type, value);
        return this;
    }

    @Override
    public WhereBuilder between(String first, String second) {
        this.lastCondition = this.lastConditionBuilder.between(first, second);
        return this;
    }

    @Override
    public WhereBuilder between(int first, int second) {
        this.lastCondition = this.lastConditionBuilder.between(first, second);
        return this;
    }

    @Override
    public WhereBuilder between(long first, long second) {
        this.lastCondition = this.lastConditionBuilder.between(first, second);
        return this;
    }

    @Override
    public WhereBuilder between(Date first, Date second) {
        this.lastCondition = this.lastConditionBuilder.between(first, second);
        return this;
    }

    @Override
    public WhereBuilder between(Time first, Time second) {
        this.lastCondition = this.lastConditionBuilder.between(first, second);
        return this;
    }

    @Override
    public WhereBuilder between(Timestamp first, Timestamp second) {
        this.lastCondition = this.lastConditionBuilder.between(first, second);
        return this;
    }
}

