/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb;

import cn.sj1.tinydb.OrderByItem;
import cn.sj1.tinydb.OrderByOp;
import cn.sj1.tinydb.dbal.jdbc.builders.HasSQLRepresentation;
import java.util.ArrayList;
import java.util.List;

public class OrderBy
implements HasSQLRepresentation {
    List<OrderByItem> orderbys = new ArrayList<OrderByItem>();
    OrderByItem lastItem;

    public static OrderBy empty() {
        return new OrderBy();
    }

    public OrderBy asc() {
        this.lastItem.op = OrderByOp.ASC;
        return this;
    }

    public OrderBy desc() {
        this.lastItem.op = OrderByOp.DESC;
        return this;
    }

    public OrderBy orderBy(String name) {
        this.lastItem = new OrderByItem(name, OrderByOp.ASC);
        this.orderbys.add(this.lastItem);
        return this;
    }

    public OrderBy andOrderBy(String name, OrderByOp op) {
        this.lastItem = new OrderByItem(name, op);
        this.orderbys.add(this.lastItem);
        return this;
    }

    @Override
    public String toDemoSQL() {
        if (this.orderbys.size() > 0) {
            ArrayList<String> str = new ArrayList<String>();
            for (OrderByItem o : this.orderbys) {
                str.add(String.format(o.op.format, o.field));
            }
            return "ORDER BY " + String.join((CharSequence)", ", str);
        }
        return "";
    }

    public String toString() {
        return this.toDemoSQL();
    }
}

