/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb;

import cn.sj1.tinydb.Condition;
import cn.sj1.tinydb.ConditionBuilder;
import cn.sj1.tinydb.ConditionOp;
import cn.sj1.tinydb.DateBinaryConditionExpression;
import cn.sj1.tinydb.DateComplexConditionExpression;
import cn.sj1.tinydb.DateConditionExpression;
import cn.sj1.tinydb.IntBinaryConditionExpression;
import cn.sj1.tinydb.IntComplexConditionExpression;
import cn.sj1.tinydb.IntConditionExpression;
import cn.sj1.tinydb.LongBinaryConditionExpression;
import cn.sj1.tinydb.LongComplexConditionExpression;
import cn.sj1.tinydb.LongConditionExpression;
import cn.sj1.tinydb.SingleConditionExpression;
import cn.sj1.tinydb.StringBinaryConditionExpression;
import cn.sj1.tinydb.StringComplexConditionExpression;
import cn.sj1.tinydb.StringConditionExpression;
import cn.sj1.tinydb.TimeBinaryConditionExpression;
import cn.sj1.tinydb.TimeComplexConditionExpression;
import cn.sj1.tinydb.TimeConditionExpression;
import cn.sj1.tinydb.TimestampBinaryConditionExpression;
import cn.sj1.tinydb.TimestampComplexConditionExpression;
import cn.sj1.tinydb.TimestampConditionExpression;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class ConditionBuilderImpl
implements ConditionBuilder<Condition> {
    final String lastName;

    public ConditionBuilderImpl(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public Condition condition(ConditionOp type) {
        return new SingleConditionExpression(this.lastName, type);
    }

    @Override
    public Condition condition(ConditionOp type, String value) {
        return new StringConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition condition(ConditionOp type, int value) {
        return new IntConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition condition(ConditionOp type, long value) {
        return new LongConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition condition(ConditionOp type, Date value) {
        return new DateConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition condition(ConditionOp type, Time value) {
        return new TimeConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition condition(ConditionOp type, Timestamp value) {
        return new TimestampConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition conditionComplex(ConditionOp type, String ... value) {
        return new StringComplexConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition conditionComplex(ConditionOp type, int ... value) {
        return new IntComplexConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition conditionComplex(ConditionOp type, long ... value) {
        return new LongComplexConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition conditionComplex(ConditionOp type, Date ... value) {
        return new DateComplexConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition conditionComplex(ConditionOp type, Time ... value) {
        return new TimeComplexConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition conditionComplex(ConditionOp type, Timestamp ... value) {
        return new TimestampComplexConditionExpression(this.lastName, type, value);
    }

    @Override
    public Condition between(String first, String second) {
        return new StringBinaryConditionExpression(this.lastName, ConditionOp.BETWEEN, first, second);
    }

    @Override
    public Condition between(int first, int second) {
        return new IntBinaryConditionExpression(this.lastName, ConditionOp.BETWEEN, first, second);
    }

    @Override
    public Condition between(long first, long second) {
        return new LongBinaryConditionExpression(this.lastName, ConditionOp.BETWEEN, first, second);
    }

    @Override
    public Condition between(Date first, Date second) {
        return new DateBinaryConditionExpression(this.lastName, ConditionOp.BETWEEN, first, second);
    }

    @Override
    public Condition between(Time first, Time second) {
        return new TimeBinaryConditionExpression(this.lastName, ConditionOp.BETWEEN, first, second);
    }

    @Override
    public Condition between(Timestamp first, Timestamp second) {
        return new TimestampBinaryConditionExpression(this.lastName, ConditionOp.BETWEEN, first, second);
    }
}

