/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinydb;

import cn.sj1.tinydb.AcceptConditionVisitor;
import cn.sj1.tinydb.ConditionBuilder;
import cn.sj1.tinydb.ConditionBuilderImpl;
import cn.sj1.tinydb.ConditionBuilderWithLeft;
import cn.sj1.tinydb.ConditionOp;
import cn.sj1.tinydb.EmptyConditionExpression;
import cn.sj1.tinydb.LogicalConditionExpression;

public abstract class Condition
implements AcceptConditionVisitor {
    boolean simple = true;

    public boolean isSimple() {
        return this.simple;
    }

    public static Condition empty() {
        return new EmptyConditionExpression();
    }

    public static ConditionBuilder<Condition> field(String name) {
        return new ConditionBuilderImpl(name);
    }

    public ConditionBuilder<Condition> and(String name) {
        if (this instanceof EmptyConditionExpression) {
            return new ConditionBuilderImpl(name);
        }
        return new ConditionBuilderWithLeft(this, ConditionOp.AND, name);
    }

    public ConditionBuilder<Condition> or(String name) {
        if (this instanceof EmptyConditionExpression) {
            return new ConditionBuilderImpl(name);
        }
        return new ConditionBuilderWithLeft(this, ConditionOp.OR, name);
    }

    public Condition and(Condition right) {
        if (this instanceof EmptyConditionExpression) {
            return right;
        }
        return new LogicalConditionExpression(this, ConditionOp.AND, right);
    }

    public Condition or(Condition right) {
        if (this instanceof EmptyConditionExpression) {
            return right;
        }
        return new LogicalConditionExpression(this, ConditionOp.OR, right);
    }

    public static Condition and(Condition left, Condition right) {
        return new LogicalConditionExpression(left, ConditionOp.AND, right);
    }

    public static Condition or(Condition left, Condition right) {
        return new LogicalConditionExpression(left, ConditionOp.OR, right);
    }
}

