/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinyasm.tools;

import java.util.Iterator;
import java.util.Stack;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class TinyLocalsStack
implements Iterable<Var> {
    Stack<Var> stack = new Stack();
    Stack<Integer> locals = new Stack();

    TinyLocalsStack() {
    }

    public Var getByLocal(int index) {
        return (Var)this.stack.get((Integer)this.locals.get(index));
    }

    @Override
    public Iterator<Var> iterator() {
        return this.stack.iterator();
    }

    public Var accessLoad(int index, int size) {
        Var var;
        if (this.locals.size() > index) {
            int stackIndex = (Integer)this.locals.get(index);
            if (stackIndex >= 0) {
                var = (Var)this.stack.get(stackIndex);
            } else {
                stackIndex = this.stack.size();
                var = new Var(null, null);
                var.locals = index;
                this.stack.push(var);
                this.locals.set(index, stackIndex);
                for (int i = 1; i < size; ++i) {
                    this.locals.set(index + i, -i);
                }
            }
        } else {
            if (this.locals.size() < index) {
                for (int i = this.locals.size(); i < index; ++i) {
                    this.locals.push(-i);
                }
            }
            int stackIndex = this.stack.size();
            var = new Var(null, null);
            var.locals = index;
            this.locals.push(stackIndex);
            for (int i = 1; i < size; ++i) {
                this.locals.push(-i);
            }
            this.stack.push(var);
        }
        ++var.count;
        return var;
    }

    public Var accessStore(int index, int size) {
        Var var;
        if (this.locals.size() > index) {
            int stackIndex = (Integer)this.locals.get(index);
            if (stackIndex >= 0) {
                var = (Var)this.stack.get(stackIndex);
            } else {
                stackIndex = this.stack.size();
                var = new Var(null, null);
                var.locals = index;
                this.stack.push(var);
                this.locals.set(index, stackIndex);
                for (int i = 1; i < size; ++i) {
                    this.locals.set(index + i, -i);
                }
            }
        } else {
            if (this.locals.size() < index) {
                for (int i = this.locals.size(); i < index; ++i) {
                    this.locals.push(-i);
                }
            }
            int stackIndex = this.stack.size();
            var = new Var(null, null);
            var.locals = index;
            this.locals.push(stackIndex);
            for (int i = 1; i < size; ++i) {
                this.locals.push(-i);
            }
            this.stack.push(var);
        }
        ++var.count;
        return var;
    }

    public Var pushDefined(String name, Type clazz) {
        Var var = new Var(name, clazz);
        var.defined = true;
        return this.push(name, var);
    }

    public Var pushUndefined(String name) {
        return this.push(name, new Var(name, null));
    }

    private Var push(String name, Var var) {
        ++var.count;
        var.locals = this.locals.size();
        for (int i = 0; i < var.type.getSize(); ++i) {
            this.locals.push(this.stack.size());
        }
        this.stack.push(var);
        return var;
    }

    public Var push(String name, Type clazz, Label label) {
        Var var = new Var(name, clazz, label);
        return this.push(name, var);
    }

    public int size() {
        return this.locals.size();
    }

    public static class Var {
        int access;
        public Label startFrom;
        public Object value;
        Type type;
        String name;
        String signature = null;
        public int locals = 0;
        int count = 0;
        public boolean defined;

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public String getSignature() {
            return this.signature;
        }

        public Var(String name, Type type) {
            this(0, name, type);
        }

        public Var(int access, String name, Type type) {
            this.access = access;
            this.name = name;
            this.type = type;
        }

        public Var(String name, Type type, Label startFrom) {
            this(0, name, type);
            this.startFrom = startFrom;
        }

        public String toString() {
            return this.name != null && this.name.length() > 0 ? this.name : "var" + this.locals;
        }
    }
}

