/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinyasm.tools;

import cn.sj1.tinyasm.tools.ClassSignature;
import cn.sj1.tinyasm.tools.TinyLocalsStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.util.Printer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TinyASMifier
extends Printer {
    static Logger logger = LoggerFactory.getLogger(TinyASMifier.class);
    private static final String USAGE = "Prints the ASM code to generate the given class.\nUsage: ASMifier [-nodebug] <fully qualified class name or class file name>";
    private static final int ACCESS_CLASS = 262144;
    private static final int ACCESS_FIELD = 524288;
    private static final int ACCESS_INNER = 0x100000;
    private static final int ACCESS_MODULE = 0x200000;
    private static final String ANNOTATION_VISITOR = "annotationVisitor";
    private static final String ANNOTATION_VISITOR0 = "annotationVisitor0 = ";
    private static final String COMMA = "\", \"";
    private static final String END_ARRAY = " });\n";
    private static final String END_PARAMETERS = ");\n\n";
    private static final String NEW_OBJECT_ARRAY = ", new Object[] {";
    private static final String VISIT_END = ".visitEnd();\n";
    private static final List<String> FRAME_TYPES = Collections.unmodifiableList(Arrays.asList("Opcodes.TOP", "Opcodes.INTEGER", "Opcodes.FLOAT", "Opcodes.DOUBLE", "Opcodes.LONG", "Opcodes.NULL", "Opcodes.UNINITIALIZED_THIS"));
    private static final Map<Integer, String> CLASS_VERSIONS;
    protected final String visitname;
    protected final int id;
    protected Map<Label, String> labelNames;
    private Map<String, String> classDefinedClassParameters;
    private List<String> classDefinedClassParameterNames;
    private List<Object> classDefinedClassParameterClasses;
    String tiny_className;
    TinyLocalsStack tiny_methodLocals = new TinyLocalsStack();
    List<Object> tiny_textMethods = new ArrayList<Object>();
    DefineVariables tiny_defineVariables = new DefineVariables();
    Annotation tiny_annotation;
    Type[] tiny_methodParamTypes;
    private List<StringBuilder> tiny_methodSignatureParamClazzList;
    private List<StringBuilder> tiny_methodSignatureTypeParameterClassList;
    private StringBuilder tiny_methodSignatureReturnClass;
    Map<String, String> tiny_methodNames = new HashMap<String, String>();
    boolean tiny_methodIsStatic = false;
    boolean tiny_hasMakeParameters = false;
    int tiny_methodVisitParameter = 0;
    static Map<String, String> tiny_primativeTypeMaps;
    Map<String, String> tiny_referedTypes = new HashMap<String, String>();
    private Map<String, String> methodUsedClassParameters = new HashMap<String, String>();

    public TinyASMifier() {
        this(524288, "classBody", 0);
        this.classDefinedClassParameters = new HashMap<String, String>();
        if (((Object)((Object)this)).getClass() != TinyASMifier.class) {
            throw new IllegalStateException();
        }
        this.classDefinedClassParameters = new HashMap<String, String>();
        this.classDefinedClassParameterNames = new ArrayList<String>();
        this.classDefinedClassParameterClasses = new ArrayList<Object>();
    }

    public TinyASMifier(List<String> names, List<Object> classes) {
        this(524288, "classBody", 0);
        this.classDefinedClassParameters = new HashMap<String, String>();
        this.classDefinedClassParameterNames = new ArrayList<String>();
        this.classDefinedClassParameterClasses = new ArrayList<Object>();
        this.classDefinedClassParameterNames.addAll(names);
        this.classDefinedClassParameterClasses.addAll(classes);
        for (int i = 0; i < classes.size(); ++i) {
            if (classes.get(i) instanceof Class) {
                this.classDefinedClassParameters.put(((Class)classes.get(i)).getName(), names.get(i));
                continue;
            }
            if (!(classes.get(i) instanceof String)) continue;
            this.classDefinedClassParameters.put((String)classes.get(i), names.get(i));
        }
        if (((Object)((Object)this)).getClass() != TinyASMifier.class) {
            throw new IllegalStateException();
        }
    }

    protected TinyASMifier(int api, String visitorVariableName, int annotationVisitorId) {
        super(api);
        this.visitname = "\t\t" + visitorVariableName;
        this.id = annotationVisitorId;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.tiny_visit(access, name, signature, superName, interfaces);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitSource(String file, String debug) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classBody.visitSource(");
        this.appendConstant(file);
        this.stringBuilder.append(", ");
        this.appendConstant(debug);
        this.stringBuilder.append(END_PARAMETERS);
    }

    public Printer visitModule(String name, int flags, String version) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("ModuleVisitor moduleVisitor = classBody.visitModule(");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(flags | 0x200000);
        this.stringBuilder.append(", ");
        this.appendConstant(version);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
        TinyASMifier asmifier = this.createASMifier("moduleVisitor", 0);
        asmifier.tiny_methodLocals = this.tiny_methodLocals;
        asmifier.tiny_methodVisitParameter = this.tiny_methodVisitParameter;
        asmifier.tiny_methodParamTypes = this.tiny_methodParamTypes;
        asmifier.tiny_methodSignatureParamClazzList = this.tiny_methodSignatureParamClazzList;
        asmifier.tiny_methodSignatureTypeParameterClassList = this.tiny_methodSignatureTypeParameterClassList;
        asmifier.tiny_methodIsStatic = this.tiny_methodIsStatic;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_referedTypes = this.tiny_referedTypes;
        asmifier.classDefinedClassParameters = this.classDefinedClassParameters;
        asmifier.methodUsedClassParameters = this.methodUsedClassParameters;
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    public void visitNestHost(String nestHost) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classBody.visitNestHost(");
        this.appendConstant(nestHost);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitOuterClass(String owner, String name, String descriptor) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classBody.visitOuterClass(");
        this.appendConstant(owner);
        this.stringBuilder.append(", ");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    public TinyASMifier visitClassAnnotation(String descriptor, boolean visible) {
        return this.visitAnnotation(descriptor, visible);
    }

    public TinyASMifier visitClassTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
    }

    public void visitClassAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitNestMember(String nestMember) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classBody.visitNestMember(");
        this.appendConstant(nestMember);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("\t\tclassBody.referInnerClass(");
        this.appendAccessFlags(access | 0x100000);
        this.stringBuilder.append(", ");
        this.appendConstant(outerName.replace('/', '.'));
        this.stringBuilder.append(", ");
        this.appendConstant(innerName);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    public TinyASMifier visitRecordComponent(String name, String descriptor, String signature) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("recordComponentVisitor = classBody.visitRecordComponent(");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ");
        this.appendConstant(signature);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        TinyASMifier asmifier = this.createASMifier("recordComponentVisitor", 0);
        asmifier.tiny_methodLocals = this.tiny_methodLocals;
        asmifier.tiny_methodVisitParameter = this.tiny_methodVisitParameter;
        asmifier.tiny_methodParamTypes = this.tiny_methodParamTypes;
        asmifier.tiny_methodSignatureParamClazzList = this.tiny_methodSignatureParamClazzList;
        asmifier.tiny_methodSignatureTypeParameterClassList = this.tiny_methodSignatureTypeParameterClassList;
        asmifier.tiny_methodIsStatic = this.tiny_methodIsStatic;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_referedTypes = this.tiny_referedTypes;
        asmifier.classDefinedClassParameters = this.classDefinedClassParameters;
        asmifier.methodUsedClassParameters = this.methodUsedClassParameters;
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    public TinyASMifier visitField(int access, String name, String descriptor, String signature, Object value) {
        TinyASMifier asmifier = this.tiny_visitField(access, name, descriptor, signature);
        return asmifier;
    }

    public Printer visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.tiny_methodSignatureParamClazzList = null;
        this.tiny_methodSignatureTypeParameterClassList = null;
        this.tiny_methodSignatureReturnClass = null;
        this.methodUsedClassParameters = new HashMap<String, String>();
        this.tiny_visitMethod(access, name, descriptor, signature, exceptions);
        TinyASMifier asmifier = this.createASMifier("code", 0);
        asmifier.tiny_methodLocals = this.tiny_methodLocals;
        asmifier.tiny_methodVisitParameter = this.tiny_methodVisitParameter;
        asmifier.tiny_methodParamTypes = this.tiny_methodParamTypes;
        asmifier.tiny_methodSignatureParamClazzList = this.tiny_methodSignatureParamClazzList;
        asmifier.tiny_methodSignatureTypeParameterClassList = this.tiny_methodSignatureTypeParameterClassList;
        asmifier.tiny_methodIsStatic = this.tiny_methodIsStatic;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_referedTypes = this.tiny_referedTypes;
        asmifier.classDefinedClassParameters = this.classDefinedClassParameters;
        asmifier.methodUsedClassParameters = this.methodUsedClassParameters;
        asmifier.classDefinedClassParameterNames = this.classDefinedClassParameterNames;
        asmifier.classDefinedClassParameterClasses = this.classDefinedClassParameterClasses;
        this.tiny_textMethods.add(asmifier.getText());
        this.tiny_textMethods.add("\n\t\tcode.END();\n\t}\n\n");
        return asmifier;
    }

    public void visitClassEnd() {
        this.text.add("\n");
        this.text.add("\t\treturn classBody.end().toByteArray();\n");
        this.text.add("\t}\n\n");
        this.text.add(this.tiny_textMethods);
        this.text.add("}\n");
    }

    public void visitMainClass(String mainClass) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitMainClass(");
        this.appendConstant(mainClass);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitPackage(String packaze) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitPackage(");
        this.appendConstant(packaze);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitRequire(String module, int access, String version) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitRequire(");
        this.appendConstant(module);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(access | 0x200000);
        this.stringBuilder.append(", ");
        this.appendConstant(version);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitExport(String packaze, int access, String ... modules) {
        this.visitExportOrOpen("moduleVisitor.visitExport(", packaze, access, modules);
    }

    public void visitOpen(String packaze, int access, String ... modules) {
        this.visitExportOrOpen("moduleVisitor.visitOpen(", packaze, access, modules);
    }

    private void visitExportOrOpen(String visitMethod, String packaze, int access, String ... modules) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(visitMethod);
        this.appendConstant(packaze);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(access | 0x200000);
        if (modules != null && modules.length > 0) {
            this.stringBuilder.append(", new String[] {");
            for (int i = 0; i < modules.length; ++i) {
                this.stringBuilder.append(i == 0 ? " " : ", ");
                this.appendConstant(modules[i]);
            }
            this.stringBuilder.append(" }");
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitUse(String service) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitUse(");
        this.appendConstant(service);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitProvide(String service, String ... providers) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitProvide(");
        this.appendConstant(service);
        this.stringBuilder.append(",  new String[] {");
        for (int i = 0; i < providers.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ");
            this.appendConstant(providers[i]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitModuleEnd() {
    }

    public void visit(String name, Object value) {
        this.tiny_annotation.keys.add(name);
        this.stringBuilder.setLength(0);
        this.appendConstant(value);
        this.tiny_annotation.values.add(this.stringBuilder.toString());
    }

    public void visitEnum(String name, String descriptor, String value) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(ANNOTATION_VISITOR).append(this.id).append(".visitEnum(");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ");
        this.appendConstant(value);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public TinyASMifier visitAnnotation(String name, String descriptor) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append("AnnotationVisitor annotationVisitor").append(this.id + 1).append(" = annotationVisitor");
        this.stringBuilder.append(this.id).append(".visitAnnotation(");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        TinyASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, this.id + 1);
        asmifier.tiny_annotation = this.tiny_annotation;
        asmifier.tiny_methodLocals = this.tiny_methodLocals;
        asmifier.tiny_methodVisitParameter = this.tiny_methodVisitParameter;
        asmifier.tiny_methodParamTypes = this.tiny_methodParamTypes;
        asmifier.tiny_methodSignatureParamClazzList = this.tiny_methodSignatureParamClazzList;
        asmifier.tiny_methodSignatureTypeParameterClassList = this.tiny_methodSignatureTypeParameterClassList;
        asmifier.tiny_methodIsStatic = this.tiny_methodIsStatic;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_referedTypes = this.tiny_referedTypes;
        asmifier.classDefinedClassParameters = this.classDefinedClassParameters;
        asmifier.methodUsedClassParameters = this.methodUsedClassParameters;
        asmifier.classDefinedClassParameterNames = this.classDefinedClassParameterNames;
        asmifier.classDefinedClassParameterClasses = this.classDefinedClassParameterClasses;
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    public TinyASMifier visitArray(String name) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("AnnotationVisitor annotationVisitor").append(this.id + 1).append(" = annotationVisitor");
        this.stringBuilder.append(this.id).append(".visitArray(");
        this.appendConstant(name);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        TinyASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, this.id + 1);
        asmifier.tiny_annotation = this.tiny_annotation;
        asmifier.tiny_methodLocals = this.tiny_methodLocals;
        asmifier.tiny_methodVisitParameter = this.tiny_methodVisitParameter;
        asmifier.tiny_methodParamTypes = this.tiny_methodParamTypes;
        asmifier.tiny_methodSignatureParamClazzList = this.tiny_methodSignatureParamClazzList;
        asmifier.tiny_methodSignatureTypeParameterClassList = this.tiny_methodSignatureTypeParameterClassList;
        asmifier.tiny_methodIsStatic = this.tiny_methodIsStatic;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_referedTypes = this.tiny_referedTypes;
        asmifier.classDefinedClassParameters = this.classDefinedClassParameters;
        asmifier.methodUsedClassParameters = this.methodUsedClassParameters;
        asmifier.classDefinedClassParameterNames = this.classDefinedClassParameterNames;
        asmifier.classDefinedClassParameterClasses = this.classDefinedClassParameterClasses;
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    public void visitAnnotationEnd() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(ANNOTATION_VISITOR).append(this.id).append(VISIT_END);
    }

    public TinyASMifier visitRecordComponentAnnotation(String descriptor, boolean visible) {
        return this.visitAnnotation(descriptor, visible);
    }

    public TinyASMifier visitRecordComponentTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
    }

    public void visitRecordComponentAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitRecordComponentEnd() {
        this.visitMemberEnd();
    }

    public TinyASMifier visitFieldAnnotation(String descriptor, boolean visible) {
        return this.visitAnnotation(descriptor, visible);
    }

    public TinyASMifier visitFieldTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
    }

    public void visitFieldAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitFieldEnd() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.visitname).append(VISIT_END);
    }

    public void visitParameter(String parameterName, int access) {
        TinyLocalsStack.Var var = (TinyLocalsStack.Var)this.tiny_methodLocals.stack.get(this.tiny_methodVisitParameter);
        var.name = parameterName;
        var.access = access;
        ++this.tiny_methodVisitParameter;
    }

    public TinyASMifier visitAnnotationDefault() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.visitname).append(".visitAnnotationDefault();\n");
        this.text.add(this.stringBuilder.toString());
        TinyASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(asmifier.getText());
        asmifier.tiny_annotation = this.tiny_annotation;
        asmifier.tiny_methodLocals = this.tiny_methodLocals;
        asmifier.tiny_methodVisitParameter = this.tiny_methodVisitParameter;
        asmifier.tiny_methodParamTypes = this.tiny_methodParamTypes;
        asmifier.tiny_methodSignatureParamClazzList = this.tiny_methodSignatureParamClazzList;
        asmifier.tiny_methodSignatureTypeParameterClassList = this.tiny_methodSignatureTypeParameterClassList;
        asmifier.tiny_methodIsStatic = this.tiny_methodIsStatic;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_referedTypes = this.tiny_referedTypes;
        asmifier.classDefinedClassParameters = this.classDefinedClassParameters;
        asmifier.methodUsedClassParameters = this.methodUsedClassParameters;
        asmifier.classDefinedClassParameterNames = this.classDefinedClassParameterNames;
        asmifier.classDefinedClassParameterClasses = this.classDefinedClassParameterClasses;
        this.text.add("}\n");
        return asmifier;
    }

    public TinyASMifier visitMethodAnnotation(String descriptor, boolean visible) {
        return this.visitAnnotation(descriptor, visible);
    }

    public TinyASMifier visitMethodTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
    }

    public TinyASMifier visitAnnotableParameterCount(int parameterCount, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.visitname).append(".visitAnnotableParameterCount(").append(parameterCount).append(", ").append(visible).append(");\n");
        this.text.add(this.stringBuilder.toString());
        return this;
    }

    public TinyASMifier visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.visitname).append(".visitParameterAnnotation(").append(parameter).append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ").append(visible).append(");\n");
        this.text.add(this.stringBuilder.toString());
        TinyASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        asmifier.tiny_annotation = this.tiny_annotation;
        asmifier.tiny_methodLocals = this.tiny_methodLocals;
        asmifier.tiny_methodVisitParameter = this.tiny_methodVisitParameter;
        asmifier.tiny_methodParamTypes = this.tiny_methodParamTypes;
        asmifier.tiny_methodSignatureParamClazzList = this.tiny_methodSignatureParamClazzList;
        asmifier.tiny_methodSignatureTypeParameterClassList = this.tiny_methodSignatureTypeParameterClassList;
        asmifier.tiny_methodIsStatic = this.tiny_methodIsStatic;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_referedTypes = this.tiny_referedTypes;
        asmifier.classDefinedClassParameters = this.classDefinedClassParameters;
        asmifier.methodUsedClassParameters = this.methodUsedClassParameters;
        asmifier.classDefinedClassParameterNames = this.classDefinedClassParameterNames;
        asmifier.classDefinedClassParameterClasses = this.classDefinedClassParameterClasses;
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    public void visitMethodAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitCode() {
        this.makeParameters();
        this.text.add(this.tiny_defineVariables);
    }

    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
    }

    public void visitInsn(int opcode) {
        this.tiny_visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.tiny_visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.tiny_visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String type) {
        this.tiny_visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.tiny_visitFieldInsn(opcode, owner, name, descriptor);
    }

    @Deprecated
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
        if (this.api >= 524288) {
            super.visitMethodInsn(opcode, owner, name, descriptor);
            return;
        }
        this.doVisitMethodInsn(opcode, owner, name, descriptor, opcode == 185);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        if (this.api < 524288) {
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            return;
        }
        this.doVisitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    private void doVisitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.tiny_doVisitMethodInsn(opcode, owner, name, descriptor);
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        Type resideClazz = Type.getMethodType((String)descriptor).getReturnType();
        Handle lamdaHandle = (Handle)bootstrapMethodArguments[1];
        Type typedyncMethodType = (Type)bootstrapMethodArguments[0];
        Type lamdaMethodType = Type.getMethodType((String)lamdaHandle.getDesc());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.visitname).append(".DYNAMIC(");
        if (!this.tiny_className.equals(lamdaHandle.getOwner())) {
            this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)lamdaHandle.getOwner()), this.tiny_referedTypes));
            this.stringBuilder.append(", ");
        }
        this.appendConstant(lamdaHandle.getName());
        this.stringBuilder.append(")");
        if (lamdaHandle.getTag() == 7) {
            this.stringBuilder.append(".withThis()");
            this.stringBuilder.append("\n\t\t\t\t");
        }
        for (Type typeParam : lamdaMethodType.getArgumentTypes()) {
            this.stringBuilder.append(".parameter(");
            this.stringBuilder.append(this.clazzOf(typeParam, this.tiny_referedTypes));
            this.stringBuilder.append(")");
        }
        this.stringBuilder.append(".return_(");
        this.stringBuilder.append(this.clazzOf(lamdaMethodType.getReturnType(), this.tiny_referedTypes));
        this.stringBuilder.append(")");
        this.stringBuilder.append("\n\t\t\t\t");
        this.stringBuilder.append(".LAMBDA(");
        this.stringBuilder.append(this.clazzOf(resideClazz, this.tiny_referedTypes));
        this.stringBuilder.append(", ");
        this.appendConstant(name);
        this.stringBuilder.append(")");
        for (Type typeParam : typedyncMethodType.getArgumentTypes()) {
            this.stringBuilder.append(".parameter(");
            this.stringBuilder.append(this.clazzOf(typeParam, this.tiny_referedTypes));
            this.stringBuilder.append(")");
        }
        this.stringBuilder.append(".return_(");
        this.stringBuilder.append(this.clazzOf(typedyncMethodType.getReturnType(), this.tiny_referedTypes));
        this.stringBuilder.append(")");
        this.stringBuilder.append("\n\t\t\t\t");
        this.stringBuilder.append(".INVOKE();\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.tiny_visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        if (this.labelNames != null && this.labelNames.containsKey(label)) {
            this.stringBuilder.setLength(0);
            this.stringBuilder.append("\n");
            this.stringBuilder.append(this.visitname).append(".visitLabel(");
            this.appendLabel(label);
            this.stringBuilder.append(");\n");
            this.text.add(this.stringBuilder.toString());
        } else {
            if (this.labelNames == null) {
                this.labelNames = new HashMap<Label, String>();
            }
            this.text.add(new LabelHolder(label, false));
            this.labelNames.put(label, "");
        }
    }

    public void visitLdcInsn(Object value) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.visitname).append(".LOADConst(");
        this.appendConstant(value);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitIincInsn(int var, int increment) {
        TinyLocalsStack.Var localVar = null;
        localVar = this.tiny_methodLocals.accessLoad(var, 1);
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.visitname).append(".IINC(\"");
        this.text.add(this.stringBuilder.toString());
        this.text.add(localVar);
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("\", ").append(increment).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.stringBuilder.setLength(0);
        for (Label label : labels) {
            this.declareLabel(label);
        }
        this.declareLabel(dflt);
        this.stringBuilder.append(this.visitname).append(".visitTableSwitchInsn(").append(min).append(", ").append(max).append(", ");
        this.appendLabel(dflt);
        this.stringBuilder.append(", new Label[] {");
        for (int i = 0; i < labels.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ");
            this.appendLabel(labels[i]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        int i;
        this.stringBuilder.setLength(0);
        for (Label label : labels) {
            this.declareLabel(label);
        }
        this.declareLabel(dflt);
        this.stringBuilder.append(this.visitname).append(".visitLookupSwitchInsn(");
        this.appendLabel(dflt);
        this.stringBuilder.append(", new int[] {");
        for (i = 0; i < keys.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ").append(keys[i]);
        }
        this.stringBuilder.append(" }, new Label[] {");
        for (i = 0; i < labels.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ");
            this.appendLabel(labels[i]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.visitname).append(".visitMultiANewArrayInsn(");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ").append(numDimensions).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public TinyASMifier visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation("visitInsnAnnotation", typeRef, typePath, descriptor, visible);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.stringBuilder.setLength(0);
        this.declareLabel(start);
        this.declareLabel(end);
        this.declareLabel(handler);
        this.stringBuilder.append(this.visitname).append(".visitTryCatchBlock(");
        this.appendLabel(start);
        this.stringBuilder.append(", ");
        this.appendLabel(end);
        this.stringBuilder.append(", ");
        this.appendLabel(handler);
        this.stringBuilder.append(", ");
        this.appendConstant(type);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public TinyASMifier visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation("visitTryCatchAnnotation", typeRef, typePath, descriptor, visible);
    }

    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        if (index < this.tiny_methodLocals.size()) {
            TinyLocalsStack.Var var = this.tiny_methodLocals.getByLocal(index);
            var.name = name;
            if (signature == null) {
                var.type = Type.getType((String)descriptor);
            } else {
                SignatureReader sr = new SignatureReader(signature);
                ClassSignature signatureVistor = index <= 1 && this.tiny_className.equals(Type.getType((String)descriptor).getInternalName()) ? new ClassSignature(this.api, this.classDefinedClassParameters, new HashMap<String, String>(), this.tiny_referedTypes) : new ClassSignature(this.api, this.classDefinedClassParameters, this.methodUsedClassParameters, this.tiny_referedTypes);
                sr.accept((SignatureVisitor)signatureVistor);
                logger.trace("visitLocalVariable({} {}", (Object)name, (Object)signatureVistor.superClass);
                var.setSignature(signatureVistor.superClass.toString());
            }
        }
    }

    public Printer visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        int i;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.visitname).append(".visitLocalVariableAnnotation(").append(typeRef);
        if (typePath == null) {
            this.stringBuilder.append(", null, ");
        } else {
            this.stringBuilder.append(", TypePath.fromString(\"").append(typePath).append("\"), ");
        }
        this.stringBuilder.append("new Label[] {");
        for (i = 0; i < start.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ");
            this.appendLabel(start[i]);
        }
        this.stringBuilder.append(" }, new Label[] {");
        for (i = 0; i < end.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ");
            this.appendLabel(end[i]);
        }
        this.stringBuilder.append(" }, new int[] {");
        for (i = 0; i < index.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ").append(index[i]);
        }
        this.stringBuilder.append(" }, ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ").append(visible).append(");\n");
        this.text.add(this.stringBuilder.toString());
        TinyASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        asmifier.tiny_annotation = this.tiny_annotation;
        asmifier.tiny_methodLocals = this.tiny_methodLocals;
        asmifier.tiny_methodVisitParameter = this.tiny_methodVisitParameter;
        asmifier.tiny_methodParamTypes = this.tiny_methodParamTypes;
        asmifier.tiny_methodSignatureParamClazzList = this.tiny_methodSignatureParamClazzList;
        asmifier.tiny_methodSignatureTypeParameterClassList = this.tiny_methodSignatureTypeParameterClassList;
        asmifier.tiny_methodIsStatic = this.tiny_methodIsStatic;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_referedTypes = this.tiny_referedTypes;
        asmifier.classDefinedClassParameters = this.classDefinedClassParameters;
        asmifier.methodUsedClassParameters = this.methodUsedClassParameters;
        asmifier.classDefinedClassParameterNames = this.classDefinedClassParameterNames;
        asmifier.classDefinedClassParameterClasses = this.classDefinedClassParameterClasses;
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    public void visitLineNumber(int line, Label start) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("\n");
        this.stringBuilder.append(this.visitname).append(".LINE(");
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.visitname).append(".visitMaxs(").append(maxStack).append(", ").append(maxLocals).append(");\n");
    }

    public void visitMethodEnd() {
        this.tiny_visitMethodEnd();
    }

    public TinyASMifier visitAnnotation(String descriptor, boolean visible) {
        this.tiny_annotation.clazz = this.clazzof(descriptor);
        this.tiny_annotation.visible = visible;
        TinyASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        asmifier.tiny_annotation = this.tiny_annotation;
        asmifier.tiny_methodLocals = this.tiny_methodLocals;
        asmifier.tiny_methodVisitParameter = this.tiny_methodVisitParameter;
        asmifier.tiny_methodParamTypes = this.tiny_methodParamTypes;
        asmifier.tiny_methodSignatureParamClazzList = this.tiny_methodSignatureParamClazzList;
        asmifier.tiny_methodSignatureTypeParameterClassList = this.tiny_methodSignatureTypeParameterClassList;
        asmifier.tiny_methodIsStatic = this.tiny_methodIsStatic;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_referedTypes = this.tiny_referedTypes;
        asmifier.classDefinedClassParameters = this.classDefinedClassParameters;
        asmifier.methodUsedClassParameters = this.methodUsedClassParameters;
        asmifier.classDefinedClassParameterNames = this.classDefinedClassParameterNames;
        asmifier.classDefinedClassParameterClasses = this.classDefinedClassParameterClasses;
        return asmifier;
    }

    public TinyASMifier visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation("visitTypeAnnotation", typeRef, typePath, descriptor, visible);
    }

    public TinyASMifier visitTypeAnnotation(String method, int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.visitname).append(".").append(method).append("(").append(typeRef);
        if (typePath == null) {
            this.stringBuilder.append(", null, ");
        } else {
            this.stringBuilder.append(", TypePath.fromString(\"").append(typePath).append("\"), ");
        }
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ").append(visible).append(");\n");
        this.text.add(this.stringBuilder.toString());
        TinyASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        asmifier.tiny_annotation = this.tiny_annotation;
        asmifier.tiny_methodLocals = this.tiny_methodLocals;
        asmifier.tiny_methodVisitParameter = this.tiny_methodVisitParameter;
        asmifier.tiny_methodParamTypes = this.tiny_methodParamTypes;
        asmifier.tiny_methodSignatureParamClazzList = this.tiny_methodSignatureParamClazzList;
        asmifier.tiny_methodSignatureTypeParameterClassList = this.tiny_methodSignatureTypeParameterClassList;
        asmifier.tiny_methodIsStatic = this.tiny_methodIsStatic;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_referedTypes = this.tiny_referedTypes;
        asmifier.classDefinedClassParameters = this.classDefinedClassParameters;
        asmifier.methodUsedClassParameters = this.methodUsedClassParameters;
        asmifier.classDefinedClassParameterNames = this.classDefinedClassParameterNames;
        asmifier.classDefinedClassParameterClasses = this.classDefinedClassParameterClasses;
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    public void visitAttribute(Attribute attribute) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("// ATTRIBUTE ").append(attribute.type).append("\n");
    }

    private void visitMemberEnd() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.visitname).append(VISIT_END);
        this.text.add(this.stringBuilder.toString());
    }

    protected TinyASMifier createASMifier(String visitorVariableName, int annotationVisitorId) {
        return new TinyASMifier(this.api, visitorVariableName, annotationVisitorId);
    }

    private void appendAccessFlags(int accessFlags) {
        boolean isEmpty = true;
        if ((accessFlags & 1) != 0) {
            this.stringBuilder.append("ACC_PUBLIC");
            isEmpty = false;
        }
        if ((accessFlags & 2) != 0) {
            this.stringBuilder.append("ACC_PRIVATE");
            isEmpty = false;
        }
        if ((accessFlags & 4) != 0) {
            this.stringBuilder.append("ACC_PROTECTED");
            isEmpty = false;
        }
        if ((accessFlags & 0x10) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            if ((accessFlags & 0x200000) == 0) {
                this.stringBuilder.append("ACC_FINAL");
            } else {
                this.stringBuilder.append("ACC_TRANSITIVE");
            }
            isEmpty = false;
        }
        if ((accessFlags & 8) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_STATIC");
            isEmpty = false;
        }
        if ((accessFlags & 0x20) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            if ((accessFlags & 0x40000) == 0) {
                if ((accessFlags & 0x200000) == 0) {
                    this.stringBuilder.append("ACC_SYNCHRONIZED");
                } else {
                    this.stringBuilder.append("ACC_TRANSITIVE");
                }
            } else {
                this.stringBuilder.append("ACC_SUPER");
            }
            isEmpty = false;
        }
        if ((accessFlags & 0x40) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            if ((accessFlags & 0x80000) == 0) {
                if ((accessFlags & 0x200000) == 0) {
                    this.stringBuilder.append("ACC_BRIDGE");
                } else {
                    this.stringBuilder.append("ACC_STATIC_PHASE");
                }
            } else {
                this.stringBuilder.append("ACC_VOLATILE");
            }
            isEmpty = false;
        }
        if ((accessFlags & 0x80) != 0 && (accessFlags & 0xC0000) == 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_VARARGS");
            isEmpty = false;
        }
        if ((accessFlags & 0x80) != 0 && (accessFlags & 0x80000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_TRANSIENT");
            isEmpty = false;
        }
        if ((accessFlags & 0x100) != 0 && (accessFlags & 0xC0000) == 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_NATIVE");
            isEmpty = false;
        }
        if ((accessFlags & 0x4000) != 0 && (accessFlags & 0x1C0000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ENUM");
            isEmpty = false;
        }
        if ((accessFlags & 0x2000) != 0 && (accessFlags & 0x140000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ANNOTATION");
            isEmpty = false;
        }
        if ((accessFlags & 0x400) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ABSTRACT");
            isEmpty = false;
        }
        if ((accessFlags & 0x200) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_INTERFACE");
            isEmpty = false;
        }
        if ((accessFlags & 0x800) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_STRICT");
            isEmpty = false;
        }
        if ((accessFlags & 0x1000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_SYNTHETIC");
            isEmpty = false;
        }
        if ((accessFlags & 0x20000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_DEPRECATED");
            isEmpty = false;
        }
        if ((accessFlags & 0x10000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_RECORD");
            isEmpty = false;
        }
        if ((accessFlags & 0x8000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            if ((accessFlags & 0x40000) == 0) {
                this.stringBuilder.append("ACC_MANDATED");
            } else {
                this.stringBuilder.append("ACC_MODULE");
            }
            isEmpty = false;
        }
        if (isEmpty) {
            this.stringBuilder.append('0');
        }
    }

    public String appendTypeConstant(Type type, Map<String, String> referedTypes) {
        if (type.getSort() == 10) {
            logger.trace("clazzOf - {} ", (Object)type.getClassName());
            if (this.classDefinedClassParameters != null && this.classDefinedClassParameters.containsKey(type.getClassName())) {
                logger.trace("clazzOf - {} is in paramter {}", (Object)type.getClassName(), (Object)this.classDefinedClassParameters.get(type.getClassName()));
                this.methodUsedClassParameters.put(type.getClassName(), this.classDefinedClassParameters.get(type.getClassName()));
                this.stringBuilder.append("Type.getType(");
                this.stringBuilder.append(this.classDefinedClassParameters.get(type.getClassName()));
                this.stringBuilder.append(")");
            } else if (tiny_primativeTypeMaps.containsKey(type.getInternalName())) {
                this.stringBuilder.append("Type.getType(\"");
                this.stringBuilder.append(tiny_primativeTypeMaps.get(type.getInternalName()));
                this.stringBuilder.append("\")");
            } else if (type.getSort() == 9 && type.getElementType().getSort() == 10) {
                this.stringBuilder.append("Type.getType(\"");
                logger.trace("{} Array", (Object)type.getElementType());
                referedTypes.put(type.getElementType().getClassName(), "");
                this.stringBuilder.append(TinyASMifier.toSimpleName(type.getElementType().getClassName()) + "[].class");
                this.stringBuilder.append("\")");
            } else if (type.getSort() == 10) {
                referedTypes.put(type.getClassName(), "");
                this.stringBuilder.append("Type.getType(");
                this.stringBuilder.append(TinyASMifier.toSimpleName(type.getClassName()) + ".class");
                this.stringBuilder.append(")");
            }
            return "unknown.class";
        }
        this.stringBuilder.append("Type.getType(");
        this.stringBuilder.append(type.getDescriptor());
        this.stringBuilder.append(")");
        return "unknown.class";
    }

    protected void appendConstant(Object value) {
        if (value == null) {
            this.stringBuilder.append("null");
        } else if (value instanceof String) {
            TinyASMifier.appendString((StringBuilder)this.stringBuilder, (String)((String)value));
        } else if (value instanceof Type) {
            this.appendTypeConstant((Type)value, this.tiny_referedTypes);
        } else if (value instanceof Handle) {
            this.stringBuilder.append("new Handle(");
            Handle handle = (Handle)value;
            this.stringBuilder.append("Opcodes.").append(HANDLE_TAG[handle.getTag()]).append(", \"");
            this.stringBuilder.append(handle.getOwner()).append(COMMA);
            this.stringBuilder.append(handle.getName()).append(COMMA);
            this.stringBuilder.append(handle.getDesc()).append("\", ");
            this.stringBuilder.append(handle.isInterface()).append(")");
        } else if (value instanceof ConstantDynamic) {
            this.stringBuilder.append("new ConstantDynamic(\"");
            ConstantDynamic constantDynamic = (ConstantDynamic)value;
            this.stringBuilder.append(constantDynamic.getName()).append(COMMA);
            this.stringBuilder.append(constantDynamic.getDescriptor()).append("\", ");
            this.appendConstant(constantDynamic.getBootstrapMethod());
            this.stringBuilder.append(NEW_OBJECT_ARRAY);
            int bootstrapMethodArgumentCount = constantDynamic.getBootstrapMethodArgumentCount();
            for (int i = 0; i < bootstrapMethodArgumentCount; ++i) {
                this.appendConstant(constantDynamic.getBootstrapMethodArgument(i));
                if (i == bootstrapMethodArgumentCount - 1) continue;
                this.stringBuilder.append(", ");
            }
            this.stringBuilder.append("})");
        } else if (value instanceof Byte) {
            this.stringBuilder.append("Byte.valueOf((byte)").append(value).append(')');
        } else if (value instanceof Boolean) {
            this.stringBuilder.append((Boolean)value != false ? "Boolean.TRUE" : "Boolean.FALSE");
        } else if (value instanceof Short) {
            this.stringBuilder.append("Short.valueOf((short)").append(value).append(')');
        } else if (value instanceof Character) {
            this.stringBuilder.append("Character.valueOf((char)").append((int)((Character)value).charValue()).append(')');
        } else if (value instanceof Integer) {
            this.stringBuilder.append("Integer.valueOf(").append(value).append(')');
        } else if (value instanceof Float) {
            this.stringBuilder.append("Float.valueOf(\"").append(value).append("\")");
        } else if (value instanceof Long) {
            this.stringBuilder.append("Long.valueOf(").append(value).append("L)");
        } else if (value instanceof Double) {
            this.stringBuilder.append("Double.valueOf(\"").append(value).append("\")");
        } else if (value instanceof byte[]) {
            byte[] byteArray = (byte[])value;
            this.stringBuilder.append("new byte[] {");
            for (int i = 0; i < byteArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(byteArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (value instanceof boolean[]) {
            boolean[] booleanArray = (boolean[])value;
            this.stringBuilder.append("new boolean[] {");
            for (int i = 0; i < booleanArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(booleanArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (value instanceof short[]) {
            short[] shortArray = (short[])value;
            this.stringBuilder.append("new short[] {");
            for (int i = 0; i < shortArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append("(short)").append(shortArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (value instanceof char[]) {
            char[] charArray = (char[])value;
            this.stringBuilder.append("new char[] {");
            for (int i = 0; i < charArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append("(char)").append((int)charArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (value instanceof int[]) {
            int[] intArray = (int[])value;
            this.stringBuilder.append("new int[] {");
            for (int i = 0; i < intArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(intArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (value instanceof long[]) {
            long[] longArray = (long[])value;
            this.stringBuilder.append("new long[] {");
            for (int i = 0; i < longArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(longArray[i]).append('L');
            }
            this.stringBuilder.append('}');
        } else if (value instanceof float[]) {
            float[] floatArray = (float[])value;
            this.stringBuilder.append("new float[] {");
            for (int i = 0; i < floatArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(floatArray[i]).append('f');
            }
            this.stringBuilder.append('}');
        } else if (value instanceof double[]) {
            double[] doubleArray = (double[])value;
            this.stringBuilder.append("new double[] {");
            for (int i = 0; i < doubleArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(doubleArray[i]).append('d');
            }
            this.stringBuilder.append('}');
        }
    }

    private void declareFrameTypes(int numTypes, Object[] frameTypes) {
        for (int i = 0; i < numTypes; ++i) {
            if (!(frameTypes[i] instanceof Label)) continue;
            this.declareLabel((Label)frameTypes[i]);
        }
    }

    private void appendFrameTypes(int numTypes, Object[] frameTypes) {
        for (int i = 0; i < numTypes; ++i) {
            if (i > 0) {
                this.stringBuilder.append(", ");
            }
            if (frameTypes[i] instanceof String) {
                this.appendConstant(frameTypes[i]);
                continue;
            }
            if (frameTypes[i] instanceof Integer) {
                this.stringBuilder.append(FRAME_TYPES.get((Integer)frameTypes[i]));
                continue;
            }
            this.appendLabel((Label)frameTypes[i]);
        }
    }

    protected void declareLabel(Label label) {
        String labelName;
        if (this.labelNames == null) {
            this.labelNames = new HashMap<Label, String>();
        }
        if ((labelName = this.labelNames.get(label)) == null) {
            labelName = "label" + this.labelNames.size();
            this.labelNames.put(label, labelName);
            this.stringBuilder.append("\t\tLabel ").append(labelName).append(" = new Label();\n");
        }
    }

    protected void declareLabel(Label label, String name) {
        String labelName;
        if (this.labelNames == null) {
            this.labelNames = new HashMap<Label, String>();
        }
        if ((labelName = this.labelNames.get(label)) == null) {
            labelName = "label" + this.labelNames.size() + "Of" + name;
            this.labelNames.put(label, labelName);
            this.stringBuilder.append("\t\tLabel ").append(labelName).append(" = new Label();\n");
        } else if (labelName.length() == 0) {
            labelName = "label" + this.labelNames.size() + "Of" + name;
            this.labelNames.put(label, labelName);
        }
    }

    protected void appendLabel(Label label) {
        this.stringBuilder.append(this.labelNames.get(label));
    }

    private String clazzof(String descriptor) {
        return this.clazzOf(Type.getType((String)descriptor), this.tiny_referedTypes);
    }

    public String clazzOf(Type type, Map<String, String> referedTypes) {
        logger.trace("clazzOf - {} ", (Object)type.getClassName());
        if (this.tiny_className.equals(type.getInternalName())) {
            this.methodUsedClassParameters.put(type.getClassName(), this.classDefinedClassParameters.get(type.getClassName()));
            return this.classDefinedClassParameters.get(type.getClassName());
        }
        if (this.classDefinedClassParameters != null && this.classDefinedClassParameters.containsKey(type.getClassName())) {
            logger.trace("clazzOf - {} is in paramter {}", (Object)type.getClassName(), (Object)this.classDefinedClassParameters.get(type.getClassName()));
            this.methodUsedClassParameters.put(type.getClassName(), this.classDefinedClassParameters.get(type.getClassName()));
            return this.classDefinedClassParameters.get(type.getClassName());
        }
        logger.trace("clazzOf({})", (Object)type);
        if (tiny_primativeTypeMaps.containsKey(type.getInternalName())) {
            return tiny_primativeTypeMaps.get(type.getInternalName());
        }
        if (type.getSort() == 9 && type.getElementType().getSort() == 10) {
            logger.trace("{} Array", (Object)type.getElementType());
            referedTypes.put(type.getElementType().getClassName(), "");
            return TinyASMifier.toSimpleName(type.getElementType().getClassName()) + "[].class";
        }
        if (type.getSort() == 10) {
            referedTypes.put(type.getClassName(), "");
            return TinyASMifier.toSimpleName(type.getClassName()) + ".class";
        }
        return "unknown.class";
    }

    static String toSimpleName(String str) {
        return str.substring(str.lastIndexOf(46) + 1, str.length());
    }

    private void makeParameters() {
        this.stringBuilder.setLength(0);
        this.tiny_hasMakeParameters = true;
        if (this.tiny_methodParamTypes.length > 0) {
            if (this.tiny_methodSignatureParamClazzList == null) {
                int offset = this.tiny_methodIsStatic ? 0 : 1;
                for (int i = 0; i < this.tiny_methodParamTypes.length; ++i) {
                    this.stringBuilder.setLength(0);
                    TinyLocalsStack.Var var = (TinyLocalsStack.Var)this.tiny_methodLocals.stack.get(i + offset);
                    this.stringBuilder.append("\n\t\t\t\t.parameter(");
                    if (var.access != 0) {
                        this.appendAccessFlags(var.access);
                        this.stringBuilder.append(", ");
                    }
                    this.stringBuilder.append("\"");
                    this.text.add(this.stringBuilder.toString());
                    this.stringBuilder.setLength(0);
                    this.text.add(var);
                    this.stringBuilder.append("\", ");
                    this.stringBuilder.append(this.clazzOf(this.tiny_methodParamTypes[i], this.tiny_referedTypes));
                    this.stringBuilder.append(")");
                    this.text.add(this.stringBuilder.toString());
                }
            } else {
                int offset = this.tiny_methodIsStatic ? 0 : 1;
                for (int i = 0; i < this.tiny_methodSignatureParamClazzList.size(); ++i) {
                    this.stringBuilder.setLength(0);
                    TinyLocalsStack.Var var = (TinyLocalsStack.Var)this.tiny_methodLocals.stack.get(i + offset);
                    this.stringBuilder.append("\n\t\t\t\t.parameter(");
                    if (var.access != 0) {
                        this.appendAccessFlags(var.access);
                        this.stringBuilder.append(", ");
                    }
                    this.stringBuilder.append("\"");
                    this.text.add(this.stringBuilder.toString());
                    this.stringBuilder.setLength(0);
                    this.text.add(var);
                    this.stringBuilder.append("\", ");
                    if (this.tiny_methodSignatureParamClazzList.get(i).length() > 0) {
                        this.stringBuilder.append((CharSequence)this.tiny_methodSignatureParamClazzList.get(i));
                    } else {
                        this.stringBuilder.append(this.clazzOf(this.tiny_methodParamTypes[i], this.tiny_referedTypes));
                    }
                    this.stringBuilder.append(")");
                    this.text.add(this.stringBuilder.toString());
                }
            }
        }
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(".begin();\n");
        this.text.add(this.stringBuilder.toString());
    }

    private String nameWithParameter(String name, Type[] methodParamTypes2, Type returnType) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        for (Type type : methodParamTypes2) {
            sb.append("_");
            sb.append(this.extracted(type));
        }
        sb.append("_");
        sb.append(this.extracted(returnType));
        return sb.toString();
    }

    protected String extracted(Type type) {
        String className = type.getClassName();
        if (className.startsWith("java.lang")) {
            return className.replace("java.lang", "").replaceAll("[.]", "").replaceAll("\\[\\]", "_array_");
        }
        if (className.startsWith("java.sql")) {
            return className.replace("java.sql", "").replaceAll("[.]", "").replaceAll("\\[\\]", "_array_");
        }
        String ownerClassName = this.tiny_className.replace("/", ".");
        int lastPos = 0;
        int pos = ownerClassName.indexOf(".", lastPos);
        while (pos > 0 && className.startsWith(ownerClassName.substring(0, pos))) {
            lastPos = pos;
            pos = ownerClassName.indexOf(".", lastPos + 1);
        }
        if (lastPos > 0) {
            return className.substring(lastPos + 1).replaceAll("[.]", "");
        }
        return className.replaceAll("[.]", "").replaceAll("\\[\\]", "_array_");
    }

    protected void tiny_visit(int access, String name, String signature, String superName, String[] interfaces) {
        String simpleName;
        this.tiny_className = name;
        if (name == null) {
            simpleName = "module-info";
        } else {
            int lastSlashIndex = name.lastIndexOf(47);
            if (lastSlashIndex == -1) {
                simpleName = name;
            } else {
                this.text.add("package " + name.substring(0, lastSlashIndex).replace('/', '.') + ";\n\n");
                simpleName = name.substring(lastSlashIndex + 1).replace('-', '_');
            }
        }
        this.classDefinedClassParameters.put(name.replace('/', '.'), "className");
        this.classDefinedClassParameterNames.add(0, "className");
        this.classDefinedClassParameterClasses.add(0, name.replace('/', '.'));
        this.text.add("import org.objectweb.asm.Handle;\n");
        this.text.add("import org.objectweb.asm.Label;\n");
        this.text.add("import org.objectweb.asm.Opcodes;\n");
        this.text.add("import org.objectweb.asm.Type;\n");
        this.text.add("import static org.objectweb.asm.Opcodes.*;\n");
        this.text.add("\n");
        this.text.add("import cn.sj1.tinyasm.core.Annotation;\n");
        this.text.add("import cn.sj1.tinyasm.core.ClassBody;\n");
        this.text.add("import cn.sj1.tinyasm.core.ClassBuilder;\n");
        this.text.add("import cn.sj1.tinyasm.core.Clazz;\n");
        this.text.add("import cn.sj1.tinyasm.core.MethodCode;\n");
        this.text.add("\n");
        this.text.add(new TinyHolderReferTypes());
        this.text.add("@SuppressWarnings(\"unused\")\n");
        String className = simpleName + "TinyAsmDump";
        boolean hasSuperClass = false;
        this.text.add("public class " + className + " {\n\n");
        ArrayList<String> params = new ArrayList<String>();
        if (this.classDefinedClassParameterClasses.size() > 1) {
            for (int i = 0; i < this.classDefinedClassParameterClasses.size(); ++i) {
                if (this.classDefinedClassParameterClasses.get(i) instanceof Class) {
                    params.add(((Class)this.classDefinedClassParameterClasses.get(i)).getName() + ".class");
                    continue;
                }
                if (!(this.classDefinedClassParameterClasses.get(i) instanceof String)) continue;
                params.add("\"" + (String)this.classDefinedClassParameterClasses.get(i) + "\"");
            }
            this.text.add("//\tpublic static byte[] dump() {\n");
            this.text.add("//\t\treturn new " + className + "().build(" + String.join((CharSequence)",", params) + ");\n");
            this.text.add("//\t}\n\n");
        } else {
            params.add("\"" + name.replace('/', '.') + "\"");
            this.text.add("\tpublic static byte[] dump() {\n");
            this.text.add("\t\treturn new " + className + "().build(" + String.join((CharSequence)",", params) + ");\n");
            this.text.add("\t}\n\n");
        }
        ArrayList<String> paramDefines = new ArrayList<String>();
        ArrayList<String> params2 = new ArrayList<String>();
        for (int i = 0; i < this.classDefinedClassParameterClasses.size(); ++i) {
            Object value = this.classDefinedClassParameterClasses.get(i);
            if (value instanceof String) {
                paramDefines.add("String " + this.classDefinedClassParameterNames.get(i));
            } else if (value instanceof Class) {
                paramDefines.add("Class<?> " + this.classDefinedClassParameterNames.get(i));
            }
            params2.add(this.classDefinedClassParameterNames.get(i));
        }
        this.text.add("\tpublic byte[] build(" + String.join((CharSequence)",", paramDefines) + ")  {\n");
        this.stringBuilder.setLength(0);
        if (signature == null) {
            this.stringBuilder.append("\t\tClassBody classBody = ClassBuilder.class_(className");
            if (!Object.class.getName().equals(superName.replace('/', '.'))) {
                hasSuperClass = true;
                this.stringBuilder.append(", ");
                this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)superName), this.tiny_referedTypes));
            }
            if (interfaces != null && interfaces.length > 0) {
                if (!hasSuperClass) {
                    this.stringBuilder.append(", ");
                    this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)superName), this.tiny_referedTypes));
                }
                for (int i = 0; i < interfaces.length; ++i) {
                    this.stringBuilder.append(", ");
                    this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)interfaces[i]), this.tiny_referedTypes));
                }
                hasSuperClass = true;
            }
            this.stringBuilder.append(")");
        } else {
            this.stringBuilder.append("\t\tClassBody classBody = ClassBuilder.class_(className");
            this.stringBuilder.append(", ");
            SignatureReader sr = new SignatureReader(signature);
            ClassSignature signatureVistor = new ClassSignature(this.api, this.classDefinedClassParameters, this.methodUsedClassParameters, this.tiny_referedTypes);
            sr.accept((SignatureVisitor)signatureVistor);
            hasSuperClass = true;
            this.stringBuilder.append(signatureVistor.superClass.toString());
            for (StringBuilder string : signatureVistor.interfacesClassList) {
                this.stringBuilder.append(",");
                this.stringBuilder.append((CharSequence)string);
            }
            this.stringBuilder.append(")");
            for (StringBuilder string : signatureVistor.typeParameterClassList) {
                this.stringBuilder.append(".formalTypeParameter(");
                this.stringBuilder.append((CharSequence)string);
                this.stringBuilder.append(")");
            }
        }
        if (!(!hasSuperClass && access == 1 || hasSuperClass && access == 33)) {
            this.stringBuilder.append("\n\t\t\t\t.access(");
            this.appendAccessFlags(access | 0x40000);
            this.stringBuilder.append(")");
        }
        this.stringBuilder.append(".body();\n\n");
        this.tiny_annotation = new Annotation();
    }

    protected TinyASMifier tiny_visitField(int access, String name, String descriptor, String signature) {
        this.stringBuilder.setLength(0);
        if ((access & 8) > 0) {
            this.stringBuilder.append("\t\tclassBody.staticField(");
            if (access != 9) {
                this.appendAccessFlags(access);
                this.stringBuilder.append(", ");
            }
        } else if (access == 1) {
            this.stringBuilder.append("\t\tclassBody.public_().field(");
        } else if (access == 2) {
            this.stringBuilder.append("\t\tclassBody.private_().field(");
        } else if (access == 4) {
            this.stringBuilder.append("\t\tclassBody.protected_().field(");
        } else if (access == 0) {
            this.stringBuilder.append("\t\tclassBody.field(");
        } else {
            this.stringBuilder.append("\t\tclassBody.field(");
            this.appendAccessFlags(access);
            this.stringBuilder.append(", ");
        }
        this.text.add(this.stringBuilder.toString());
        this.tiny_annotation = new Annotation();
        this.text.add(new TextParameter(this.tiny_annotation));
        this.stringBuilder.setLength(0);
        this.appendConstant(name);
        if (signature == null) {
            this.stringBuilder.append(", Clazz.of(");
            this.stringBuilder.append(this.clazzOf(Type.getType((String)descriptor), this.tiny_referedTypes));
            this.stringBuilder.append(")");
        } else {
            this.stringBuilder.append(", ");
            SignatureReader sr = new SignatureReader(signature);
            ClassSignature signatureVistor = new ClassSignature(this.api, this.classDefinedClassParameters, this.methodUsedClassParameters, this.tiny_referedTypes);
            sr.accept((SignatureVisitor)signatureVistor);
            this.stringBuilder.append(signatureVistor.toString());
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        TinyASMifier asmifier = this.createASMifier("fieldVisitor", 0);
        this.text.add(asmifier.getText());
        asmifier.tiny_annotation = this.tiny_annotation;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_methodLocals = this.tiny_methodLocals;
        asmifier.tiny_methodVisitParameter = this.tiny_methodVisitParameter;
        asmifier.tiny_methodParamTypes = this.tiny_methodParamTypes;
        asmifier.tiny_methodSignatureParamClazzList = this.tiny_methodSignatureParamClazzList;
        asmifier.tiny_methodSignatureTypeParameterClassList = this.tiny_methodSignatureTypeParameterClassList;
        asmifier.tiny_methodIsStatic = this.tiny_methodIsStatic;
        asmifier.tiny_className = this.tiny_className;
        asmifier.tiny_referedTypes = this.tiny_referedTypes;
        asmifier.classDefinedClassParameters = this.classDefinedClassParameters;
        asmifier.methodUsedClassParameters = this.methodUsedClassParameters;
        asmifier.classDefinedClassParameterNames = this.classDefinedClassParameterNames;
        asmifier.classDefinedClassParameterClasses = this.classDefinedClassParameterClasses;
        return asmifier;
    }

    protected void tiny_visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.tiny_methodLocals = new TinyLocalsStack();
        Type returnType = Type.getReturnType((String)descriptor);
        this.tiny_methodParamTypes = Type.getArgumentTypes((String)descriptor);
        String codeMethodName = "_" + name.replaceAll("[<>]", "_");
        if ((access & 0x40) > 0) {
            codeMethodName = "_bridge" + codeMethodName;
        }
        codeMethodName = !this.tiny_methodNames.containsKey(codeMethodName) ? codeMethodName : this.nameWithParameter(codeMethodName, this.tiny_methodParamTypes, returnType);
        this.tiny_methodNames.put(codeMethodName, codeMethodName);
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("\t\t");
        this.stringBuilder.append(codeMethodName);
        this.stringBuilder.append("(classBody");
        this.text.add(this.stringBuilder.toString());
        this.text.add(new MethodParamterClassesInvokeHolder(this.classDefinedClassParameterNames, this.methodUsedClassParameters));
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        logger.trace("visitMethod(final int access, final String {}, final String {}, final String {}, final String[] exceptions)", new Object[]{name, descriptor, signature});
        if ((access & 8) > 0) {
            this.tiny_methodIsStatic = true;
            this.tiny_methodVisitParameter = 0;
        } else {
            this.tiny_methodLocals.pushDefined("this", Type.getType(Object.class));
            this.tiny_methodIsStatic = false;
            this.tiny_methodVisitParameter = 1;
        }
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("\tprotected void ");
        this.stringBuilder.append(codeMethodName);
        this.stringBuilder.append("(ClassBody classBody");
        this.tiny_textMethods.add(this.stringBuilder.toString());
        this.tiny_textMethods.add(new MethodParamterClassesHolder(this.methodUsedClassParameters));
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") {\n");
        if (!this.tiny_methodIsStatic) {
            if (access == 1) {
                this.stringBuilder.append("\t\tMethodCode code = classBody.public_().method(");
            } else if (access == 2) {
                this.stringBuilder.append("\t\tMethodCode code = classBody.private_().method(");
            } else if (access == 4) {
                this.stringBuilder.append("\t\tMethodCode code = classBody.protected_().method(");
            } else if (access == 0) {
                this.stringBuilder.append("\t\tMethodCode code = classBody.method(");
            } else {
                this.stringBuilder.append("\t\tMethodCode code = classBody.method(");
                if (access != 0) {
                    this.appendAccessFlags(access);
                    this.stringBuilder.append(", ");
                }
            }
        } else if (access == 0) {
            this.stringBuilder.append("\t\tMethodCode code = classBody.publicStaticMethod(");
        } else if (access == 0) {
            this.stringBuilder.append("\t\tMethodCode code = classBody.privateStaticMethod(");
        } else if (access == 0) {
            this.stringBuilder.append("\t\tMethodCode code = classBody.protectedStaticMethod(");
        } else if (access == 8) {
            this.stringBuilder.append("\t\tMethodCode code = classBody.staticMethod(");
        } else {
            this.stringBuilder.append("\t\tMethodCode code = classBody.staticMethod(");
            this.appendAccessFlags(access);
            this.stringBuilder.append(", ");
        }
        this.appendConstant(name);
        this.stringBuilder.append(")");
        if (signature != null) {
            SignatureReader sr = new SignatureReader(signature);
            ClassSignature signatureVistor = new ClassSignature(this.api, this.classDefinedClassParameters, this.methodUsedClassParameters, this.tiny_referedTypes);
            sr.accept((SignatureVisitor)signatureVistor);
            this.tiny_methodSignatureReturnClass = signatureVistor.returnClass;
            this.tiny_methodSignatureParamClazzList = signatureVistor.paramsClassList;
            this.tiny_methodSignatureTypeParameterClassList = signatureVistor.typeParameterClassList;
        }
        if (signature == null) {
            if (returnType != Type.VOID_TYPE) {
                this.stringBuilder.append("\n\t\t\t\t.return_(");
                this.stringBuilder.append(this.clazzOf(returnType, this.tiny_referedTypes));
                this.stringBuilder.append(")");
            }
        } else if (this.tiny_methodSignatureReturnClass.length() > 0) {
            this.stringBuilder.append("\n\t\t\t\t.return_(");
            this.stringBuilder.append((CharSequence)this.tiny_methodSignatureReturnClass);
            this.stringBuilder.append(")");
        }
        if (signature != null && this.tiny_methodSignatureTypeParameterClassList.size() > 0) {
            for (int i = 0; i < this.tiny_methodSignatureTypeParameterClassList.size(); ++i) {
                this.stringBuilder.append("\n\t\t\t\t.formalTypeParameter(");
                this.stringBuilder.append((CharSequence)this.tiny_methodSignatureTypeParameterClassList.get(i));
                this.stringBuilder.append(")");
            }
        }
        this.tiny_textMethods.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        if (exceptions != null && exceptions.length > 0) {
            for (int i = 0; i < exceptions.length; ++i) {
                this.stringBuilder.append("\n\t\t\t\t.throws_(");
                this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)exceptions[i]), this.tiny_referedTypes));
                this.stringBuilder.append(")");
            }
        }
        this.tiny_textMethods.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        if (this.tiny_methodParamTypes.length > 0) {
            for (int i = 0; i < this.tiny_methodParamTypes.length; ++i) {
                this.tiny_methodLocals.pushDefined("", this.tiny_methodParamTypes[i]);
            }
        }
    }

    protected void tiny_visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.stringBuilder.setLength(0);
        switch (opcode) {
            case 178: {
                if (this.tiny_className.equals(owner)) {
                    this.stringBuilder.setLength(0);
                    this.stringBuilder.append(this.visitname).append(".GETSTATIC(");
                    this.appendConstant(name);
                    this.stringBuilder.append(", ");
                    this.stringBuilder.append(this.clazzOf(Type.getType((String)descriptor), this.tiny_referedTypes));
                    this.stringBuilder.append(");\n");
                    this.text.add(this.stringBuilder.toString());
                    break;
                }
                this.stringBuilder.setLength(0);
                this.stringBuilder.append(this.visitname).append(".GETSTATIC(");
                this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)owner), this.tiny_referedTypes));
                this.stringBuilder.append(", ");
                this.appendConstant(name);
                this.stringBuilder.append(", ");
                this.stringBuilder.append(this.clazzOf(Type.getType((String)descriptor), this.tiny_referedTypes));
                this.stringBuilder.append(");\n");
                this.text.add(this.stringBuilder.toString());
                break;
            }
            case 179: {
                if (this.tiny_className.equals(owner)) {
                    this.stringBuilder.setLength(0);
                    this.stringBuilder.append(this.visitname).append(".PUTSTATIC(");
                    this.appendConstant(name);
                    this.stringBuilder.append(", ");
                    this.stringBuilder.append(this.clazzOf(Type.getType((String)descriptor), this.tiny_referedTypes));
                    this.stringBuilder.append(");\n");
                    this.text.add(this.stringBuilder.toString());
                    break;
                }
                this.stringBuilder.setLength(0);
                this.stringBuilder.append(this.visitname).append(".PUTSTATIC(");
                this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)owner), this.tiny_referedTypes));
                this.stringBuilder.append(", ");
                this.appendConstant(name);
                this.stringBuilder.append(", ");
                this.stringBuilder.append(this.clazzOf(Type.getType((String)descriptor), this.tiny_referedTypes));
                this.stringBuilder.append(");\n");
                this.text.add(this.stringBuilder.toString());
                break;
            }
            case 180: {
                if (this.tiny_className.equals(owner)) {
                    this.stringBuilder.setLength(0);
                    this.stringBuilder.append(this.visitname).append(".GETFIELD(");
                    this.appendConstant(name);
                    this.stringBuilder.append(", ");
                    this.stringBuilder.append(this.clazzOf(Type.getType((String)descriptor), this.tiny_referedTypes));
                    this.stringBuilder.append(");\n");
                    this.text.add(this.stringBuilder.toString());
                    break;
                }
                this.stringBuilder.setLength(0);
                this.stringBuilder.append(this.visitname).append(".GETFIELD(");
                this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)owner), this.tiny_referedTypes));
                this.stringBuilder.append(", ");
                this.appendConstant(name);
                this.stringBuilder.append(", ");
                this.stringBuilder.append(this.clazzOf(Type.getType((String)descriptor), this.tiny_referedTypes));
                this.stringBuilder.append(");\n");
                this.text.add(this.stringBuilder.toString());
                break;
            }
            case 181: {
                if (this.tiny_className.equals(owner)) {
                    this.stringBuilder.setLength(0);
                    this.stringBuilder.append(this.visitname).append(".PUTFIELD(");
                    this.appendConstant(name);
                    this.stringBuilder.append(", ");
                    this.stringBuilder.append(this.clazzOf(Type.getType((String)descriptor), this.tiny_referedTypes));
                    this.stringBuilder.append(");\n");
                    this.text.add(this.stringBuilder.toString());
                    break;
                }
                this.stringBuilder.setLength(0);
                this.stringBuilder.append(this.visitname).append(".PUTFIELD(");
                this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)owner), this.tiny_referedTypes));
                this.stringBuilder.append(", ");
                this.appendConstant(name);
                this.stringBuilder.append(", ");
                this.stringBuilder.append(this.clazzOf(Type.getType((String)descriptor), this.tiny_referedTypes));
                this.stringBuilder.append(");\n");
                this.text.add(this.stringBuilder.toString());
                break;
            }
            default: {
                this.stringBuilder.setLength(0);
                this.stringBuilder.append(this.visitname).append(".visitFieldInsn(").append(OPCODES[opcode]).append(", ");
                this.appendConstant(name);
                this.stringBuilder.append(", ");
                this.appendConstant(descriptor);
                this.stringBuilder.append(");\n");
                this.text.add(this.stringBuilder.toString());
            }
        }
    }

    protected void tiny_visitIntInsn(int opcode, int operand) {
        this.stringBuilder.setLength(0);
        block0 : switch (opcode) {
            case 16: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(").append(operand).append(");\n");
                break;
            }
            case 17: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(").append(operand).append(");\n");
                break;
            }
            case 188: {
                switch (operand) {
                    case 4: {
                        this.stringBuilder.append(this.visitname).append(".NEWARRAY(").append("boolean.class").append(");\n");
                        break block0;
                    }
                    case 5: {
                        this.stringBuilder.append(this.visitname).append(".NEWARRAY(").append("char.class").append(");\n");
                        break block0;
                    }
                    case 6: {
                        this.stringBuilder.append(this.visitname).append(".NEWARRAY(").append("float.class").append(");\n");
                        break block0;
                    }
                    case 7: {
                        this.stringBuilder.append(this.visitname).append(".NEWARRAY(").append("double.class").append(");\n");
                        break block0;
                    }
                    case 8: {
                        this.stringBuilder.append(this.visitname).append(".NEWARRAY(").append("byte.class").append(");\n");
                        break block0;
                    }
                    case 9: {
                        this.stringBuilder.append(this.visitname).append(".NEWARRAY(").append("short.class").append(");\n");
                        break block0;
                    }
                    case 10: {
                        this.stringBuilder.append(this.visitname).append(".NEWARRAY(").append("int.class").append(");\n");
                        break block0;
                    }
                    case 11: {
                        this.stringBuilder.append(this.visitname).append(".NEWARRAY(").append("long.class").append(");\n");
                        break block0;
                    }
                }
                this.stringBuilder.append(this.visitname).append(".NEWARRAY(").append(TYPES[operand]).append(");\n");
                break;
            }
            default: {
                this.stringBuilder.append(this.visitname).append(".visitIntInsn(").append(OPCODES[opcode]).append(", ").append(opcode == 188 ? TYPES[operand] : Integer.toString(operand)).append(");\n");
            }
        }
        this.text.add(this.stringBuilder.toString());
    }

    protected void tiny_visitVarInsn(int opcode, int var) {
        this.stringBuilder.setLength(0);
        TinyLocalsStack.Var localVar = null;
        if (21 <= opcode && opcode <= 25) {
            switch (opcode) {
                case 21: {
                    localVar = this.tiny_methodLocals.accessLoad(var, 1);
                    break;
                }
                case 22: {
                    localVar = this.tiny_methodLocals.accessLoad(var, 2);
                    break;
                }
                case 23: {
                    localVar = this.tiny_methodLocals.accessLoad(var, 2);
                    break;
                }
                case 24: {
                    localVar = this.tiny_methodLocals.accessLoad(var, 2);
                    break;
                }
                case 25: {
                    localVar = this.tiny_methodLocals.accessLoad(var, 1);
                }
            }
            this.stringBuilder.append(this.visitname).append(".LOAD(\"");
            this.text.add(this.stringBuilder.toString());
            this.text.add(localVar);
            this.stringBuilder.setLength(0);
            this.stringBuilder.append("\");\n");
            this.text.add(this.stringBuilder.toString());
        } else if (54 <= opcode && opcode <= 58) {
            switch (opcode) {
                case 54: {
                    localVar = this.tiny_methodLocals.accessStore(var, 1);
                    break;
                }
                case 55: {
                    localVar = this.tiny_methodLocals.accessStore(var, 2);
                    break;
                }
                case 56: {
                    localVar = this.tiny_methodLocals.accessStore(var, 1);
                    break;
                }
                case 57: {
                    localVar = this.tiny_methodLocals.accessStore(var, 2);
                    break;
                }
                case 58: {
                    localVar = this.tiny_methodLocals.accessStore(var, 1);
                }
            }
            this.stringBuilder.append(this.visitname).append(".STORE(\"");
            this.text.add(this.stringBuilder.toString());
            this.text.add(localVar);
            this.stringBuilder.setLength(0);
            this.stringBuilder.append("\"");
            if (localVar.count == 1) {
                this.text.add(this.stringBuilder.toString());
                this.text.add(new VarType(localVar));
                this.stringBuilder.setLength(0);
                this.stringBuilder.append("");
            }
            this.stringBuilder.append(");\n");
            this.text.add(this.stringBuilder.toString());
        } else if (opcode == 169) {
            this.stringBuilder.append(this.visitname).append(".visitVarInsn(").append(OPCODES[opcode]).append(", ").append(var).append(");\n");
        }
    }

    protected void tiny_visitTypeInsn(int opcode, String type) {
        switch (opcode) {
            case 187: {
                this.stringBuilder.setLength(0);
                this.stringBuilder.append(this.visitname).append(".NEW(");
                this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)type), this.tiny_referedTypes));
                this.stringBuilder.append(");\n");
                this.text.add(this.stringBuilder.toString());
                break;
            }
            case 189: {
                this.stringBuilder.setLength(0);
                this.stringBuilder.append(this.visitname).append(".NEWARRAY(");
                this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)type), this.tiny_referedTypes));
                this.stringBuilder.append(");\n");
                this.text.add(this.stringBuilder.toString());
                break;
            }
            case 192: {
                this.stringBuilder.setLength(0);
                this.stringBuilder.append(this.visitname).append(".CHECKCAST(");
                this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)type), this.tiny_referedTypes));
                this.stringBuilder.append(");\n");
                this.text.add(this.stringBuilder.toString());
                break;
            }
            case 193: {
                this.stringBuilder.setLength(0);
                this.stringBuilder.append(this.visitname).append(".INSTANCEOF(");
                this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)type), this.tiny_referedTypes));
                this.stringBuilder.append(");\n");
                this.text.add(this.stringBuilder.toString());
                break;
            }
            default: {
                this.stringBuilder.setLength(0);
                this.stringBuilder.append(this.visitname).append(".visitTypeInsn(").append(OPCODES[opcode]).append(", ");
                this.appendConstant(type);
                this.stringBuilder.append(");\n");
                this.text.add(this.stringBuilder.toString());
            }
        }
    }

    protected void tiny_visitInsn(int opcode) {
        this.stringBuilder.setLength(0);
        switch (opcode) {
            case 0: {
                this.stringBuilder.append(this.visitname).append(".NOP();\n");
                break;
            }
            case 1: {
                this.stringBuilder.append(this.visitname).append(".LOADConstNULL();\n");
                break;
            }
            case 2: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(-1);\n");
                break;
            }
            case 3: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(0);\n");
                break;
            }
            case 4: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(1);\n");
                break;
            }
            case 5: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(2);\n");
                break;
            }
            case 6: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(3);\n");
                break;
            }
            case 7: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(4);\n");
                break;
            }
            case 8: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(5);\n");
                break;
            }
            case 9: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(0L);\n");
                break;
            }
            case 10: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(1L);\n");
                break;
            }
            case 11: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(0F);\n");
                break;
            }
            case 12: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(1F);\n");
                break;
            }
            case 13: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(2F);\n");
                break;
            }
            case 14: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(0D);\n");
                break;
            }
            case 15: {
                this.stringBuilder.append(this.visitname).append(".LOADConst(1D);\n");
                break;
            }
            case 18: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.stringBuilder.append(this.visitname).append(".ARRAYLOAD();\n");
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.stringBuilder.append(this.visitname).append(".ARRAYSTORE();\n");
                break;
            }
            case 87: 
            case 88: {
                this.stringBuilder.append(this.visitname).append(".POP();\n");
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                this.stringBuilder.append(this.visitname).append(".DUP();\n");
                break;
            }
            case 95: {
                this.stringBuilder.append(this.visitname).append(".SWAP();\n");
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                this.stringBuilder.append(this.visitname).append(".ADD();\n");
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                this.stringBuilder.append(this.visitname).append(".SUB();\n");
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                this.stringBuilder.append(this.visitname).append(".MUL();\n");
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                this.stringBuilder.append(this.visitname).append(".DIV();\n");
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                this.stringBuilder.append(this.visitname).append(".REM();\n");
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.stringBuilder.append(this.visitname).append(".NEG();\n");
                break;
            }
            case 120: 
            case 121: {
                this.stringBuilder.append(this.visitname).append(".SHL();\n");
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                this.stringBuilder.append(this.visitname).append(".SHR();\n");
                break;
            }
            case 126: 
            case 127: {
                this.stringBuilder.append(this.visitname).append(".AND();\n");
                break;
            }
            case 128: 
            case 129: {
                this.stringBuilder.append(this.visitname).append(".OR();\n");
                break;
            }
            case 130: 
            case 131: {
                this.stringBuilder.append(this.visitname).append(".XOR();\n");
                break;
            }
            case 133: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(long.class);\n");
                break;
            }
            case 134: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(float.class);\n");
                break;
            }
            case 135: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(double.class);\n");
                break;
            }
            case 136: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(int.class);\n");
                break;
            }
            case 137: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(float.class);\n");
                break;
            }
            case 138: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(double.class);\n");
                break;
            }
            case 139: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(int.class);\n");
                break;
            }
            case 140: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(long.class);\n");
                break;
            }
            case 141: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(double.class);\n");
                break;
            }
            case 142: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(int.class);\n");
                break;
            }
            case 143: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(long.class);\n");
                break;
            }
            case 144: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(float.class);\n");
                break;
            }
            case 145: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(byte.class);\n");
                break;
            }
            case 146: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(char.class);\n");
                break;
            }
            case 147: {
                this.stringBuilder.append(this.visitname).append(".CONVERTTO(short.class);\n");
                break;
            }
            case 148: {
                this.stringBuilder.append(this.visitname).append(".LCMP();\n");
                break;
            }
            case 149: {
                this.stringBuilder.append(this.visitname).append(".CMPL();\n");
                break;
            }
            case 150: {
                this.stringBuilder.append(this.visitname).append(".CMPG();\n");
                break;
            }
            case 151: {
                this.stringBuilder.append(this.visitname).append(".CMPL();\n");
                break;
            }
            case 152: {
                this.stringBuilder.append(this.visitname).append(".CMPG();\n");
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                this.stringBuilder.append(this.visitname).append(".RETURNTop();\n");
                break;
            }
            case 177: {
                this.stringBuilder.append(this.visitname).append(".RETURN();\n");
                break;
            }
            case 190: {
                this.stringBuilder.append(this.visitname).append(".ARRAYLENGTH();\n");
                break;
            }
            case 191: 
            case 194: 
            case 195: {
                this.stringBuilder.append(this.visitname).append(".visitInsn(").append(OPCODES[opcode]).append(");\n");
                break;
            }
            default: {
                this.stringBuilder.append(this.visitname).append(".visitInsn(").append(OPCODES[opcode]).append(");\n");
            }
        }
        this.text.add(this.stringBuilder.toString());
    }

    protected void tiny_visitJumpInsn(int opcode, Label label) {
        this.stringBuilder.setLength(0);
        this.declareLabel(label, OPCODES[opcode]);
        switch (opcode) {
            case 153: {
                this.stringBuilder.append(this.visitname).append(".IFEQ(");
                break;
            }
            case 154: {
                this.stringBuilder.append(this.visitname).append(".IFNE(");
                break;
            }
            case 155: {
                this.stringBuilder.append(this.visitname).append(".IFLT(");
                break;
            }
            case 156: {
                this.stringBuilder.append(this.visitname).append(".IFGE(");
                break;
            }
            case 157: {
                this.stringBuilder.append(this.visitname).append(".IFGT(");
                break;
            }
            case 158: {
                this.stringBuilder.append(this.visitname).append(".IFLE(");
                break;
            }
            case 159: {
                this.stringBuilder.append(this.visitname).append(".IF_ICMPEQ(");
                break;
            }
            case 160: {
                this.stringBuilder.append(this.visitname).append(".IF_ICMPNE(");
                break;
            }
            case 161: {
                this.stringBuilder.append(this.visitname).append(".IF_ICMPLT(");
                break;
            }
            case 162: {
                this.stringBuilder.append(this.visitname).append(".IF_ICMPGE(");
                break;
            }
            case 163: {
                this.stringBuilder.append(this.visitname).append(".IF_ICMPGT(");
                break;
            }
            case 164: {
                this.stringBuilder.append(this.visitname).append(".IF_ICMPLE(");
                break;
            }
            case 165: {
                this.stringBuilder.append(this.visitname).append(".IF_ACMPEQ(");
                break;
            }
            case 166: {
                this.stringBuilder.append(this.visitname).append(".IF_ACMPNE(");
                break;
            }
            case 167: {
                this.stringBuilder.append(this.visitname).append(".GOTO(");
                break;
            }
            case 168: {
                this.stringBuilder.append(this.visitname).append(".JSR(");
                break;
            }
            case 198: {
                this.stringBuilder.append(this.visitname).append(".IFNULL(");
                break;
            }
            case 199: {
                this.stringBuilder.append(this.visitname).append(".IFNONNULL(");
                break;
            }
            default: {
                this.stringBuilder.append(this.visitname).append(".visitJumpInsn(");
            }
        }
        this.appendLabel(label);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    protected void tiny_doVisitMethodInsn(int opcode, String owner, String name, String descriptor) {
        this.stringBuilder.setLength(0);
        switch (opcode) {
            case 182: {
                this.stringBuilder.append(this.visitname).append(".VIRTUAL(");
                break;
            }
            case 183: {
                this.stringBuilder.append(this.visitname).append(".SPECIAL(");
                break;
            }
            case 184: {
                this.stringBuilder.append(this.visitname).append(".STATIC(");
                break;
            }
            case 185: {
                this.stringBuilder.append(this.visitname).append(".INTERFACE(");
            }
        }
        if (!this.tiny_className.equals(owner)) {
            this.stringBuilder.append(this.clazzOf(Type.getObjectType((String)owner), this.tiny_referedTypes));
            this.stringBuilder.append(", ");
        }
        this.appendConstant(name);
        this.stringBuilder.append(")");
        Type returnType = Type.getReturnType((String)descriptor);
        if (returnType != Type.VOID_TYPE) {
            this.stringBuilder.append("\n\t\t\t\t.return_(");
            this.stringBuilder.append(this.clazzOf(returnType, this.tiny_referedTypes));
            this.stringBuilder.append(")");
        }
        Type[] argumentTypes = Type.getArgumentTypes((String)descriptor);
        for (int i = 0; i < argumentTypes.length; ++i) {
            this.stringBuilder.append("\n\t\t\t\t.parameter(");
            this.stringBuilder.append(this.clazzOf(argumentTypes[i], this.tiny_referedTypes));
            this.stringBuilder.append(")");
        }
        this.stringBuilder.append(".INVOKE();\n");
        this.text.add(this.stringBuilder.toString());
    }

    protected void tiny_visitMethodEnd() {
        if (!this.tiny_hasMakeParameters) {
            this.makeParameters();
        }
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.tiny_methodLocals.size(); ++i) {
                int stackIndex = (Integer)this.tiny_methodLocals.locals.get(i);
                sb.append(stackIndex);
            }
            logger.trace("STACK {}", (Object)sb);
        }
        boolean good = true;
        int lastStackIndex = -1;
        for (int i = 0; i < this.tiny_methodLocals.size(); ++i) {
            int stackIndex = (Integer)this.tiny_methodLocals.locals.get(i);
            if (stackIndex > 0 && stackIndex < lastStackIndex) {
                good = false;
                break;
            }
            lastStackIndex = stackIndex;
        }
        if (!good) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.tiny_methodLocals.size(); ++i) {
                int stackIndex = (Integer)this.tiny_methodLocals.locals.get(i);
                if (stackIndex < 0) continue;
                TinyLocalsStack.Var var = (TinyLocalsStack.Var)this.tiny_methodLocals.stack.get(stackIndex);
                if (logger.isDebugEnabled()) {
                    logger.debug("{} {} {}", new Object[]{i, var.name, var.type});
                }
                if (var.defined) continue;
                sb.append("\t\tcode.define(");
                sb.append("\"");
                sb.append(var.name);
                sb.append("\",");
                if (var.signature != null) {
                    sb.append(var.signature);
                } else {
                    sb.append(this.clazzOf(var.type, this.tiny_referedTypes));
                }
                sb.append(");\n");
            }
            this.tiny_defineVariables.setString(sb.toString());
        }
    }

    static {
        HashMap<Integer, String> classVersions = new HashMap<Integer, String>();
        classVersions.put(196653, "V1_1");
        classVersions.put(46, "V1_2");
        classVersions.put(47, "V1_3");
        classVersions.put(48, "V1_4");
        classVersions.put(49, "V1_5");
        classVersions.put(50, "V1_6");
        classVersions.put(51, "V1_7");
        classVersions.put(52, "V1_8");
        classVersions.put(53, "V9");
        classVersions.put(54, "V10");
        classVersions.put(55, "V11");
        classVersions.put(56, "V12");
        classVersions.put(57, "V13");
        classVersions.put(58, "V14");
        classVersions.put(59, "V15");
        CLASS_VERSIONS = Collections.unmodifiableMap(classVersions);
        tiny_primativeTypeMaps = new HashMap<String, String>();
        tiny_primativeTypeMaps.put("Z", "boolean.class");
        tiny_primativeTypeMaps.put("B", "byte.class");
        tiny_primativeTypeMaps.put("C", "char.class");
        tiny_primativeTypeMaps.put("S", "short.class");
        tiny_primativeTypeMaps.put("I", "int.class");
        tiny_primativeTypeMaps.put("J", "long.class");
        tiny_primativeTypeMaps.put("F", "float.class");
        tiny_primativeTypeMaps.put("D", "double.class");
        tiny_primativeTypeMaps.put("[Z", "boolean[].class");
        tiny_primativeTypeMaps.put("[B", "byte[].class");
        tiny_primativeTypeMaps.put("[C", "char[].class");
        tiny_primativeTypeMaps.put("[S", "short[].class");
        tiny_primativeTypeMaps.put("[I", "int[].class");
        tiny_primativeTypeMaps.put("[J", "long[].class");
        tiny_primativeTypeMaps.put("[F", "float[].class");
        tiny_primativeTypeMaps.put("[D", "double[].class");
    }

    static class TextParameter {
        Object object;

        public TextParameter(Object object) {
            this.object = object;
        }

        public String toString() {
            String str = this.object.toString();
            return str == null ? "" : this.object.toString() + ",";
        }
    }

    static class Annotation {
        public String clazz;
        public boolean visible;
        List<String> keys = new ArrayList<String>();
        List<Object> values = new ArrayList<Object>();

        Annotation() {
        }

        public String toString() {
            if (this.clazz != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Annotation.of(");
                sb.append(this.clazz);
                if (this.keys.size() > 0) {
                    sb.append(", new String[] {");
                    int i = 0;
                    sb.append("\"");
                    sb.append(this.keys.get(i));
                    sb.append("\"");
                    ++i;
                    while (i < this.keys.size()) {
                        sb.append(",\"");
                        sb.append(this.keys.get(i));
                        sb.append("\"");
                        ++i;
                    }
                    sb.append("}");
                    sb.append(TinyASMifier.NEW_OBJECT_ARRAY);
                    i = 0;
                    sb.append(this.values.get(i));
                    ++i;
                    while (i < this.values.size()) {
                        sb.append(',');
                        sb.append(this.values.get(i));
                        ++i;
                    }
                    sb.append("}");
                }
                sb.append(")");
                return sb.toString();
            }
            return null;
        }
    }

    class DefineVariables {
        String sb;

        DefineVariables() {
        }

        public String toString() {
            return this.sb != null ? this.sb : "";
        }

        public void setString(String string) {
            this.sb = string;
        }
    }

    class VarType {
        TinyLocalsStack.Var var;

        public VarType(TinyLocalsStack.Var var) {
            this.var = var;
        }

        public String toString() {
            return this.var.getSignature() != null ? ", " + this.var.getSignature() : (this.var.type != null ? ", " + TinyASMifier.this.clazzOf(this.var.type, TinyASMifier.this.tiny_referedTypes) : "");
        }
    }

    class TinyHolderReferTypes {
        TinyHolderReferTypes() {
        }

        public String toString() {
            ArrayList<String> importsList = new ArrayList<String>();
            for (String key : TinyASMifier.this.tiny_referedTypes.keySet()) {
                String packageName = key.substring(0, key.lastIndexOf("."));
                if (packageName.equals("java.lang")) continue;
                importsList.add(key);
            }
            StringBuilder sb = new StringBuilder();
            importsList.sort((e1, e2) -> e1.compareTo((String)e2));
            String lastP2 = "";
            boolean hasImport = false;
            for (String key : importsList) {
                if (!key.startsWith("java.")) continue;
                sb.append("import ");
                sb.append(key);
                sb.append(";\n");
                hasImport = true;
            }
            lastP2 = hasImport ? "" : null;
            for (String key : importsList) {
                int c2;
                if (key.startsWith("java.")) continue;
                int c1 = key.indexOf(".");
                String p2 = c1 > 0 ? ((c2 = key.indexOf(".", c1 + 1)) > 0 ? key.substring(0, c2) : key.substring(0, c1)) : "";
                if (lastP2 != null && !p2.equals(lastP2)) {
                    sb.append("\n");
                }
                lastP2 = p2;
                sb.append("import ");
                sb.append(key);
                sb.append(";\n");
                hasImport = true;
            }
            if (hasImport) {
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    class LabelHolder {
        Label label;
        boolean used = false;

        public LabelHolder(Label label, boolean used) {
            this.label = label;
            this.used = used;
        }

        public String toString() {
            if (TinyASMifier.this.labelNames != null && TinyASMifier.this.labelNames.containsKey(this.label) && TinyASMifier.this.labelNames.get(this.label).length() > 0) {
                TinyASMifier.this.stringBuilder.setLength(0);
                String labelName = TinyASMifier.this.labelNames.get(this.label);
                if (!this.used) {
                    TinyASMifier.this.stringBuilder.append("\t\tLabel ").append(labelName).append(" = new Label();\n");
                }
                TinyASMifier.this.stringBuilder.append("\n");
                TinyASMifier.this.stringBuilder.append(TinyASMifier.this.visitname).append(".visitLabel(");
                TinyASMifier.this.appendLabel(this.label);
                TinyASMifier.this.stringBuilder.append(");\n");
                return TinyASMifier.this.stringBuilder.toString();
            }
            return "";
        }
    }

    class MethodParamterClassesInvokeHolder {
        List<String> classDefinedClassParameterNames;
        Map<String, String> params;

        public MethodParamterClassesInvokeHolder(List<String> classDefinedClassParameterNames, Map<String, String> params) {
            this.classDefinedClassParameterNames = classDefinedClassParameterNames;
            this.params = params;
        }

        public String toString() {
            if (this.params.size() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.classDefinedClassParameterNames.size(); ++i) {
                for (Map.Entry<String, String> entry : this.params.entrySet()) {
                    if (!entry.getValue().equals(this.classDefinedClassParameterNames.get(i))) continue;
                    sb.append(", ");
                    sb.append(entry.getValue());
                }
            }
            return sb.toString();
        }
    }

    class MethodParamterClassesHolder {
        Map<String, String> params;

        public MethodParamterClassesHolder(Map<String, String> params) {
            this.params = params;
        }

        public String toString() {
            if (this.params.size() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < TinyASMifier.this.classDefinedClassParameterNames.size(); ++i) {
                for (Map.Entry<String, String> entry : this.params.entrySet()) {
                    if (!entry.getValue().equals(TinyASMifier.this.classDefinedClassParameterNames.get(i))) continue;
                    sb.append(", ");
                    Object v = TinyASMifier.this.classDefinedClassParameterClasses.get(i);
                    if (v instanceof String) {
                        sb.append("String ");
                    } else if (v instanceof Class) {
                        sb.append("Class<?> ");
                    }
                    sb.append(entry.getValue());
                }
            }
            return sb.toString();
        }
    }
}

