/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinyasm.tools;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RefineCode {
    static final List<String> matches = new ArrayList<String>();
    static final List<String> replaces = new ArrayList<String>();
    static EnumMap<TYPE, String> mat = new EnumMap(TYPE.class);
    static Class<?>[] predefineKnownClasses;

    public static void add(String match, String replace) {
        matches.add(match);
        replaces.add(replace);
    }

    public static String excludeLocalVariable(String input) {
        input = input.replaceAll("methodVisitor.visitLocalVariable[^\\n]*;\\n", "");
        return input;
    }

    public static String excludeLineNumber(String input) {
        input = input.replaceAll("methodVisitor.visitParameter[^\\n]*;\\n", "");
        input = input.replaceAll("methodVisitor.visitFrame[^\\n]*;\\n", "");
        input = input.replaceAll(RefineCode.visit("methodVisitor.visitMaxs", TYPE.INT, TYPE.INT), "methodVisitor.visitMaxs(1, 1);");
        input = input.replaceAll("methodVisitor.visitTypeInsn\\(CHECKCAST, \"\\[Ljava/lang/Object;\"\\);\\nmethodVisitor.visitTypeInsn\\(CHECKCAST, \"\\[Ljava/lang/Object;\"\\);\\n", "methodVisitor.visitTypeInsn(CHECKCAST, \"[Ljava/lang/Object;\");\n");
        input = input.replaceAll("methodVisitor.visitLineNumber\\(([0-9]+), label([0-9]+)\\);", "methodVisitor.visitLineNumber(x,label$2);");
        return input;
    }

    public static String getClasName(CharSequence source) {
        Pattern p = Pattern.compile(RefineCode.visit("cw.visit", TYPE.INT, TYPE.ACCESS, TYPE.CLASSNAME, TYPE.STRING, TYPE.CLASSNAME, TYPE.CLAZZARRAY));
        Matcher m = p.matcher(source);
        if (m.find()) {
            return m.group(3).replaceAll("\"", "").replaceAll("/", ".");
        }
        return null;
    }

    public static String matchTypeDescription(String input) {
        StringBuilder source = new StringBuilder(input);
        Pattern p = Pattern.compile("L[\\w|\\d]+(?:\\/[\\w|\\d|\\/]+)*;");
        Matcher m = p.matcher(source);
        while (m.find()) {
            for (int i = m.start(); i < m.end(); ++i) {
                if (source.charAt(i) != '/') continue;
                source.setCharAt(i, '.');
            }
        }
        return source.toString().replaceAll("L([\\w|\\d]+(?:\\.[\\w|\\d|\\/]+)*);", "$1");
    }

    public static String matchTypeInternalNameToClassName(String input) {
        StringBuilder source = new StringBuilder(input);
        Pattern p = Pattern.compile("\\\"[\\w|\\d]+(?:\\/[\\w|\\d|\\/]+)*\\\"");
        Matcher m = p.matcher(source);
        while (m.find()) {
            for (int i = m.start(); i < m.end(); ++i) {
                if (source.charAt(i) != '/') continue;
                source.setCharAt(i, '.');
            }
        }
        return source.toString();
    }

    public static void prepareMatches() {
        RefineCode.add("package (?:[\\w|\\.|\\d]+);\\n", "");
        RefineCode.add("import java.util.*;\\n", "");
        RefineCode.add("import org.objectweb.asm.*;\\n", "");
        RefineCode.add("public class (?:[\\w|\\.|\\d]+) implements Opcodes \\{\\n", "");
        RefineCode.add("public static byte\\[\\] dump \\(\\) throws Exception \\{\\n", "");
        RefineCode.add("ClassWriter cw = new ClassWriter\\(0\\);\\n", "");
        RefineCode.add("FieldVisitor fv;\\n", "");
        RefineCode.add("MethodVisitor mv;\\n", "");
        RefineCode.add("AnnotationVisitor av0;\\n", "");
        RefineCode.add("cw.visitEnd\\(\\);\\n", "");
        RefineCode.add("return cw.toByteArray\\(\\);\\n", "return cw.end().toByteArray();\n");
        RefineCode.add(RefineCode.visit("cw.visitInnerClass", TYPE.STRING, TYPE.STRING, TYPE.STRING, TYPE.ACCESS), "cw.referInnerClass($2,$3);/*$4*/\n");
        RefineCode.add(RefineCode.visit("cw.visit", TYPE.INT, TYPE.NORMAL_CLASS_ACCESS, TYPE.CLASSNAME, TYPE.STRING, TYPE.CLASSNAME, TYPE.CLAZZARRAY), "ClassBody cw = ClassBuilder.make($3).eXtend($5).body()/*$4 $6*/;");
        RefineCode.add(RefineCode.visit("cw.visit", TYPE.INT, TYPE.ACCESS, TYPE.CLASSNAME, TYPE.CLASSNAME, TYPE.CLASSDESCRIPTION, TYPE.CLAZZARRAY), "ClassBody cw = ClassBuilder.make($2,$3).eXtend($5).body()/*$4 $6*/;");
        RefineCode.add(".eXtend\\(\\\"java/lang/Object\\\"\\)", "");
        RefineCode.add("cw.visitSource\\(" + mat.get((Object)TYPE.STRING) + ", null\\);\n", "");
        RefineCode.add(RefineCode.visit("fv = cw.visitField", TYPE.ACCESS, TYPE.STRING, TYPE.STRING, TYPE.STRING, TYPE.STRING), "cw.field($1,$2,$3);\n");
        RefineCode.add("fv.visitEnd\\(\\);\n", "");
        RefineCode.add(RefineCode.visit("mv = cw.visitMethod", TYPE.ACC_PUBLIC, TYPE.STRING, TYPE.PARAMS_RET, TYPE.STRING, TYPE.CLAZZARRAY), "cw.method($2).parameter(\"name\",\"$3\").reTurn(\"$4\")/*$5*//*$6*/\n");
        RefineCode.add(RefineCode.visit("mv = cw.visitMethod", TYPE.ACCESS, TYPE.STRING, TYPE.PARAMS_RET, TYPE.STRING, TYPE.CLAZZARRAY), "cw.method($1,$2).parameter(\"name\",\"$3\").reTurn(\"$4\")/*$5*//*$6*/\n");
        RefineCode.add("methodVisitor.visitCode\\(\\);", ".code(mv -> {");
        RefineCode.add("methodVisitor.visitEnd\\(\\);", "});");
        RefineCode.add("\\.reTurn\\(V\\)", "");
        RefineCode.add("/\\*null\\*/", "");
        RefineCode.add(".parameter\\(\\\"name\\\",\\\"\\\"\\)", "");
        RefineCode.add("Label l\\d* = new Label\\(\\);\n", "");
        RefineCode.add("methodVisitor.visitLabel\\(l\\d*\\);\n", "");
        RefineCode.add(RefineCode.visit("methodVisitor.visitLabel", TYPE.NAME), "");
        RefineCode.add(RefineCode.visit("methodVisitor.visitLineNumber", TYPE.INT, TYPE.NAME), "methodVisitor.line();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitMaxs", TYPE.INT, TYPE.INT), "");
        RefineCode.add(RefineCode.visit("methodVisitor.visitTypeInsn", "NEW", TYPE.STRING), "methodVisitor.NEW($1);\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "DUP", new TYPE[0]), "methodVisitor.DUP();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "POP", new TYPE[0]), "methodVisitor.POP();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "RETURN", new TYPE[0]), "methodVisitor.RETURN();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "[A|I|L|F|D]RETURN", new TYPE[0]), "methodVisitor.RETURNTop();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitVarInsn", "[A|I|L|F|D]LOAD", TYPE.INT), "methodVisitor.LOAD($1);\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitVarInsn", "[A|I|L|F|D]STORE", TYPE.INT), "methodVisitor.STORE($1);\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "AASTORE", new TYPE[0]), "methodVisitor.ARRAYSTORE();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "ATHROW", new TYPE[0]), "methodVisitor.ATHROW();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "[A|I|L|F|D]ADD", new TYPE[0]), "methodVisitor.ADD();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "[A|I|L|F|D]SUB", new TYPE[0]), "methodVisitor.SUB();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "[A|I|L|F|D]MUL", new TYPE[0]), "methodVisitor.MUL();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "[A|I|L|F|D]DIV", new TYPE[0]), "methodVisitor.DIV();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "[A|I|L|F|D]REM", new TYPE[0]), "methodVisitor.REM();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "[A|I|L|F|D]AND", new TYPE[0]), "methodVisitor.AND();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "[A|I|L|F|D]OR", new TYPE[0]), "methodVisitor.OR();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "[A|I|L|F|D]XOR", new TYPE[0]), "methodVisitor.XOR();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "[A|I|L|F|D]SHL", new TYPE[0]), "methodVisitor.SHL();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "[A|I|L|F|D]SHR", new TYPE[0]), "methodVisitor.SHR();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitInsn", "(\\w2\\w)", new TYPE[0]), "methodVisitor.$1();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitIntInsn", "BIPUSH", TYPE.INT), "methodVisitor.LOADConst($1);\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitTypeInsn", "NEW", TYPE.STRING), "methodVisitor.NEW($1);\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitTypeInsn", "CHECKCAST", TYPE.STRING), "methodVisitor.CHECKCAST($1);\n");
        RefineCode.add("methodVisitor.visitInsn\\(ICONST_(\\d*)\\);\n", "methodVisitor.LOADConst($1);\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitFieldInsn", "PUTSTATIC", TYPE.STRING, TYPE.STRING, TYPE.STRING), "methodVisitor.PUTSTATIC($1,$2,$3);\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitFieldInsn", "GETSTATIC", TYPE.STRING, TYPE.STRING, TYPE.STRING), "methodVisitor.GETSTATIC($1,$2,$3);\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitFieldInsn", "PUTFIELD", TYPE.STRING, TYPE.STRING, TYPE.STRING), "methodVisitor.PUTFIELD($2,$3);\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitFieldInsn", "GETFIELD", TYPE.STRING, TYPE.STRING, TYPE.STRING), "methodVisitor.GETFIELD($2,$3);\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitLdcInsn", TYPE.STRING), "methodVisitor.LOADConst($1);\n");
        RefineCode.add("methodVisitor.visitLdcInsn\\((new Long\\(\\d*L\\))\\);", "methodVisitor.LOADConst($1);\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitLocalVariable", "\\\"this\\\"", TYPE.STRING, TYPE.STRING, TYPE.NAME, TYPE.NAME, TYPE.INT), "");
        RefineCode.add(RefineCode.visit("methodVisitor.visitLocalVariable", TYPE.STRING, TYPE.STRING, TYPE.STRING, TYPE.NAME, TYPE.NAME, TYPE.INT), "methodVisitor.define($1,$2);/*$6*/\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitMethodInsn", "INVOKESPECIAL", TYPE.STRING, TYPE.STRING, TYPE.PARAMS_RET, TYPE.BOOLEAN), "methodVisitor.SPECIAL($1,$2).parameter(\"$3\").reTurn(\"$4\").INVOKE();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitMethodInsn", "INVOKESTATIC", TYPE.STRING, TYPE.STRING, TYPE.PARAMS_RET, TYPE.BOOLEAN), "methodVisitor.STATIC($1,$2).parameter(\"$3\").reTurn(\"$4\").INVOKE();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitMethodInsn", "INVOKEVIRTUAL", TYPE.STRING, TYPE.STRING, TYPE.PARAMS_RET, TYPE.BOOLEAN), "methodVisitor.VIRTUAL($1,$2).parameter(\"$3\").reTurn(\"$4\").INVOKE();\n");
        RefineCode.add(RefineCode.visit("methodVisitor.visitMethodInsn", "INVOKEINTERFACE", TYPE.STRING, TYPE.STRING, TYPE.PARAMS_RET, TYPE.BOOLEAN), "methodVisitor.INTERFACE($1,$2).parameter(\"$3\").reTurn(\"$4\").INVOKE();\n");
        RefineCode.add("\\.parameter\\(\"\"\\)", "");
        RefineCode.add("\\.parameter\\(\"J\"\\)", ".parameter(long.class)");
        RefineCode.add("\\.parameter\\(\"I\"\\)", ".parameter(int.class)");
        RefineCode.add("\\.reTurn\\(\"V\"\\)", "");
        RefineCode.add("\\.reTurn\\(\"Z\"\\)", ".reTurn(boolean.class)");
        RefineCode.add("\\.reTurn\\(\"I\"\\)", ".reTurn(int.class)");
        RefineCode.add("\\.reTurn\\(\"J\"\\)", ".reTurn(long.class)");
        RefineCode.add("\\\"Ljava/lang/String;\\\"", "String.class");
        RefineCode.add("\\\"Ljava/lang/Object;\\\"", "Object.class");
        RefineCode.add("\\\"java/lang/String\\\"", "String.class");
        RefineCode.add("\\\"java/lang/Object\\\"", "Object.class");
    }

    public static String refineCode(String source, Class<?> ... KnownClasses) {
        String clzname;
        String iname;
        String string;
        String classname = RefineCode.getClasName(source);
        source = RefineCode.replaceAll(source);
        for (Class<?> clazz : KnownClasses) {
            string = clazz.getName();
            iname = string.replace(".", "/");
            clzname = string.substring(string.lastIndexOf(46) + 1, string.length());
            source = source.replaceAll("\\\"L" + iname + ";\\\"", clzname + ".class");
            source = source.replaceAll("\\\"" + iname + "\\\"", clzname + ".class");
        }
        for (Class<?> clazz : predefineKnownClasses) {
            string = clazz.getName();
            iname = string.replace(".", "/");
            clzname = string.substring(string.lastIndexOf(46) + 1, string.length());
            source = source.replaceAll("\\\"L" + iname + ";\\\"", clzname + ".class");
            source = source.replaceAll("\\\"" + iname + "\\\"", clzname + ".class");
        }
        source = RefineCode.matchTypeInternalNameToClassName(source);
        source = RefineCode.matchTypeDescription(source);
        source = source.replaceAll("\\\"" + classname + "\\\"", "clazz");
        source = "String clazz = \"" + classname + "\";" + source;
        return source;
    }

    public static String replaceAll(String input) {
        for (int i = 0; i < matches.size(); ++i) {
            input = input.replaceAll(matches.get(i), replaces.get(i));
        }
        return input;
    }

    public static String skipToString(String input) {
        return input;
    }

    public static String visit(String method, String opcode, TYPE ... params) {
        StringBuilder sb = new StringBuilder();
        sb.append(method);
        sb.append("\\(");
        sb.append(opcode);
        for (int i = 0; i < params.length; ++i) {
            sb.append(",(?: ?)");
            sb.append(mat.get((Object)params[i]));
        }
        sb.append("\\);\n");
        return sb.toString();
    }

    public static String visit(String method, TYPE ... params) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(method);
        sb.append("\\(");
        for (i = 0; i < params.length && i < 1; ++i) {
            sb.append(mat.get((Object)params[i]));
        }
        for (i = 1; i < params.length; ++i) {
            sb.append(",(?: ?)");
            sb.append(mat.get((Object)params[i]));
        }
        sb.append("\\);\n");
        return sb.toString();
    }

    static {
        mat.put(TYPE.STRING, "((?:\\\"[^\\\"]*\\\")|null)");
        mat.put(TYPE.NAME, "([\\w|_|\\d]+)");
        mat.put(TYPE.INT, "([\\d]+)");
        mat.put(TYPE.ACCESS, "([\\w|_]+(?: \\+ [\\w|_]+)*)");
        String matchInntenalName = "(?:[\\w\\d_]+(?:\\/[\\w\\d_]+)*)";
        String matchObjectDescription = "(?:L" + matchInntenalName + ";)";
        String matchObjectDescriptionOrPrimary = "(?:" + matchObjectDescription + "|\\w)";
        String matchObjectDescriptionWithArray = "(?:\\[?" + matchObjectDescriptionOrPrimary + ")";
        String matchObjectDescriptionGeneric = "(?:" + matchObjectDescriptionWithArray + "(?:<" + matchObjectDescriptionWithArray + "+>)?)";
        mat.put(TYPE.PARAMS_RET, "\\\"\\((" + matchObjectDescriptionGeneric + "*)\\)(" + matchObjectDescriptionGeneric + ")\\\"");
        mat.put(TYPE.CLASSDESCRIPTION, "(\\\"" + matchObjectDescriptionGeneric + "*\\\")");
        mat.put(TYPE.CLASSNAME, "(\\\"" + matchInntenalName + "\\\")");
        mat.put(TYPE.BOOLEAN, "(true|false)");
        mat.put(TYPE.CLAZZARRAY, "((?:new String\\[\\] \\{ \\\"[\\d|\\w|\\.\\/]*\\\" \\})|null)");
        mat.put(TYPE.NORMAL_CLASS_ACCESS, "(ACC_PUBLIC \\+ ACC_SUPER)");
        mat.put(TYPE.ACC_PUBLIC, "(ACC_PUBLIC)");
        RefineCode.prepareMatches();
        predefineKnownClasses = new Class[]{String.class, List.class, ArrayList.class, Map.class, HashMap.class};
    }

    static enum TYPE {
        STRING,
        NAME,
        INT,
        ACCESS,
        PARAMS_RET,
        BOOLEAN,
        CLAZZARRAY,
        NORMAL_CLASS_ACCESS,
        ACC_PUBLIC,
        CLASSDESCRIPTION,
        CLASSNAME;

    }
}

