/*
 * Decompiled with CFR 0.152.
 */
package cn.sj1.tinyasm.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClassSignature
extends SignatureVisitor {
    static Logger logger = LoggerFactory.getLogger(ClassSignature.class);
    int level = 0;
    boolean array = false;
    List<StringBuilder> paramsClassList = new ArrayList<StringBuilder>();
    StringBuilder returnClass;
    StringBuilder superClass;
    List<StringBuilder> interfacesClassList = new ArrayList<StringBuilder>();
    List<StringBuilder> typeParameterClassList = new ArrayList<StringBuilder>();
    Map<String, String> classParameters;
    Map<String, String> methodUsedClassParameters;
    String header = "root";
    static final char DEFAULT_TypeArgument = '\u0000';
    char typeArgument = '\u0000';
    StringBuilder sb;
    Map<String, String> referedTypes;

    String indent() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.level; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }

    ClassSignature(int api, Map<String, String> tiny_referedTypes) {
        super(api);
        this.referedTypes = tiny_referedTypes;
    }

    ClassSignature(int api, Map<String, String> classParameters, Map<String, String> methodUsedClassParameters, Map<String, String> tiny_referedTypes) {
        super(api);
        this.referedTypes = tiny_referedTypes;
        this.classParameters = classParameters;
        this.methodUsedClassParameters = methodUsedClassParameters;
    }

    public void visitFormalTypeParameter(String name) {
        logger.trace("{}visitFormalTypeParameter({})", (Object)this.indent(), (Object)name);
        this.sb = new StringBuilder();
        this.typeParameterClassList.add(this.sb);
        this.sb.append("\"");
        this.sb.append(name);
        this.sb.append("\"");
        this.sb.append(", ");
        this.array = false;
        this.typeArgument = '\u0000';
        super.visitFormalTypeParameter(name);
    }

    public SignatureVisitor visitClassBound() {
        logger.trace("{}visitClassBound()", (Object)this.indent());
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        logger.trace("{}visitInterfaceBound()", (Object)this.indent());
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        logger.trace("{}visitSuperclass()", (Object)this.indent());
        this.sb = this.superClass = new StringBuilder();
        this.array = false;
        this.typeArgument = '\u0000';
        return this;
    }

    public SignatureVisitor visitInterface() {
        logger.trace("{}visitInterface()", (Object)this.indent());
        this.sb = new StringBuilder();
        this.interfacesClassList.add(this.sb);
        this.array = false;
        this.typeArgument = '\u0000';
        return this;
    }

    public SignatureVisitor visitParameterType() {
        logger.trace("{}visitParameterType()", (Object)this.indent());
        this.sb = new StringBuilder();
        this.paramsClassList.add(this.sb);
        this.array = false;
        this.typeArgument = '\u0000';
        return this;
    }

    public SignatureVisitor visitReturnType() {
        logger.trace("{}visitReturnType()", (Object)this.indent());
        this.sb = this.returnClass = new StringBuilder();
        this.array = false;
        this.typeArgument = '\u0000';
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        logger.trace("{}visitExceptionType()", (Object)this.indent());
        return this;
    }

    public void visitBaseType(char descriptor) {
        logger.trace("{}visitBaseType({})", (Object)this.indent(), (Object)Character.valueOf(descriptor));
        Type type = Type.getType((String)String.valueOf(descriptor));
        String className = type.getClassName();
        if (!this.array) {
            this.sb.append("Clazz.of(");
            this.sb.append(ClassSignature.toSimpleName(className));
            this.sb.append(".class");
            this.sb.append(")");
        } else {
            this.sb.append("Clazz.of(");
            this.sb.append(ClassSignature.toSimpleName(className));
            this.sb.append("[]");
            this.sb.append(".class");
            this.sb.append(")");
        }
    }

    public void visitTypeVariable(String name) {
        logger.trace("{}visitTypeVariable({})", (Object)this.indent(), (Object)name);
        if (this.typeArgument > '\u0000') {
            this.sb.append("Clazz.typeArgument(");
            if (this.typeArgument != '=') {
                this.sb.append("'");
                this.sb.append(this.typeArgument);
                this.sb.append("'");
                this.sb.append(", ");
            }
            this.sb.append("Clazz.typeVariableOf(\"");
            this.sb.append(name);
            this.sb.append("\"");
            if (this.array) {
                this.sb.append(", true");
            }
            this.sb.append(")");
            this.sb.append(")");
        } else {
            this.sb.append("Clazz.typeVariableOf(\"");
            this.sb.append(name);
            this.sb.append("\"");
            if (this.array) {
                this.sb.append(", true");
            }
            this.sb.append(")");
        }
        this.typeArgument = '\u0000';
    }

    public SignatureVisitor visitArrayType() {
        this.array = true;
        logger.trace("{}visitArrayType()", (Object)this.indent());
        return this;
    }

    static String toSimpleName(String str) {
        return str.substring(str.lastIndexOf(46) + 1, str.length());
    }

    public void visitClassType(String name) {
        logger.trace("{}visitClassType({})", (Object)this.indent(), (Object)name);
        ++this.level;
        if (this.typeArgument > '\u0000' && this.typeArgument != '=') {
            this.sb.append("Clazz.typeArgument(");
            if (this.typeArgument != '=') {
                this.sb.append("'");
                this.sb.append(this.typeArgument);
                this.sb.append("'");
                this.sb.append(", ");
            }
            String className = name.replace('/', '.');
            if (this.classParameters != null && this.classParameters.containsKey(className)) {
                this.methodUsedClassParameters.put(className, this.classParameters.get(className));
                if (!this.array) {
                    this.sb.append(this.classParameters.get(className));
                } else {
                    this.sb.append("Clazz.of(");
                    this.sb.append(this.classParameters.get(className));
                    this.sb.append(", true");
                    this.sb.append(")");
                }
            } else if (!this.array) {
                this.referedTypes.put(className, "");
                this.sb.append(ClassSignature.toSimpleName(className));
                this.sb.append(".class");
            } else {
                this.referedTypes.put(className, "");
                this.sb.append("Clazz.of(");
                this.sb.append(ClassSignature.toSimpleName(className));
                this.sb.append("[]");
                this.sb.append(".class");
                this.sb.append(")");
            }
        } else {
            String className = name.replace('/', '.');
            this.sb.append("Clazz.of(");
            if (this.classParameters != null && this.classParameters.containsKey(className)) {
                this.methodUsedClassParameters.put(className, this.classParameters.get(className));
                if (!this.array) {
                    this.sb.append(this.classParameters.get(className));
                } else {
                    this.sb.append(this.classParameters.get(className));
                    this.sb.append(", true");
                }
            } else {
                this.referedTypes.put(className, "");
                if (!this.array) {
                    this.sb.append(ClassSignature.toSimpleName(className));
                    this.sb.append(".class");
                } else {
                    this.sb.append(ClassSignature.toSimpleName(className));
                    this.sb.append("[]");
                    this.sb.append(".class");
                }
            }
        }
        this.typeArgument = '\u0000';
    }

    public void visitInnerClassType(String name) {
        logger.trace("{}visitInnerClassType({})", (Object)this.indent(), (Object)name);
    }

    public void visitTypeArgument() {
        logger.trace("{}visitTypeArgument()", (Object)this.indent());
        this.array = false;
        this.sb.append(", Clazz.typeUnboundedTypeArgument()");
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        logger.trace("{}visitTypeArgument({})", (Object)this.indent(), (Object)Character.valueOf(wildcard));
        this.sb.append(", ");
        this.typeArgument = wildcard;
        return this;
    }

    public void visitEnd() {
        this.sb.append(")");
        this.array = false;
        --this.level;
        logger.trace("{}visitEnd()", (Object)this.indent());
        super.visitEnd();
    }

    public String toString() {
        return this.sb.toString();
    }
}

